#!/bin/bash
set -x
#获取新版本agent shell脚本

# 1.解压当前版本包
# 2.解压agent安装包
# 3.转储新脚本
# 4.安装新agent

GNB_PKG_REL_PATH="/yzmm/sw_pkg/" #协议栈软件安装包发布路径
GNB_UNZIP_PKG_PATH="/yzmm/GnbUnzipDir" #基站软件包临时解压路径
AGENT_UNZIP_PKG_PATH="/yzmm/AgentUnzipDir" #agent软件包临时解压路径

SCRIPT_PATH="/yzmm/agent_shell_script" #脚本路径

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}

InitDir(){
    if [ -d $1 ];then
        echo "存在${1}路径，清空路径下内容"
        clearFiles $1
    else
        echo "不存在${1}路径，初始化目录"
        mkdir -p $1
    fi
}

saveNewShFile(){
    echo "转储$1 agent 脚本文件"
    if [ -d "$1" ]; then
        find "$1" -type f -name "*.sh" \
        ! -name "regist-service.sh" \
        ! -name "release-clean.sh" \
        ! -name "release-service.sh" | while IFS= read -r file; do
            filename=$(basename "$file")
            cp "${1}/${filename}" "${SCRIPT_PATH}"
            echo "转储${filename} agent 脚本文件成功"
        done
    fi
}

saveAgentTool(){
    echo "转储$1 agent 工具"
    cp ${1}/GnbUpgrade ${SCRIPT_PATH}
    cp ${1}/YamlTool ${SCRIPT_PATH}
    echo "转储${1}/GnbUpgrade ${1}/YamlTool 成功"
}



if [ -z "$1" ];then
    echo "请输入版本包名称"
    exit 1
else
    PKG_PATH=${GNB_PKG_REL_PATH}${1} #软件包绝对路径
fi

if [ -z "$2" ];then
    echo "请输入内部版本号"
    exit 1
else
    CUR_INNER_VER_ID=$2
fi

if [ -f ${PKG_PATH} ];then
    InitDir ${GNB_UNZIP_PKG_PATH}
    InitDir ${AGENT_UNZIP_PKG_PATH}
    unzip -o ${PKG_PATH} -d ${GNB_UNZIP_PKG_PATH}
    if [ $? -ne 0 ]; then  
        echo "解压失败"  
        exit 16
    fi  
    echo "解压${PKG_PATH}至${GNB_UNZIP_PKG_PATH}"
    find "$GNB_UNZIP_PKG_PATH" -type f -name "gnb_agent*" | while IFS= read -r file; do  
		filename=$(basename "$file")
        filename_without_extension="${filename%.*}"
		tar vfx "$GNB_UNZIP_PKG_PATH"/"$filename" -C "$AGENT_UNZIP_PKG_PATH"
        # 查看内部版本号，只取比当前版本高的脚本文件
        DEST_INNER_VER_ID=$(awk -F'=' '/^inner_ver_id=/ {print $2}' ${AGENT_UNZIP_PKG_PATH}/${filename_without_extension}/verinfo.ini)
        if [ -z ${DEST_INNER_VER_ID} ];then
            echo "无效的agent版本包，没有找到内部版本信息文件"
        else
            echo "目标版本agent内部版本号: ${DEST_INNER_VER_ID}"
            echo "当前版本agent内部版本号: ${CUR_INNER_VER_ID}"
            if (( CUR_INNER_VER_ID <= DEST_INNER_VER_ID ));then
                echo "目标版本为新版本,转储新安装、卸载、回退脚本"
                InitDir ${SCRIPT_PATH}
                saveNewShFile ${AGENT_UNZIP_PKG_PATH}/${filename_without_extension}
                saveAgentTool ${AGENT_UNZIP_PKG_PATH}/${filename_without_extension}
            else
                echo "目标版本为低版本，无需获取脚本文件"
            fi
            chmod 777 ${SCRIPT_PATH}/*
        fi
        clearFiles ${GNB_UNZIP_PKG_PATH}
        clearFiles ${AGENT_UNZIP_PKG_PATH}
        break
	done
fi

