#!/bin/bash
# 回退基站软件
SCRIPT_PATH="/yzmm/agent_shell_script"                                  #脚本路径
BACKUP_DIR="/yzmm/gnb_bak"                                        #软件版本备份路径
INSTALL_PATH="/yzmm/gnb"                                          #软件版本安装路径
VERSION_FILE_PATH="${INSTALL_PATH}/rel/version.yaml"                 #版本文件路径
BASESERVICE_SERVICE_FILE_PATH="/yzmm/gnb/baseService/baseservice.service"                    #baseService 模块服务脚本名称
AGENT_SERVICE_FILE_PATH="/yzmm/gnb/agent/gnb_agent.service"       #gnb_agent服务文件绝对路径
BASESERVICE_SERVICE_FILE_NAME="baseservice.service"                #baseservice服务文件名称
LOGWRITER_SERVICE_FILE_NAME="logwriter.service" #LogWriter 模块服务名称
LOGWRITER_SERVICE_FILE_PATH="/yzmm/gnb/logwriter/logwriter.service" #LogWriter 模块服务配置文件路径
CU_SERVICE_FILE_NAME="cu.service"                                  #cu服务文件名称
DU_SERVICE_FILE_NAME="du.service"                                  #du服务文件名称
PHY_SERVICE_FILE_NAME="phy.service"                                 #phy服务文件名称
AGNET_SERVICE_FILE_NAME="gnb_agent.service"                        #gnb_agent服务文件名称
CU_SERVICE_FILE_PATH="/yzmm/gnb/cu/bin/cu.service"  #CU 模块服务脚本名称
DU_SERVICE_FILE_PATH="/yzmm/gnb/du/bin/du.service"                                      #DU 模块服务脚本名称
PHY_SERVICE_FILE_PATH="/yzmm/gnb/phy/phy.service"    #PHY 模块服务脚本名称
CU_BIN_FILE_PATH="/yzmm/gnb/cu/bin/run.sh"     #CU 运行脚本相对路径
DU_BIN_FILE_PATH="/yzmm/gnb/du/bin/run.sh"  #DU 运行脚本相对路径
PHY_BIN_FILE_PATH="/yzmm/gnb/phy/start_phy.sh"     #PHY 运行脚本相对路径
SERVICE_FILE_PATH=""                                               #服务文件注册路径
SYSREPO_BACKUP_PATH="/yzmm/gnb/sysrepo_bak" ##sysrepo业务配置备份路径
SYSREPO_CFG_TOOL_FILE_PATH="/yzmm/gnb/sysrepocfgtool/sysrepocfgtool.service"               #ai后台服务文件
SYSREPO_CFG_TOOL_INSTALL_PATH=${ALL_INSTALL_PATH}"/sysrepocfgtool"                         #ai后台服务安装路径
SYSREPO_CFG_TOOL_BAKUP_PATH=${ALL_INSTALL_BAK_PATH}"/sysrepocfgtool"                       #ai后台服务备份路径

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}

CheckSystem(){
    # 校验当前服务器系统是否为aarch64
	if [[ "$(uname -m)" == "aarch64" ]]; then
		SERVICE_FILE_PATH="/lib/systemd/system"
		echo "当前版本服务文件根目录："${SERVICE_FILE_PATH}  
	else
		echo "安装失败：无法确定操作系统类型"  
		exit 5
	fi
	if [ ! -d ${SERVICE_FILE_PATH} ];then
		echo "安装失败：服务路径不存在"
		exit 6
	fi
    echo "服务注册路径:"$SERVICE_FILE_PATH

    if [ ! -f "${BACKUP_DIR}/version.yaml" ];then
        echo "回退失败,没有待回退的版本或备份"
        exit 12
    fi
}

CheckShFile(){
    if [ ! -f "${SCRIPT_PATH}/yangCfg_uninstall.sh" ] ||
        [ ! -f "${SCRIPT_PATH}/yangCfg_install.sh" ];then
        echo "缺少回退关键脚本,回退失败"
        exit 8
    fi
}

StopGnbService(){
    # 停止三层、baseService服务
    #CU
    KillGnbModule "cu.service" "gnb_cu"
    #DU
    KillGnbModule "du.service" "gnb_du"
    #baseService
    KillGnbModule "baseservice.service" "baseService"
    #logWriter
    KillGnbModule "logwriter.service" "LogWriter"
    #sysrepocfgtool
    KillGnbModule "sysrepocfgtool.service" "sysrepocfgtool"
}

FallbackGnb(){
    # 先检查 $BACKUP_DIR 路径是否存在
    if [ -d "$BACKUP_DIR" ]; then
        echo "回退新版本"
        # 将备份目录下的内容转储到执行目录
        removeDir $INSTALL_PATH
        mv $BACKUP_DIR $INSTALL_PATH
        # gnb_agent
        if [ -f "$AGENT_SERVICE_FILE_PATH" ];then
            RegistService ${AGENT_SERVICE_FILE_PATH} "" ${AGNET_SERVICE_FILE_NAME}
            systemctl enable ${AGNET_SERVICE_FILE_NAME}
        fi
        # logWriter
        if [ -f "$LOGWRITER_SERVICE_FILE_PATH" ];then
            RegistService ${LOGWRITER_SERVICE_FILE_PATH} "" ${LOGWRITER_SERVICE_FILE_NAME}
            systemctl enable ${LOGWRITER_SERVICE_FILE_NAME}
            systemctl start ${LOGWRITER_SERVICE_FILE_NAME}
        fi
        # baseservice
        if [ -f "$BASESERVICE_SERVICE_FILE_PATH" ];then
            RegistService ${BASESERVICE_SERVICE_FILE_PATH} "" ${BASESERVICE_SERVICE_FILE_NAME}
            systemctl enable ${BASESERVICE_SERVICE_FILE_NAME}
            systemctl start ${BASESERVICE_SERVICE_FILE_NAME}
        fi
        # sysrepocfgtool
        if [ -f "$SYSREPO_CFG_TOOL_FILE_PATH" ];then
            RegistService ${SYSREPO_CFG_TOOL_FILE_PATH} "" ${SYSREPO_CFG_TOOL_FILE_NAME}
        fi
    else
        echo "回退失败,没有待回退的版本或备份"
        exit 12
    fi
}

InstallGnbSoftwareService(){
    removeFile $SERVICE_FILE_PATH/$CU_SERVICE_FILE_NAME
    RegistService ${CU_SERVICE_FILE_PATH} ${CU_BIN_FILE_PATH} ${CU_SERVICE_FILE_NAME}
    systemctl disable ${CU_SERVICE_FILE_NAME}
    
    removeFile $SERVICE_FILE_PATH/$DU_SERVICE_FILE_NAME
    RegistService ${DU_SERVICE_FILE_PATH} ${DU_BIN_FILE_PATH} ${DU_SERVICE_FILE_NAME}
    systemctl disable ${DU_SERVICE_FILE_NAME}
}

FallbackInstallYangFile(){
    "$SCRIPT_PATH"/yangCfg_uninstall.sh 0
    if [ $? != 0 ];then
        exit 11
    fi
    "$SCRIPT_PATH"/yangCfg_install.sh 2
    if [ $? != 0 ];then
        exit $?
    fi
}

# 强杀基站软件服务
KillGnbModule(){
	if [ "${1}" != "" ];then
		status=$(systemctl is-active ${1})
		if [ "${status}" == "active" ];then
			systemctl stop "${1}"          
		fi 
	fi
	PID=$(pgrep -x ${2})
	if [ -n "$PID" ];then
		pkill -9 ${2}         
	fi 
}

# 注册基站软件服务
# 1:SERVICE_FILE_PATH , 2:BIN_PATH, 3:SERVICE_NAME
RegistService(){
	#修改服务文件的启动路径
	# if [ "${2}" != "" ];then
	# 	sed -i "s|^ExecStart=.*$|ExecStart=${1}"/"${2}|"  ${1}"/"${3}
	# fi
	
	#安装基站软件服务
	if [ ! -f "${1}" ];then
		echo "${1}服务文件不存在，安装失败"
		exit 3
	fi

	cp "${1}" ${SERVICE_FILE_PATH}
	echo ${3}"服务注册成功"
}

# 转存备份sysrepo配置
saveSysrepoCfg(){
    echo "回退旧版本sysrepo,转储备份配置至${SYSREPO_BACKUP_PATH}"
    clearFiles ${SYSREPO_BACKUP_PATH}
    mkdir -p ${SYSREPO_BACKUP_PATH}
    cp "$1"/*.xml "${SYSREPO_BACKUP_PATH}/"
}

# 检查环境是否支持回退
CheckSystem

# 检查脚本文件是否存在
CheckShFile

# 停止基站软件服务
StopGnbService

# 回退GNB
FallbackGnb

# 注册基站软件服务
InstallGnbSoftwareService

# 回退安装sysrepo
FallbackInstallYangFile

echo "回退成功"
systemctl daemon-reload
sleep 10
exit 0
