#!/bin/bash
set -x
# 安装基站软件
SCRIPT_PATH="/yzmm/agent_shell_script"                                  #脚本路径
PKG_FILE_NAME=$1                                                       #协议栈软件安装包名
CUR_VERSION=""                                       				   #当前版本
DEST_VERSION=""                                       				   #目标版本
SHOW_VERSION=""                                       				   #外部版本
IS_DB=$2                                                               #sysrepo是否继承配置安装,0:不继承，1继承
ALL_INSTALL_PATH="/yzmm/gnb"                                          #安装总路径
ALL_INSTALL_BAK_PATH="/yzmm/gnb_bak"                                  #安装总备份路径
PKG_PATH="/yzmm/sw_pkg/"${PKG_FILE_NAME}                                 #协议栈软件安装包发布路径
BACKUP_DIR="/yzmm/gnb_bak"    											#协议栈软件版本备份路径

CU_SERVICE_FILE_NAME="cu.service"                                      #CU 模块服务脚本名称
CU_SERVICE_FILE_PATH="/yzmm/gnb/cu/bin/cu.service"             #CU 模块服务脚本相对路径
CU_BIN_FILE_PATH="/yzmm/gnb/cu/bin/run.sh"                     #CU 运行脚本相对路径
CU_CFG_FILE_PATH="/yzmm/gnb/cu/config"                     #CU 配置文件路径

DU_SERVICE_FILE_NAME="du.service"                                      #DU 模块服务脚本名称
DU_SERVICE_FILE_PATH="/yzmm/gnb/du/bin/du.service" #DU 模块服务脚本相对路径
DU_BIN_FILE_PATH="/yzmm/gnb/du/bin/run.sh"         #DU 运行脚本相对路径
DU_CFG_FILE_PATH="/yzmm/gnb/du/config"                     #DU 配置文件路径

PHY_SERVICE_FILE_NAME="phy.service"                                     #PHY 模块服务脚本名称
PHY_SERVICE_FILE_PATH="/yzmm/gnb/phy/phy.service"                         #PHY 模块服务脚本相对路径
PHY_BIN_FILE_PATH="/yzmm/gnb/phy/start_phy.sh"                                 #PHY 运行脚本相对路径
PHY_CFG_FILE_PATH="/yzmm/gnb/phy/resources"                     #PHY 配置文件路径

BASESERVICE_SERVICE_FILE_NAME="baseservice.service"                    #baseService 模块服务脚本名称
BASESERVICE_SERVICE_FILE_PATH="/yzmm/gnb/baseService/baseservice.service"                    #baseService 模块服务脚本路径
BASESERVICE_BIN_FILE_PATH="/yzmm/gnb/baseService/bin/baseService"                            #baseService 运行脚本相对路径
BASESERVICE_INSTALL_PATH=${ALL_INSTALL_PATH}"/baseService"               #baseService软件版本安装路径
BASESERVICE_ZIP_NAME="baseService.zip"                                 #baseService软件包名称相对路径
BASESERVICE_CFG_FILE_PATH="/yzmm/gnb/baseService/config"                                 #baseService配置文件路径

LOGWRITER_SERVICE_FILE_NAME="logwriter.service" #LogWriter 模块服务名称
LOGWRITER_SERVICE_FILE_PATH="/yzmm/gnb/logwriter/logwriter.service" #LogWriter 模块服务配置文件路径
LOGWRITER_BIN_FILE_PATH="/yzmm/gnb/logwriter/bin/LogWriter" #LogWriter 执行文件路径
LOGWRITER_RUN_FILE_PATH="/yzmm/gnb/logwriter/bin/run.sh" #LogWriter 启动文件路径
LOGWRITER_INSTALL_PATH=${ALL_INSTALL_PATH}"/logwriter"               #logWriter软件版本安装路径
LOGWRITER_ZIP_NAME="logWriter.zip"                                 #logWriter软件包名称相对路径
LOGWRITER_CFG_FILE_PATH="/yzmm/gnb/logwriter/ConfigFile"                                 #logwriter配置文件路径

AGENT_SERVICE_FILE_NAME="gnb_agent.service"							   #gnb_agent模块服务脚本名称
AGENT_SERVICE_FILE_PATH="/yzmm/gnb/agent/gnb_agent.service"							   #gnb_agent模块服务脚本路径
AGENT_INSTALL_PATH=${ALL_INSTALL_PATH}"/agent"                         #gnb_agent安装路径
AGENT_BAKUP_PATH=${ALL_INSTALL_BAK_PATH}"/agent"                       #gnb_agent备份路径

SYSREPO_CFG_TOOL_FILE_NAME="sysrepocfgtool.service"                    #ai后台服务文件
SYSREPO_CFG_TOOL_FILE_PATH="/yzmm/gnb/sysrepocfgtool/sysrepocfgtool.service"               #ai后台服务文件
SYSREPO_CFG_TOOL_INSTALL_PATH=${ALL_INSTALL_PATH}"/sysrepocfgtool"                         #ai后台服务安装路径
SYSREPO_CFG_TOOL_BAKUP_PATH=${ALL_INSTALL_BAK_PATH}"/sysrepocfgtool"                       #ai后台服务备份路径

SERVICE_FILE_PATH=""                                                   #系统服务文件根目录

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}


# 检查当前环境是否支持gnb安装、升级以及shell脚本是否存在
CheckSystemAndShellFileExist(){
	# 校验当前服务器系统是否为aarch64
	if [[ "$(uname -m)" == "aarch64" ]]; then
		SERVICE_FILE_PATH="/lib/systemd/system"
		echo "当前版本服务文件根目录："${SERVICE_FILE_PATH}  
	else
		echo "安装失败：无法确定操作系统类型"  
		exit 5
	fi
	if [ ! -d ${SERVICE_FILE_PATH} ];then
		echo "安装失败：服务路径不存在"
		exit 6
	fi
}

CheckShFile(){
	if [ ! -f "${SCRIPT_PATH}/gnb_uninstall.sh" ] || 
		[ ! -f "${SCRIPT_PATH}/yangCfg_uninstall.sh" ] || 
		[ ! -f "${SCRIPT_PATH}/yangCfg_install.sh" ];then
		echo "缺少安装、升级关键脚本，安装、升级失败退出"
		exit 8
	fi
}

# 停止三层、baseService服务、logWriter服务
StopGnbService(){
	#CU
	KillGnbModule "cu.service" "gnb_cu"
	#DU
	KillGnbModule "du.service" "gnb_du"
	#PHY
	# KillGnbModule "phy.service" ""
	#baseService
	KillGnbModule "baseservice.service" "baseService"
	# LogWriter
	KillGnbModule "logwriter.service" "LogWriter"
}

#卸载版本
UninstallGnb(){
	echo "卸载Gnb"
	if [ $IS_DB == 1 ];then
		${SCRIPT_PATH}"/gnb_uninstall.sh" 0 2
		UNINSTALL_RES=$?
	else
		${SCRIPT_PATH}"/gnb_uninstall.sh" 0 1
		UNINSTALL_RES=$?
	fi
	if [ ${UNINSTALL_RES} != 0 ];then
		echo "卸载失败，退出安装"
		exit 7
	fi
}

# 解压安装基站软件版本
UnzipInstallGnb(){
	if [ ! -d $ALL_INSTALL_PATH ];then
		mkdir -p ${ALL_INSTALL_PATH}
	else
		echo "清空cu目录"
		clearFiles ${ALL_INSTALL_PATH}/cu
		echo "清空du目录"
		clearFiles ${ALL_INSTALL_PATH}/du
		echo "清空phy目录"
		clearFiles ${ALL_INSTALL_PATH}/phy
	fi
	
	unzip -o ${PKG_PATH} -d ${ALL_INSTALL_PATH}
	if [ $? -ne 0 ]; then  
		echo "解压失败,回退版本" 
		"$SCRIPT_PATH/gnb_fallback.sh"
		if [ $? != 0 ];then
			echo "回退失败"
		else
			echo "回退成功"
		fi
		exit 16
	fi  
	DEST_VERSION=$(awk -F'=' '/^version=/ {print $2}' ${ALL_INSTALL_PATH}/gnb-swd.ini)
	SHOW_VERSION=$(awk -F'=' '/^showVersion=/ {print $2}' ${ALL_INSTALL_PATH}/gnb-swd.ini)
	echo "解压基站软件包成功"

	if [ -z ${DEST_VERSION} ] ||
	[ -z ${SHOW_VERSION} ] ||
	[ ! -f "$ALL_INSTALL_PATH/$BASESERVICE_ZIP_NAME" ] ||
	! find ${ALL_INSTALL_PATH} -type f -name 'gnb_agent-*.tar' | grep -q .;then
		echo "无效的版本包,退出安装，回退版本"
		"$SCRIPT_PATH/gnb_fallback.sh"
		if [ $? != 0 ];then
			echo "回退失败"
		else
			echo "回退成功"
		fi
		exit 9
	fi
}

# 基站软件服务
InstallGnbSoftwareService(){
	#执行文件赋权限
	find $ALL_INSTALL_PATH -exec chmod 755 {} \;
	RegistService ${CU_SERVICE_FILE_PATH}
	systemctl disable ${CU_SERVICE_FILE_NAME}
	
	RegistService ${DU_SERVICE_FILE_PATH}
	systemctl disable ${DU_SERVICE_FILE_NAME}

	#安装LogWriter
	echo "安装LogWriter"
	InstallLogWriter
	# 转储logParse
	if [ ! -d "/data/log/logwriter" ];then
		mkdir -p "/data/log/logwriter"
	fi
	chmod 777 $LOGWRITER_INSTALL_PATH/LogParser*
	chmod 777 $LOGWRITER_INSTALL_PATH/parseLog.bat
	cp $LOGWRITER_INSTALL_PATH/LogParser* "/data/log/"
	cp $LOGWRITER_INSTALL_PATH/parseLog.bat "/data/log/"
	
	#安装baseService
	echo "安装baseService"
	InstallBaseservice

	echo "基站软件服务注册成功"
}

# 定义YAML文件的内容 
BuildVersionFile(){
	CUR_VERSION=$(grep 'version:' /yzmm/gnb_bak/version.yaml | awk '{print $2}')
	echo "当前版本:$CUR_VERSION"
	echo "外部版本:$SHOW_VERSION"
	REL_TIME_STR=$(stat -c %y ${PKG_PATH})
	cat > ${ALL_INSTALL_PATH}"/version.yaml" << EOF
releaseTime: $(echo ${REL_TIME_STR} | sed 's/\..*//')  
installTime: $(date +"%Y-%m-%d %H:%M:%S")  
version: ${DEST_VERSION}
showVersion: ${SHOW_VERSION}
EOF
	echo "版本文件已更新"
	cat ${ALL_INSTALL_PATH}"/version.yaml"
}

# 安装sysrepo配置
InstallSysrepoData(){
	echo "sysrepo配置安装"
	"$SCRIPT_PATH/yangCfg_install.sh" 0  
	YANG_CFG_INSTALL_RES=$?  
	if [ $YANG_CFG_INSTALL_RES -ne 0 ]; then
		echo "sysrepo配置安装失败，回退版本"
		"$SCRIPT_PATH/gnb_fallback.sh"
			if [ $? != 0 ];then
				echo "回退失败"
			else 
				echo "回退成功"
			fi
		exit $YANG_CFG_INSTALL_RES
	fi
}

# 安装agent
InstallAgent(){
	# 解压安装新agent安装包
	removeFile ${SERVICE_FILE_PATH}"/"${AGENT_SERVICE_FILE_NAME}

	# 清空路径
	clearFiles "/yzmm/gnb/agent/"
	mkdir -p $AGENT_INSTALL_PATH

	# 解压安装包
	find "$ALL_INSTALL_PATH" -type f -name "gnb_agent*.tar" | while IFS= read -r file; do  
		filename=$(basename "$file")
		filename_without_extension="${filename%.*}"
		tar vfx "$ALL_INSTALL_PATH"/"$filename" -C "$ALL_INSTALL_PATH"
		mv "$ALL_INSTALL_PATH"/"$filename_without_extension/"* $AGENT_INSTALL_PATH
		rm -rf  "$ALL_INSTALL_PATH"/"$filename"
		rm -rf  "$ALL_INSTALL_PATH"/"$filename_without_extension/"
		rm -rf $AGENT_INSTALL_PATH/update.sh
		rm -rf $AGENT_INSTALL_PATH/install.sh
		rm -rf $AGENT_INSTALL_PATH/installSysrepo.sh
		rm -rf $AGENT_INSTALL_PATH/uninstall.sh
		rm -rf $AGENT_INSTALL_PATH/encrpyt
	done

	RegistService ${AGENT_SERVICE_FILE_PATH}
	systemctl enable ${AGENT_SERVICE_FILE_NAME} 
	# 继承当前用户密码
	if [ -f ${AGENT_BAKUP_PATH}"/lmt-conf/user.json" ];then
		echo "继承LMT用户信息表"
		cp ${AGENT_BAKUP_PATH}/lmt-conf/user.json ${AGENT_INSTALL_PATH}/lmt-conf
	fi
	#安装sysrepocfgtool服务
	tar vfx sysrepoCfgTool-v2.tar
	cd /yzmm/gnb/agent/sysrepoCfgTool-v2
	./install.sh 1
	systemctl disable ${SYSREPO_CFG_TOOL_FILE_NAME}
}



# 注册基站软件服务
# 1:SERVICE_NAME
RegistService(){
	#安装服务
	if [ ! -f ${1} ];then
		echo ${1}服务文件不存在，安装失败
		exit 3
	fi
	# 去除服务文件可执行权限
	chmod a-x ${1}
	cp ${1} ${SERVICE_FILE_PATH}
	echo ${1}"服务注册成功"
}

# 安装baseservice 
InstallBaseservice(){
	if [ -d $BASESERVICE_INSTALL_PATH ];then
		clearFiles $BASESERVICE_INSTALL_PATH
		if [ $? -ne 0 ]; then  
            echo "删除文件失败"
			exit 15
        fi  
		echo "清空$BASESERVICE_INSTALL_PATH/目录"
	else
		mkdir -p $BASESERVICE_INSTALL_PATH
	fi
	unzip -u "/yzmm/gnb/$BASESERVICE_ZIP_NAME" -d "$BASESERVICE_INSTALL_PATH"
	if [ $? -ne 0 ]; then  
		echo "解压baseService失败，回退版本"  
		"$SCRIPT_PATH/gnb_fallback.sh"
		if [ $? != 0 ];then
			echo "回退失败"
		else
			echo "回退成功"
		fi
		exit 16
	fi  

	#执行文件赋权限
	chmod 755 $BASESERVICE_BIN_FILE_PATH

	RegistService $BASESERVICE_SERVICE_FILE_PATH
	systemctl enable $BASESERVICE_SERVICE_FILE_NAME
	systemctl start $BASESERVICE_SERVICE_FILE_NAME

	rm -rf /yzmm/gnb/$BASESERVICE_ZIP_NAME
	echo "安装baseService成功"
}

# 安装logWriter 
InstallLogWriter(){
	if [ -d $LOGWRITER_INSTALL_PATH ];then
		clearFiles $LOGWRITER_INSTALL_PATH
		echo "清空$LOGWRITER_INSTALL_PATH/目录"
	else
		mkdir -p $LOGWRITER_INSTALL_PATH
	fi
	unzip -u "/yzmm/gnb/$LOGWRITER_ZIP_NAME" -d "$LOGWRITER_INSTALL_PATH"
	if [ $? -ne 0 ]; then  
		echo "解压logWriter失败，回退版本"  
		"$SCRIPT_PATH/gnb_fallback.sh"
		if [ $? != 0 ];then
			echo "回退失败"
		else
			echo "回退成功"
		fi
		exit 16
	fi  

	#执行文件赋权限
	chmod 755 $LOGWRITER_BIN_FILE_PATH
	chmod 755 $LOGWRITER_RUN_FILE_PATH
	RegistService $LOGWRITER_SERVICE_FILE_PATH
	systemctl disable ${LOGWRITER_SERVICE_FILE_NAME}

	rm -rf /yzmm/gnb/$LOGWRITER_ZIP_NAME
	echo "安装logWriter成功"
}

# 继承agent配置
UpgradeAgentCfg(){
	if [ -f ${AGENT_BAKUP_PATH}"/conf.yaml" ];then
		echo "继承当前agent配置${1}"
		"$SCRIPT_PATH/YamlTool" -c ${AGENT_BAKUP_PATH}/conf.yaml -d ${1}
		UPDATE_CFG_RES=$?
		echo $UPDATE_CFG_RES
		if [ ${UPDATE_CFG_RES} -ne 0 ];then
			echo "gnb_agent配置继承失败，退出安装"
			exit 4
		fi
		echo "gnb_agent配置继承成功，完成安装"
	else
		echo "未找到"${AGENT_BAKUP_PATH}",无需继承配置"
	fi
}

# 强杀基站软件服务
KillGnbModule(){
	PID=$(pgrep -x "${2}")
	if [ -n "${PID}" ];then
		kill -9 "${PID}"
	fi 

	if [ "${1}" != "" ];then
		status=$(systemctl is-active $1)
		if [ "${status}" == "active" ];then
			systemctl stop "${1}"
		fi
	fi
}

if [ -z "$1" ];then
    echo "请输入基站安装包名"
    exit 1
else
    echo  "基站安装包名:$1"
fi

if [ -z "$2" ];then
    echo "请输入是否继承配置安装标识符,0：不继承，1：继承"
    exit 2
fi

# 环境校验
CheckSystemAndShellFileExist

# 检查脚本文件是否存在
CheckShFile

# 停止基站软件服务
StopGnbService

# 卸载基站版本
UninstallGnb

# 解压安装基站版本
UnzipInstallGnb

# 构建版本文件
BuildVersionFile

# 安装sysrepo
InstallSysrepoData

# 安装基站软件服务
InstallGnbSoftwareService

# 安装agent
InstallAgent

# 配置文件更改权限
chmod 644 $CU_CFG_FILE_PATH/*
chmod 644 $DU_CFG_FILE_PATH/*
chmod 644 $PHY_CFG_FILE_PATH/*
chmod 644 $BASESERVICE_CFG_FILE_PATH/*
chmod 644 $LOGWRITER_CFG_FILE_PATH/*

echo "安装完成"
systemctl daemon-reload
sleep 10
exit 0
