#!/bin/bash
# 卸载基站软件
SCRIPT_PATH="/yzmm/agent_shell_script"
PKG_PATH="/yzmm/sw_pkg"
INSTALL_ALL_PATH="/yzmm/gnb"  #安装总路径
BACKUP_DIR="/yzmm/gnb_bak"    #协议栈软件版本备份路径
AGENT_BAKUP_PATH="$BACKUP_DIR/agent" #gnb_agent回退路径
AGENT_INSTALL_PATH="$INSTALL_ALL_PATH/agent" #gnb_agent安装路径
BASESERVICE_SERVICE_FILE_NAME="baseservice.service"  #baseService 模块服务脚本名称
LOGWRITER_SERVICE_FILE_NAME="logwriter.service" #LogWriter 模块服务名称
CU_SERVICE_FILE="cu.service"  #CU模块服务脚本绝对路径
DU_SERVICE_FILE="du.service"  #DU模块服务脚本绝对路径   
PHY_SERVICE_FILE="phy.service" #PHY模块服务脚本绝对路径 
AGENT_SERVICE_FILE="gnb_agent.service" #gnb_agent模块服务脚本绝对路径
SERVICE_FILE_PATH=""  #服务文件注册路径
SYSREPO_BACKUP_PATH="/yzmm/gnb/sysrepo_bak"
SYSREPO_CFG_TOOL_FILE_NAME="sysrepocfgtool.service"                    #ai后台服务文件
SYSREPO_CFG_TOOL_FILE_PATH="/yzmm/gnb/sysrepocfgtool/sysrepocfgtool.service"               #ai后台服务文件
SYSREPO_CFG_TOOL_INSTALL_PATH=${ALL_INSTALL_PATH}"/sysrepocfgtool"                         #ai后台服务安装路径
SYSREPO_CFG_TOOL_BAKUP_PATH=${ALL_INSTALL_BAK_PATH}"/sysrepocfgtool"                       #ai后台服务备份路径

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}

CheckSystem(){
	# 校验当前服务器系统是否为aarch64
	if [[ "$(uname -m)" == "aarch64" ]]; then
		SERVICE_FILE_PATH="/lib/systemd/system"
		echo "当前版本服务文件根目录："${SERVICE_FILE_PATH}  
	else
		echo "安装失败：无法确定操作系统类型"  
		exit 5
	fi
	if [ ! -d ${SERVICE_FILE_PATH} ];then
		echo "安装失败：服务路径不存在"
		exit 6
	fi
	echo "服务注册路径:"$SERVICE_FILE_PATH
}

CheckShFile(){
	if [ ! -f "${SCRIPT_PATH}/yangCfg_uninstall.sh" ];then
		echo "缺少卸载关键文件，卸载失败"
		exit 8
	fi
}

UninstallGnb(){
	#卸载CU服务
	UninstallGnbService ${CU_SERVICE_FILE} "gnb_cu"
	#卸载DU服务
	UninstallGnbService ${DU_SERVICE_FILE} "gnb_du"
	#卸载baseService
	UninstallGnbService ${BASESERVICE_SERVICE_FILE_NAME} "baseService"
	#卸载logWriter
	UninstallGnbService ${LOGWRITER_SERVICE_FILE_NAME} "LogWriter"
	#卸载sysrepouddtool
	UninstallGnbService ${SYSREPO_CFG_TOOL_FILE_NAME} "sysrepocfgtool"
}

UninstallGnbByType(){
	# 卸载基站
	if [ $UNINSTALL_TYPE == 0 ];then
		echo "卸载类型:卸载基站,不备份目录"
		"${SCRIPT_PATH}"/yangCfg_uninstall.sh 0
		YANG_CFG_UNINSTALL_RES=$?
		if [ "$YANG_CFG_UNINSTALL_RES" -ne 0 ];then
			echo "卸载sysrepo失败"
			# 用户卸载失败无需回退
			echo "清空备份目录"
			removeDir $BACKUP_DIR
			exit 11
		fi
		if [ $IS_AGENT == 1 ];then
			UninstallAgent
		else
			BackupDir
		fi
		echo "清空备份目录"
		removeDir $BACKUP_DIR
	fi

	# 安装前置卸载
	if [ $UNINSTALL_TYPE == 1 ];then
		echo "卸载类型:安装前置卸载,不备份目录"
		"${SCRIPT_PATH}"/yangCfg_uninstall.sh 0
		YANG_CFG_UNINSTALL_RES=$?
		if [ "$YANG_CFG_UNINSTALL_RES" -ne 0 ];then
			echo "卸载sysrepo失败"
			# 用户卸载失败无需回退
			exit 11
		fi
		BackupDir
		echo "清空备份目录"
		removeDir $BACKUP_DIR
		echo "为之后的安装Agent继承,保留agent配置"
		mkdir -p $AGENT_BAKUP_PATH
		# agent配置
		cp -rf $AGENT_INSTALL_PATH/conf.yaml $AGENT_BAKUP_PATH/conf.yaml
		# lmt用户表
		mkdir -p $AGENT_BAKUP_PATH/lmt-conf
		cp -rf $AGENT_INSTALL_PATH/lmt-conf/user.json $AGENT_BAKUP_PATH/lmt-conf
	fi

	# 升级前置卸载
	if [ $UNINSTALL_TYPE == 2 ];then
		echo "卸载类型:升级前置卸载,备份目录"
		"${SCRIPT_PATH}"/yangCfg_uninstall.sh 1
		YANG_CFG_UNINSTALL_RES=$?
		# 保留配置
		if [ "$YANG_CFG_UNINSTALL_RES" -ne 0 ];then
			echo "卸载sysrepo失败"
			exit 11
		fi
		BackupDir
		mkdir -p $SYSREPO_BACKUP_PATH
		clearFiles $SYSREPO_BACKUP_PATH
		cp -rf $BACKUP_DIR/sysrepo_bak/* $SYSREPO_BACKUP_PATH/
	fi

	# 回退前置卸载
	if [ $UNINSTALL_TYPE == 3 ];then
		echo "卸载类型:回退前置卸载,不备份目录"
		"${SCRIPT_PATH}"/yangCfg_uninstall.sh 0
		YANG_CFG_UNINSTALL_RES=$?
		if [ "$YANG_CFG_UNINSTALL_RES" -ne 0 ];then
			echo "卸载sysrepo失败"
			exit 11
		fi
	fi
}

# 卸载基站软件服务
# 1:service_name , 2:pid_name
UninstallGnbService(){
	if [ -f "${SERVICE_FILE_PATH}/${1}" ];then
		echo ${1}"服务在位,开始卸载"
		pid=$(pgrep -x ${2})
		if [ -n "${pid}" ];then
			kill -9 "${pid}"
		fi
		systemctl stop ${1}        

		systemctl disable ${1}
		rm -f "${SERVICE_FILE_PATH}/${1}"
		echo "清理 ${SERVICE_FILE_PATH}/${1}"
		
		echo ${1}"服务卸载完成"
	fi
}

# 备份目录
BackupDir(){
	if [ -d "$INSTALL_ALL_PATH" ];then
		echo "$INSTALL_ALL_PATH => $BACKUP_DIR"

		removeDir $BACKUP_DIR
		mkdir -p $BACKUP_DIR

		find $INSTALL_ALL_PATH -maxdepth 1 -type d  | while IFS= read -r file; do
			if [ $file == $INSTALL_ALL_PATH ];then
				continue
			fi
			echo "cp -rf \"$file\" \"$BACKUP_DIR\""
			cp -rf $file $BACKUP_DIR
			if [[ "$file" == *"/agent" ]]; then
				continue
			fi
			rm -rf $file
			echo "清理$file 目录"
		done 
		cp -rf "/yzmm/gnb/version.yaml" $BACKUP_DIR
		rm "/yzmm/gnb/version.yaml"
		echo "备份执行目录成功"
		ls -la /yzmm/gnb_bak
	fi
}

UninstallAgent(){
	echo "卸载agent"
	removeDir $AGENT_INSTALL_PATH
	removeDir $SCRIPT_PATH
	removeDir $BACKUP_DIR
	removeDir $PKG_PATH
	removeDir $AGENT_BAKUP_PATH
	removeDir $INSTALL_ALL_PATH
	echo "卸载agent成功"
	if [ -f "$SERVICE_FILE_PATH"/"$AGENT_SERVICE_FILE" ];then
		UninstallGnbService ${AGENT_SERVICE_FILE} "gnb_agent"
	fi
}

if [ -z "$1" ];then
    echo "请输入是否卸载agent标识符,0:不卸载agent,1:卸载agent"
    exit 7
fi

IS_AGENT=$1 #是否卸载agent标识符,0:不卸载agent,1:卸载agent

if [ $IS_AGENT != 0 ] && [ $IS_AGENT != 1 ];then
	echo "无效的卸载agent标识符"	
	exit 7
fi

if [ -z "$2" ];then
	echo "请输入是否卸载类型,0:卸载基站,1:安装前置卸载,2:升级前置卸载,3:回退前置卸载"
    exit 7
fi

UNINSTALL_TYPE=$2 #卸载类型0:卸载基站,1:安装前置卸载,2:升级前置卸载,3:回退前置卸载
if (( UNINSTALL_TYPE < 0 ))   || (( UNINSTALL_TYPE > 3 ));then
	echo "无效的卸载类型$UNINSTALL_TYPE"	
	exit 7
fi

# 检查环境以及关键脚本文件是否存在
CheckSystem

# 检查脚本文件是否存在
CheckShFile

# 卸载基站软件服务
UninstallGnb

# 根据卸载类型卸载基站版本
UninstallGnbByType

echo "卸载成功"
systemctl daemon-reload
sleep 10
exit 0

