#!/bin/bash
dir=$(cd `dirname $0`;pwd)


if [ ! -f update.sh ];then
    echo "未找到gnb_agent安装更新脚本，退出安装"
    exit 1
fi

# check sysrepo
RES=$(sysrepoctl -V 2>&1) 
if [ $? -eq 0 ];then
    echo "sysrepo数据库已存在，继续安装会清空当前业务配置数据导致业务异常，是否需要清空当前配置数据进行安装，yes/no?"
    read SYSREPO_INSTALL
    if [ "$SYSREPO_INSTALL" == "yes" ];then
        echo "开始sysrepo数据库清空配置数据安装"
        # install libs
        if [ ! -f "$dir/installSysrepo.sh" ];then
            echo "未找到sysrepo安装脚本，退出安装"
            exit 1
        fi
        chmod +x "$dir/installSysrepo.sh"
        $dir"/installSysrepo.sh"
    fi
else
    echo "开始安装sysrepo"
    chmod +x $dir"/installSysrepo.sh"
    $dir"/installSysrepo.sh"
fi
sysrepoctl -l

echo "开始安装gnb_agent"
# install agent as service
chmod +x $dir"/update.sh"
    $dir"/update.sh"







