#!/bin/bash
set -x
# install pcre, libyang, sysrepo and yang models.

dir=$(cd `dirname $0`; pwd)
gccMin=4.8.4
cmakeMin=2.8.12

pcre="pcre-8.44"
libyang="libyang-1.0.215"
sysrepo="sysrepo-1.4.104"
yang_modules="yang-modules-master"


if [ "$USER" != "root" ];then
    echo "请切换到root用户运行..."
    exit
fi

if [ ! -d "/etc/sysrepo" ];then
    mkdir -p "/etc/sysrepo"
fi

version_lt() { test "$(echo "$@" | tr " " "\n" | sort -rV | head -n 1)" != "$1"; }

check_gcc_version() {
    if [ -x "$(command -v gcc)" ] ;then
        gccVer=`gcc -dumpversion`
    fi
    if [ "$gccVer" = "" ];then
        printf " GCC版本:\t\033[31m未按装 请手动安装(>=$gccMin)\033[0m\n" >&2
        exit
    elif version_lt $gccVer $gccMin;then
        printf " GCC版本:\t\033[31m$gccVer 请更新gcc版本(>=$gccMin)\033[0m\n" >&2
        exit
    else
        printf " GCC版本:\t\033[32m$gccVer\033[0m (>=$gccMin)\n"
        fi
}

check_cmake_version() {
    if [ -x "$(command -v cmake)" ]; then
        cmakeVer=`cmake --version | head -n 1 | awk '{print $3}'`
        if version_lt $cmakeVer $cmakeMin; then
            printf " cmake版本:\t\033[31m$cmakeVer 请更新版本(>=$cmakeMin)\033[0m\n" >&2
            exit
        else
            printf " cmake版本:\t\033[32m$cmakeVer\033[0m (>=$cmakeMin)\n"
        fi
    else
        printf " cmake版本:\t\033[31m未按装 请手动安装(>=$cmakeMin)\033[0m\n" >&2
        exit
    fi
}


check_gcc_version
check_cmake_version


# pcre
unzip -n $dir/$pcre.zip -d /tmp
cd /tmp/$pcre
chmod 777 configure
./configure --enable-utf --enable-unicode-properties
make
make install
ldconfig
cd $rootDir

# libyang
unzip -n $dir/${libyang}.zip -d /tmp
cd /tmp/${libyang}
mkdir build
cd build
cmake ..
make
make install
ldconfig
cd $rootDir

# sysrepo
unzip -n $dir/${sysrepo}.zip -d /tmp
cd /tmp/${sysrepo}
mkdir build
cd build
# cmake -DREPO_PATH=/opt/sysrepo/yzmm_repo ..
cmake /tmp/${sysrepo} -DCMAKE_BUILD_TYPE=Release
make
make install
ldconfig
make shm_clean #shm stms show bugs.
cd $rootDir

# yang modules
unzip -n $dir/${yang_modules}.zip -d /tmp
chmod +x /tmp/${yang_modules}/install.sh
/tmp/${yang_modules}/install.sh


