#!/bin/bash
# core_cump路径修改
desired_pattern="/coredump/core.%e.%p"
current_pattern=$(sysctl -n kernel.core_pattern)

if [ "$current_pattern" != "$desired_pattern" ]; then
    echo "core_dump dir change"
    mkdir -p /coredump
    chmod 755 /coredump  # 更安全的权限

    # 检查是否已存在配置，避免重复追加
    if ! grep -q "kernel.core_pattern=${desired_pattern}" /etc/sysctl.conf; then
        echo "kernel.core_pattern=${desired_pattern}" >> /etc/sysctl.conf
    fi

    # 直接设置当前值（无需 sysctl -p）
    sysctl -w kernel.core_pattern="${desired_pattern}" >/dev/null
else
    echo "core_pattern is already set correctly."
fi

# 限制虚拟内存 1GB
export MALLOC_ARENA_MAX=1
ulimit -v 1000000
BaseDir=$(cd `dirname $0`; pwd)
cd $BaseDir
mkdir -p /data/log/agent
taskset -c 7 $BaseDir/gnb_agent.arm64 >> /data/log/agent/start.log 2>&1
