const RecoverStr = document.getElementById("recoveryText").innerText;
const FatalStr = document.getElementById("fatalText").innerText;
const ImportStr = document.getElementById("importantText").innerText;
const GeneralStr = document.getElementById("generalText").innerText;
const TippiorStr = document.getElementById("tippiorText").innerText;

let PageSize = 10; //每页显示的条数
let CurPage = 1; //当前显示页码
let TotalPages = 0; //总页数
let CurBT; //当前页按钮

document.addEventListener('DOMContentLoaded', function () { 
    // 周期获取告警信息
    getAlarmInfo()
    setInterval(function () {
            getAlarmInfo()
    }, 5000)

    // 监听分页按钮
    const prevPageBT = document.getElementById("prevPage");
    const nextPageBT = document.getElementById("nextPage");
    const selectPage = document.getElementById("xiala");
    const jump = document.getElementById("jump");
    
    // 上一页
    prevPageBT.onclick = (() => {
        if (CurPage != 1) {
            CurPage--;
            console.log("prev pageId:", CurPage);
            getAlarmInfo();
        }
    });
    // 下一页
    nextPageBT.onclick = (() => {
        if (CurPage != TotalPages) {
            console.log("next page");
            CurPage++;
            console.log("next pageId:", CurPage);
            getAlarmInfo();
        }
    });
    // 分页
    selectPage.addEventListener('change', function () {
        console.log("select val:", this.value);
        let match = this.value.match(/\d+/);
        PageSize = match ? parseInt(match[0], 10) : 0;
        getAlarmInfo();
    });
    // 跳转
    jump.addEventListener('input', function (event) {
        let match = this.value.match(/\d+/);
        let pageId = match ? parseInt(match[0], 10) : 0;
        if (pageId <= TotalPages && pageId >= 1) {
            console.log("input val:", pageId);
            CurPage = pageId;
            getAlarmInfo();
        }; 
    });
});

// 获取告警信息
function getAlarmInfo() {
    HttpGet("/api/v1/alarm-info", (error, resp) => {
        if (error) {
            console.log("get alarm info failed, err:", error)
        } else if (resp.data != null) {
            let alarmData = JSON.parse(resp.data)
            alarmData = alarmData.reverse();
            displayPage(alarmData);
        }
    })
};

// 显示当前分页
function displayPage(data) {
    console.log("pageId:", CurPage, ", size:", PageSize);
    TotalPages = Math.ceil(data.length / PageSize);
    const startIndex = (CurPage - 1) * PageSize;
    const endIndex = startIndex + PageSize;
    const pageData = data.slice(startIndex, endIndex);

    const tableBody = document.getElementById('alarmTable').getElementsByTagName('tbody')[0];
    tableBody.innerHTML = ''; // 清空当前页的数据  

    pageData.forEach(item => {
        const row = tableBody.insertRow();
        const timeCell = row.insertCell(0);
        const levelCell = row.insertCell(1);
        const nameCell = row.insertCell(2);
        const locInfCell = row.insertCell(3);
        const addInfCell = row.insertCell(4);
        const operCell = row.insertCell(5);
        // 时间
        timeCell.textContent = item.time;
        timeCell.style.width = "200px";
        // 级别
        levelCell.textContent = item.level;
        levelCell.style.width = "30px";
        showAlarmLevelColor(levelCell);
        // 告警名称
        nameCell.textContent = item.name;
        nameCell.style.width = "260px";
        nameCell.style.paddingLeft = "50px";
        // 定位信息
        locInfCell.textContent = formatShowArryInfo(item.locInf);
        locInfCell.style.width = "400px";
        // 附加信息
        addInfCell.textContent = formatShowArryInfo(item.addInf);
        addInfCell.style.width = "400px";
        // 操作
        let recoveryBt = document.createElement('button');
        recoveryBt.onclick = function () {
            recoveryAlarm(item.fmNameId);
        };
        let recoveryIcon = document.createElement('span');
        recoveryBt.className = "recover";
        recoveryIcon.className = "iconfont icon-shuaxin";
        recoveryIcon.innerHTML = RecoverStr;
        recoveryBt.appendChild(recoveryIcon);
        operCell.appendChild(recoveryBt);
    });

    updatePagination(data);
};

// 更新分页控件
function updatePagination(data) {  
    // 清空旧的分页控件  
    const pageItem = document.getElementById("page");
    pageItem.querySelectorAll('button').forEach((item) => {
        if (item.className == "") {
            pageItem.removeChild(item);
        }
    })
    const nextPage = document.getElementById('nextPage');  
    for (let i = 1; i <= TotalPages; i++) {
        const button = document.createElement('button');
        button.textContent = i; 
        pageItem.insertBefore(button, nextPage);
        button.onclick = () => {
            CurPage = i;
            displayPage(data)
        };
        if (i === CurPage) {
            button.style.background = "#0B65A0";
            button.style.color = "#FFFFFF";
        }
    };

};

// 格式化附加信息、定位信息
function getLocAndAddInfo(info) {
    let res = "";
    if (info.length != 1) { 
        for (let i = 0; i < info.length; i++) {
            res += (i+1) + "." + info[i]+"; ";
        }   
    } else {
        res = info[0]
    }
    return res
};


// 显示级别颜色
function showAlarmLevelColor(cell) {
    // let cells = tb.rows[num].cells;
    // console.log("alarm level:", level, ", fatal:", FatalStr, ", important:", ImportStr, ", general: ", GeneralStr, ", tippior:", TippiorStr)
    if (cell.textContent === FatalStr) {
        cell.style.color = "#FF5533";
    } else if (cell.textContent === ImportStr) {
        cell.style.color = "#FF8933";
    }else if (cell.textContent === GeneralStr) {
        cell.style.color = "#FFBD33";
    }else if (cell.textContent === TippiorStr) {
        cell.style.color = "#39B7E9";
    }
};

// 告警恢复
function recoveryAlarm(fmName) {
    console.log("start recovery alarm")
    HttpPost('/api/v1/alarm-recovery',  fmName, (error, response) => {
        if (error) {
            console.log("alarm recovery err:", error)
            return
        } else {
            parent.showTipMessage({message:response.msg,type:"info"});
            getAlarmInfo();
        }
    });
}