const UnkonwStr = window.parent.document.getElementById("unknownText").innerText;
const OpenStr = window.parent.document.getElementById("openText").innerText;
const CloseStr = window.parent.document.getElementById("closeText").innerText;
const NetNormalStr = window.parent.document.getElementById("netNormalText").innerText;
const NetAbnormalStr = window.parent.document.getElementById("netAbnormalText").innerText;
const CellStatusStr = window.parent.document.getElementById("cellStatusText").innerText;


// 开启状态描述信息
var openStr = window.parent.document.getElementById("openText").innerText;
// 关闭状态描述信息
var closeStr = window.parent.document.getElementById("closeText").innerText;



document.addEventListener('DOMContentLoaded', function () {
    getDevInfo()
setInterval(function () {
        getDevInfo()
}, 10000)
}
);

function getDevInfo() {
    HttpGet('/api/v1/device-info', (error, resp) => {
        if (error) {
            console.log("get device info err:", error);
        } else {
            var data = JSON.parse(resp.data);
            let netCard1Data = "";
            let netCard2Data = "";
            let gpsSw = "";
            if (data.deviceInfo.system.net.interfaces[0] != null){
                netCard1Data = `${data.deviceInfo.system.net.interfaces[0].name}, ${data.deviceInfo.system.net.interfaces[0].ipv4}`
            }
            if (data.deviceInfo.system.net.interfaces[1] != null){
                netCard2Data = `${data.deviceInfo.system.net.interfaces[1].name}, ${data.deviceInfo.system.net.interfaces[1].ipv4}`
            }
            if (data.gps.sw === 1){
                gpsSw = OpenStr
            }else{
                gpsSw = CloseStr
            }
            let cellStatusStr = NetAbnormalStr;
            // console.log("data.deviceInfo.cellStatus typeof:",typeof(data.deviceInfo.cellStatus))
            if (data.deviceInfo.cellStatus){
                Object.keys(data.deviceInfo.cellStatus).forEach(key => {
                    cellStatusStr = NetNormalStr;
                });
            }
            if (cellStatusStr === NetAbnormalStr){
                document.getElementById("cellStatus").style.color = "#FF5533";
            }else{
                document.getElementById("cellStatus").style.color = "#77B300";
            };
            updateSection({
                "dev-type": data.deviceInfo.type,
                "sw-ver": data.deviceInfo.software.versionInfo.version,
                "disk-usage": `${B2GB(data.deviceInfo.system.disk.used)} / ${B2GB(data.deviceInfo.system.disk.total)}G`,
                "net-card1": netCard1Data,
                "net-card2": netCard2Data,
                "system-os": data.deviceInfo.system.os,
                "ram-usage": `${B2GB(data.deviceInfo.system.ram.used)} / ${B2GB(data.deviceInfo.system.ram.total)}G`,
                "kernel-os": data.deviceInfo.system.kernel,
                "gps": gpsSw,
                "cpu": data.deviceInfo.system.cpu,
                "cellStatus":cellStatusStr,
                "ru-version":data.ru.version,
                "ru-freq":data.ru.freq,
                "chan0-sw":isOpen(data.ru.channelSw[0]),
                "chan1-sw":isOpen(data.ru.channelSw[1]),
                "chan2-sw":isOpen(data.ru.channelSw[2]),
                "chan3-sw":isOpen(data.ru.channelSw[3]),
            });
        };
    })  
};

function isOpen(input){
    if (input === 0){
        return closeStr
    }else if (input === 1){
        return openStr
    }else{
        return ""
    }
};




