let menuData = {};
let currentPageFile = '';
let allConfigItems = []; // 全局数组，用于存储所有配置项的数据
let searchResults = [];  // 存储搜索结果
let isAdmin = false;
let userNameElement = window.parent.document.getElementById("inputUserName");
let userName = userNameElement.value || userNameElement.innerText;
let isCopy = false;
let xpathCpVal = "";
const successMsg =  window.parent.document.getElementById("successText").innerText;
const failedMsg =  window.parent.document.getElementById("failedText").innerText;
const nomatchMsg =  document.getElementById("nomatch").innerText;


document.addEventListener('DOMContentLoaded', () => {
    if (userName === "admin") {
        isAdmin = true
    }
    fetchMenuData();
    document.querySelector('.right .bottom yz-bt').addEventListener('click', submitConfiguration);
    document.getElementById('search-button').addEventListener('click', searchConfiguration);
});

// 左键复制xpath
document.addEventListener('click',()=>{
    if (isCopy && xpathCpVal != ""){
        navigator.clipboard.writeText(xpathCpVal)
        .then(() => {
            parent.showTipMessage({message:"已复制"+xpathCpVal+"至剪贴板",type:"info"});
        })
        .catch(()=>{
            parent.showTipMessage({message:"复制失败，请手动复制",type:"error"});
        });
    };
});


//获取数据，菜单数据
function fetchMenuData() {
    HttpGet('/api/v1/menu-data', (error, resp) => {
        if (error) {
            console.log("get menu data failed, err:", error);
            return
        } else {
            populateMenu(JSON.parse(resp.data));
        }
    });
}

//定位菜单
function populateMenu(pageBlockMap) {
    const configTree = document.getElementById('configTree');
    menuData = pageBlockMap;
    configTree.innerHTML = '';
    const allConfValue = document.getElementById('allConfValue').textContent;
    const allConfig = document.createElement('div');
    allConfig.className = 'allConfig';
    allConfig.textContent = allConfValue;
    configTree.appendChild(allConfig);

    const desiredOrder = [
        '基本配置||',
        'CU对接AMF配置|gnb-cu-amf.xml|',
        'CU主配置|gnb-cu-main.xml|',
        'CU日志配置|gnb-cu-log.xml|',
        'CU对接DU配置|gnb-cu-dulist.xml|',
        'DU配置|gnb-du.xml|',
        '小区配置|du-cell.xml|',
        'NMS基站配置|gnb-nms.xml|local',
        '高级配置|senior-config.ini|',
        '功放配置|power-amplifier-config.json|'
    ];
    const sortedKeys = desiredOrder.filter(key => key in pageBlockMap);
    // console.log("sortedKeys:",sortedKeys);
    
    const ulElement = document.createElement('ul'); // 确保 ulElement 在函数内部定义
    for (const pageKey of sortedKeys) {
        const blocks = pageBlockMap[pageKey];
        // console.log("pageKey:", pageKey, ", blocks:", blocks);
        const [pageName, pageFile, pagePath] = pageKey.split('|');
        const liPage = createMenuItem(pageName, blocks, true, pageFile, pagePath);
        ulElement.appendChild(liPage);
    }


    configTree.appendChild(ulElement);
}

//渲染菜单
function createMenuItem(name, blocks, isPage = false, pageFile = '', pagePath = '') {
    const liItem = document.createElement('li');
    liItem.className = blocks && blocks.length > 0 ? 'fileC' : 'file';
    liItem.textContent = name;
    liItem.dataset.name = name;


    // Remove .xml suffix if present and convert pageFile to uppercase
    // const basePageFile = pageFile.endsWith('.xml') ? pageFile.slice(0, -4) : pageFile;
    // const uppercasePageFile = basePageFile.toUpperCase();

    if (isPage) {
        liItem.dataset.pageFile = pageFile;
        liItem.dataset.pagePath = pagePath;
    }

    if (blocks && blocks.length > 0) {
        const ulSubMenu = document.createElement('ul');
        ulSubMenu.className = 'nested';

        for (const block of blocks) {
            const liSubItem = createMenuItem(block.name, block.subBlocks, block.configItems.length > 0, pageFile, pagePath);
            ulSubMenu.appendChild(liSubItem);
            block.configItems.forEach(configItem => {
                allConfigItems.push({
                    blockPath: configItem.Xpath,
                    blockName: block.name,
                    pageFile: pageFile,
                    pagePath: pagePath,
                    configItemName: configItem.Name,
                    showName: configItem.ShowName,
                    blockElement: liSubItem
                });
            });
        }

        liItem.insertAdjacentHTML('afterbegin', `<span class="isExpand"></span>`);
        liItem.appendChild(ulSubMenu);
        liItem.addEventListener('click', (event) => toggleVisibility(event, liItem, ulSubMenu));
        liItem.addEventListener('click', showPage);
    } else {
        // 为没有子块但有配置项的父节点添加点击事件
        liItem.addEventListener('click', showPage);

        // Handle configItems for blocks with parent=1
        if (blocks && blocks.length > 0 && blocks.some(block => block.configItems.length > 0)) {
            blocks.forEach(block => {
                block.configItems.forEach(configItem => {
                    allConfigItems.push({
                        blockPath: configItem.Xpath,
                        blockName: name,
                        pageFile: pageFile,
                        pagePath: pagePath,
                        configItemName: configItem.Name,
                        showName: configItem.ShowName,
                        blockElement: liItem
                    });
                });
            });
        }
    }

    return liItem;
}


//菜单图标
function toggleVisibility(event, liItem, ulSubMenu) {
    event.stopPropagation();

    const isVisible = ulSubMenu.classList.contains('active');
    ulSubMenu.classList.toggle('active');
    liItem.classList.toggle('fileO', !isVisible);
    liItem.classList.toggle('fileC', isVisible);
    const isExpandIcon = liItem.querySelector('.isExpand');
    if (isVisible) {
        isExpandIcon.classList.remove('open');
    } else {
        isExpandIcon.classList.add('open');
    }
}

//显示对应页面
async function showPage(event) {
    event.stopPropagation();

    // Fetch the configuration data for the clicked block
    const liItem = event.currentTarget;
    
    const blockName = liItem.dataset.name;
    // 获取点击项的页面文件名
    let liPage = event.currentTarget;
    while (liPage && !liPage.dataset.pageFile) {
        liPage = liPage.parentElement.closest('li');
    }

    // 检查是否是特殊情况
    let special = false;
    if (!liPage) {
        special = true;
    }

    if (liPage || special) {
        let pageFile;
        let blockData;
        if (special) {
            blockData = findBlockData("", blockName);
        } else {
            pageFile = liPage.dataset.pageFile;
            blockData = findBlockData(pageFile, blockName);
        }

        if (blockData) {
            const currentConfigurationPage = document.getElementById('currentConfigurationPage');
            currentConfigurationPage.innerHTML = ''; 
            let cfgMap ={} ;
            blockData.configItems.forEach(cfg=>{
                if (cfg.Xpath != ""){
                    if (cfg.FileType == ""){
                        if (cfgMap[".xml"] === undefined){
                            cfgMap[".xml"]={};
                        }
                        cfgMap[".xml"][cfg.Xpath]="";
                    }else{
                        if (cfgMap[cfg.FileType] === undefined){
                            cfgMap[cfg.FileType] = {};
                        }
                        cfgMap[cfg.FileType][cfg.Xpath]="";
                    }
                }
            });
            // console.log("cfgMap:",cfgMap);
            currentPageFile = pageFile;
            getConfigVal(cfgMap).then(value=>{
                renderConfigItems(blockData, pageFile, searchResults, currentConfigurationPage, isAdmin,value);
                ToolTipToXpath();
            },error=>{
                console.log(error);
            });
            getTopName(liItem,`${blockName}`);
        }
    } else {
        parent.showTipMessage({message: '未找到页面文件和路径。', type: "error"});
    }
}

// xpath获取配置项值
function getConfigVal(cfgMap){
    return new Promise((resolve,reject) =>{
        HttpPost('/api/v1/config', JSON.stringify({
            module: "software",
            operation: 'get',
            extension: cfgMap
        }), (error, resp) => {
            if (error) {
                parent.showTipMessage({message: error, type: "error"});
                reject(error);
            } else {
                resolve(JSON.parse(resp.data));
            }
        });
    });
}

async function renderConfigItems(blockData, pageFile, searchResults, currentConfigurationPage, isAdmin,cfgValMap) {
    for (const item of blockData.configItems) {
        if (item.IsShow === "1") {
            const itemDiv = document.createElement('div');
            itemDiv.className = 'itemDiv';
            itemDiv.yangName = pageFile;

            // 获取 XPath
            // let xpath = item.Xpath;
            let xpaths = [item.Xpath];

            // 获取 itemValue（异步调用）
            const itemValue = cfgValMap[item.Xpath]
            if (itemValue===undefined){
                continue
            }
            const labelText = item.ShowName || item.Name;
            // console.log("item.fileType:",item.FileType);
            let fileType = ".xml";
            let isSelect = false;
            if (item.FileType !== ""){
                fileType = item.FileType;
            }
            // 渲染 itemDiv 内容
            if (item.CanEdit === "0") {
                if (item.ShowType === "Combo"){
                    isSelect = true
                    showSelectDisabledDiv(itemDiv,item,item.Range,fileType,itemValue,labelText);
                    if (item.Special && item.Special != "" && item.Special.includes("range_by_condition")) {
                        await showActiveSelect(itemDiv,item);
                    };
                }else{
                    itemDiv.innerHTML = `
                    <span class="label" data-xpath="${item.Xpath}">${labelText}</span>
                    <yz-input  id="info" disabled name="${item.Name}" filetype="${fileType}" placeholder="${item.Range}" value="${itemValue}" width="300px"${isAdmin ? '' : ' disabled'}></yz-input>`;
                };
            } else {
                // 下拉框
                if (item.ShowType === "Combo"){
                    isSelect = true
                    showSelectDiv(itemDiv,item,item.Range,fileType,itemValue,labelText,item.AllowCustom);
                    if (item.Special && item.Special != "" && item.Special.includes("range_by_condition")) {
                        await showActiveSelect(itemDiv,item);
                    };
                }else{
                    itemDiv.innerHTML = `
                    <span class="label" data-xpath="${item.Xpath}">${labelText}</span>
                    <yz-input id="info" name="${item.Name}" filetype="${fileType}" placeholder="${item.Range}" value="${itemValue}" width="300px"${isAdmin ? '' : ' disabled'}></yz-input>
                `;
                }
            }

            // 添加 tooltip
            if (item.Assoc !=""){
                let xs = item.Assoc.split(",");
                xs.forEach(x=>{
                    xpaths.push(x);
                });
            }
            // console.log("item.range:",item.Range,", show name:",item.ShowName);
            if (isSelect){
                addTooltipToItem(itemDiv, xpaths,"");
            }else{
                // console.log("start add tool tip")
                addTooltipToItem(itemDiv, xpaths, item.Range);
            };
            

            // 将 itemDiv 添加到页面
            currentConfigurationPage.appendChild(itemDiv);
            // console.log("set itemDiv:",item.ShowName)

            // 如果搜索结果中包含此配置项，则将其标记为蓝色
            const labelElement = itemDiv.querySelector('.label');
            if (searchResults.some(result => result.configItemName.includes(item.Name))) {
                labelElement.style.color = '#1284BB';
            } else {
                labelElement.style.color = 'rgba(0, 0, 0, 0.65)'; // 恢复颜色
            };
        };
    };
};

// 显示(禁用)下拉框div
function showSelectDisabledDiv(itemDiv,item,rangeStr,fileType,itemValue,labelText){
    itemDiv.innerHTML = `
    <span class="label" data-xpath="${item.Xpath}">${labelText}</span>
    <yz-select id="info" disabled name="${item.Name}" filetype="${fileType}" value="${itemValue}" width="300px"${isAdmin ? '' : ' disabled'}></yz-select>`;
    itemDiv.querySelector("#info").setAttribute('data',rangeStr);
    // console.log("rangeStr:",rangeStr);
};

// 显示下拉框div
function showSelectDiv(itemDiv,item,rangeStr,fileType,itemValue,labelText,allowCustom){
    if (allowCustom){
        itemDiv.innerHTML = `
        <span class="label" data-xpath="${item.Xpath}">${labelText}</span>
        <yz-select id="info" name="${item.Name}" filetype="${fileType}" value="${itemValue}" allow-custom=true width="300px"${isAdmin ? '' : ' disabled'}></yz-select>`;
    }else{
        itemDiv.innerHTML = `
        <span class="label" data-xpath="${item.Xpath}">${labelText}</span>
        <yz-select id="info" name="${item.Name}" filetype="${fileType}" value="${itemValue}" width="300px"${isAdmin ? '' : ' disabled'}></yz-select>`;
    }
    itemDiv.querySelector("#info").setAttribute('data',rangeStr);
};

// 动态下拉框显示
async function showActiveSelect( itemDiv, item){
    return new Promise((resolve,reject) =>{{
        // console.log("动态下拉框")
        let sp = JSON.parse(item.Special);
        sp.forEach(d=>{
            let rules = d["range_by_condition"]
            if ( rules && rules.size != 0){
                let rulesMap = JSON.parse(rules);
                // console.log("rangeMap:",rulesMap);
                Object.entries(rulesMap).forEach(async ([r,rangeStr] )=>{
                    if (r.includes("AND")){
                        const res = await isRightAndRule(r);
                        // console.log("and rule:",r);
                        if (res){
                            // console.log("set new range",rangeStr);
                            itemDiv.querySelector("#info").setAttribute('data',rangeStr);
                            resolve();
                            return
                        };
                    }else if (r.includes("OR")){
                        const res = await isRightOrRule(r);
                        // console.log("or rule:",r);
                        if (res){
                            // console.log("set new range",rangeStr);
                            itemDiv.querySelector("#info").setAttribute('data',rangeStr);
                            resolve();
                            return
                        };
                    }else{
                        const evalResult = await evalClacStr(r);
                        // console.log("common rule:", r);
                        if (evalResult){
                            // console.log("set new range",rangeStr);
                            itemDiv.querySelector("#info").setAttribute('data',rangeStr);
                            resolve();
                            return
                        };
                    };
                });
            };
        });
    }});
};


// 与逻辑判断
async function isRightAndRule(r){
    let res = false;
    let infos = r.split("AND");
    // console.log("and infos:",infos,", type:",typeof infos);
    infos.forEach(async info=>{
        // console.log("and info:",info,", type:",typeof info);
        let res = await evalClacStr(info)
        if (!res){
            return false
        }else{
            // console.log(r," and rule is right")
            res = true;
        }
    });
    return res
}

// 或逻辑判断
async function isRightOrRule(r){
    let infos = r.split("OR");
    infos.forEach(async info=>{
        let res = await evalClacStr(info)
        if (res){
            // console.log(r," or rule is right")
            return true
        };
    });
    return false
};

// 根据rule中的逻辑判断
async function evalClacStr(info){
    let res = extractXPathAndOperator(info);
    // console.log("rule.xpathInfo:",res);
    let val =  await getXpathVal(res.xpath);
    // console.log(val+res.operator+res.value,"结果:",evaluateExpression(val+res.operator+res.value))
    return evaluateExpression(val+res.operator+res.value);
};



//xpath的悬浮窗
function ToolTipToXpath() {
    document.querySelectorAll('.label').forEach(function(item){
        let mouseMoveHandler;

        item.addEventListener('mouseover', () => {
            isCopy = true;
            let content = item.dataset.xpath;
            xpathCpVal = item.dataset.xpath;
            const tooltip = document.getElementById('tooltip');
            let labelName = item.textContent;

            // 设置 tooltip 内容
            tooltip.innerHTML = `${labelName}<br>${content}`;
            tooltip.style.display = 'block';

            mouseMoveHandler = (e) => {
                const offsetX = e.clientX + 20;
                const offsetY = e.clientY - 20;
                document.body.style.cursor = 'pointer';
                // console.log("offsetX",offsetX)
                // console.log("e.clientX",e.clientX)

                tooltip.style.left = offsetX + 'px';
                tooltip.style.top = offsetY + 'px';
                tooltip.style.cursor = 'pointer';
            };

            document.addEventListener('mousemove', mouseMoveHandler);
        });

        item.addEventListener('mouseout', () => {
            isCopy = false;
            xpathCpVal = "";
            document.body.style.cursor = 'default'; // 恢复默认鼠标样式
            const tooltip = document.getElementById('tooltip');
            tooltip.style.display = 'none';  // 隐藏 tooltip

            if (mouseMoveHandler) {
                document.removeEventListener('mousemove', mouseMoveHandler); // 鼠标移出时移除 mousemove 事件
                mouseMoveHandler = null;
            }
        });
    });
}

//显示悬浮窗，内容为xpath；下标提示范围
function addTooltipToItem(itemDiv, xpaths, placeholderText) {
    // 创建用于显示 placeholder 的 tooltip
    const placeholderTooltip = document.createElement('div');
    placeholderTooltip.className = 'tooltipConf placeholderTooltip';
    if (placeholderText != ""){
        placeholderTooltip.textContent = `输入范围 ${placeholderText}`;
    }
    placeholderTooltip.style.position = 'absolute';
    placeholderTooltip.style.visibility = 'hidden';
    placeholderTooltip.style.opacity = '0';
    itemDiv.appendChild(placeholderTooltip);
    const inputField = itemDiv.querySelector('#info');
    inputField.xpath = xpaths;
    // 输入框获得焦点时显示 placeholder tooltip
    inputField.addEventListener('focus', () => {
        placeholderTooltip.style.visibility = 'visible';
        placeholderTooltip.style.opacity = '1';
    });

    // 输入框失去焦点时隐藏 placeholder tooltip
    inputField.addEventListener('blur', () => {
        placeholderTooltip.style.visibility = 'hidden';
        placeholderTooltip.style.opacity = '0';
    });
}

//查询xml值
function getConfigItemValue(name, confDataXml) {
    const pathParts = name.split('/');
    let current = confDataXml;
    for (const part of pathParts) {
        if (!current) {
            return '';
        }
        current = current.querySelector(part);
    }
    return current ? current.textContent : '';
}

//查询主控文件对应block的内容
function findBlockData(pageFile, blockName) {
    // 当 pageFile 为空时，赋值为 "基础配置"
    if (!pageFile) {
        pageFile = "基本配置";
    }
    for (const [pageKey, blocks] of Object.entries(menuData)) {
        if (pageKey.includes(pageFile)) { // 确保搜索在指定的页面中
            for (const block of blocks) {
                if (block.name === blockName) {
                    return block;
                }
                // 如果存在子块，继续搜索
                if (block.subBlocks) {
                    for (const subBlock of block.subBlocks) {
                        if (subBlock.name === blockName) {
                            return subBlock;
                        }
                    }
                }
            }
        }
    }
    return null;
}

//提交
async function submitConfiguration() {
    if (!isAdmin) {
        // alert("No submit permission");
        parent.showTipMessage({message: "No submit permission", type: "error"});
        return;
    }
    const currentConfigurationPage = document.getElementById('currentConfigurationPage');
    const inputs = currentConfigurationPage.querySelectorAll('yz-input');
    const selects = currentConfigurationPage.querySelectorAll('yz-select');

    let configPostData = {};
        inputs.forEach(input => {
            input.xpath.forEach(x=>{
                let fileType = input.getAttribute("filetype");
                if (configPostData[fileType] === undefined){
                    configPostData[fileType] = {};
                }
                configPostData[fileType][x] = input.value;
            });
        });
        selects.forEach(select =>{
            select.xpath.forEach(x=>{
                let fileType = select.getAttribute("filetype");
                if (configPostData[fileType] === undefined){
                    configPostData[fileType] = {};
                }
                configPostData[fileType][x] = select.getValue();
            });
        });
        // console.log("editCfg.data:",configPostData);
        HttpPost('/api/v1/config', JSON.stringify({
            module: "software",
            operation: 'update',
            extension: configPostData
        }), (error, resp) => {
            if (error) {
                parent.showTipMessage({message: error, type: "error"});
                return
            } else {
                if (resp.code === 200) {
                    parent.showTipMessage({message: successMsg, type: "success"});
                    location.reload;
                }else{
                    parent.showTipMessage({message: resp.msg, type: "error"});
                }
            }
        });
        return
};

//搜索
function searchConfiguration() {
    const searchInput = document.getElementById('search-input').value.trim().toLowerCase();
    
    if (searchInput === '') {
        return;
    }
    allConfigItems.forEach(item=>{
        clearHeighLightNode(item.blockElement);
    });
    searchResults = allConfigItems.filter(item =>
        item.showName.toLowerCase().includes(searchInput) ||
        item.blockPath.toLowerCase().includes(searchInput)
    );

    searchResults.forEach(res=>{
        heighLightNode(res.blockElement);
    });
};


//显示高亮
function showAndHighlightFirstPage(results) {
    const processedPages = new Set();

    results.forEach(result => {
        const blockElement = result.blockElement;
        const pageFile = blockElement.closest('li[data-page-file]').dataset.pageFile;

        if (!processedPages.has(pageFile)) {
            blockElement.click();
            processedPages.add(pageFile);

            blockElement.addEventListener('click', () => {
                highlightConfigItems(results);
            });
        }
    });

    highlightConfigItems(results);
}

//显示高亮内容
function highlightConfigItems(searchResults) {
    const searchNames = new Set(searchResults.map(result => result.showName));
    document.querySelectorAll('.right .label').forEach(label => {
        const configItemName = label.textContent.trim();
        label.style.color = searchNames.has(configItemName) ? '#1284BB' : 'rgba(0, 0, 0, 0.65)';
    });
}

function isYangModule(m) {
    return (m === "gnb-cu-main" || m === "gnb-cu-dulist" || m === "gnb-cu-amf" || m === "gnb-cu-log" || m === "gnb-du" || m === "du-cell" || m === "基础配置" || m === 'gnb-ru');
}

function isXmlFile(m) {
    return (m === "gnb-nms");
}

function heighLightNode(child){
    if (child.parentElement && child.parentElement.textContent!=""){
            child.style.color = '#1284BB';
            child.parentElement.style.color = '#1284BB';
        if (child.parentElement.textContent === "基础配置"||
            child.parentElement.textContent=== "CU对接AMF配置"||
            child.parentElement.textContent=== "CU主配置" ||
            child.parentElement.textContent === "CU日志配置" ||
            child.parentElement.textContent==="CU对接DU配置"||
            child.parentElement.textContent === "DU配置"||
            child.parentElement.textContent === "小区配置"||
            child.parentElement.textContent === "RU配置"||
            child.parentElement.textContent === "NMS基站配置"||
            child.parentElement.textContent === "高级配置"){
            return
        }else{
            heighLightNode(child.parentElement);
        }
    };
};

// 清除高亮
function clearHeighLightNode(child){
    if (child.parentElement && child.parentElement.textContent!=""){
        child.style.color = '';
        child.parentElement.style.color = '';
        if (child.parentElement.textContent === "基础配置"||
            child.parentElement.textContent=== "CU对接AMF配置"||
            child.parentElement.textContent=== "CU主配置" ||
            child.parentElement.textContent === "CU日志配置" ||
            child.parentElement.textContent==="CU对接DU配置"||
            child.parentElement.textContent === "DU配置"||
            child.parentElement.textContent === "小区配置"||
            child.parentElement.textContent === "RU配置"||
            child.parentElement.textContent === "NMS基站配置"||
            child.parentElement.textContent === "高级配置"){
            return
        }else{
            clearHeighLightNode(child.parentElement);
        }
    };
};

// 获取配置标题名称
function getTopName(child,blockName){
    let name = blockName;
    if (child.parentElement){
        // console.log("parent.element:",child.parentElement);
        if (child.parentElement.getAttribute("data-name") !== null&&
            child.parentElement.getAttribute("data-name") !==undefined && 
            child.parentElement.getAttribute("data-name") !== "" ){
            name = child.parentElement.getAttribute("data-name")+"/"+name;
            // console.log("add block name:",name)
        }
        getTopName(child.parentElement,name);
    }else{
        // console.log("get block name:",name)
        document.querySelector('.right .top span').textContent = name;
        return
    }
}