const ShuaxinBT = document.getElementById("shuaxin");
const ImportBT = document.getElementById("importData");
const ExportBT = document.getElementById("exportData");
const Upload = document.getElementById("upload");
const FailedTip = window.parent.document.getElementById("failedTipWindow");
const SuccessTip = window.parent.document.getElementById("successTipWindow");
const WaitTip = window.parent.document.getElementById("waitTipWindow");
const WaitPkgName = window.parent.document.getElementById("waitPkgName");
const Bar = window.parent.document.getElementById("bar");
const PgBarText = window.parent.document.getElementById("pgBarText");

const AlreadyText = document.getElementById("alreadyText").innerText;
const UploadPkgText = document.getElementById("uploadText").innerText;
const InvalidFileText = document.getElementById("invalidFileText").innerText;
const FileSizeExceedLmitText = document.getElementById("fileSizeExceedLmitText").innerText;
const ImportText =   document.getElementById("importText").innerText;
const ExportText =   document.getElementById("exportText").innerText;
const SuccessText =  document.getElementById("successText").innerText;
const ResetConfigText =  window.parent.document.getElementById("resetConfigText").innerText;
const FailedText =  document.getElementById("failedText").innerText;

const SysrepoZipLmitSize =1024*1024*30 ;//sysrepo配置压缩包最大 

const ExportSuccCode = 5004; //导出配置正确码
const ImportSuccCode = 5008; //导入配置正确码



document.addEventListener('DOMContentLoaded', function () {
    updateSysrepoInfo();
    ShuaxinBT.addEventListener('click', function () {
        console.log("更新数据库信息");
        updateSysrepoInfo();
    });
    ImportBT.addEventListener('click', function () {
        console.log("导入配置");
        Upload.click(); // 触发文件选择对话框
        Upload.addEventListener('change',importCfgHandler,{once:true});
    });
    ExportBT.addEventListener('click', function () {
        console.log("导出配置");
        exportCfg();
    });
});

// 使用函数声明定义处理函数
function importCfgHandler(event) {
    // WaitTip.style.display = "block";
    importCfg(event);
}

// 更新数据库信息
function updateSysrepoInfo() { 
    HttpGet('api/v1/sysrepo-info', (error, resp) => {
        if (error) {
            console.log("get sysrepo info failed, err:", error);
            return
        } else {
            let sysrepoInfo = JSON.parse(resp.data);
            updateSection({
                "dbVer": sysrepoInfo.dbVer,
                "soVer": sysrepoInfo.soVer,
            });
        }
    });
};

// 导入配置
function importCfg(event) {
    if (event.target.files && event.target.files[0]) {
        const file = event.target.files[0];
        // WaitTip.style.display = "block";
        WaitPkgName.innerText = file.name;
        const chunkSize = 1024 * 1024;
        console.log("upload GNBConfig zip file size:", file.size);

        if (file.size >=  SysrepoZipLmitSize) {
            WaitTip.style.display = "none";
            parent.showTipMessage({message:ImportText+FailedText,type:"error"});
            return
        }
        console.log("check GNBConfig zip file success");
        uploadChunk(file, 0, chunkSize, "api/v1/upload-gnb-cfg-data");
    }
};

// 导出配置
function exportCfg() {
    HttpGet('api/v1/export-gnb-cfg-data', (error, resp) => {
        if (error) {
            console.log("export GNBConfig data failed, err:", error);
            return
        } else {
            if (resp.code === ExportSuccCode) {
                download("GNBConfig",document);
            } else {
                parent.showTipMessage({message:ExportText+FailedText,type:"error"});
            }
        }
    });
};

// 回调上传chunk
function uploadChunk(file, start, chunkSize, url) {  
    if (start >= file.size) {  
        console.log("All chunks uploaded successfully");
        WaitTip.style.display = "none";
        HttpGet('/api/v1/import-gnb-cfg-data', (error, resp) => {
            if (error) {
                console.log("import sysrepo data failed, err:", error);
                parent.showTipMessage({message:ImportText+FailedText,type:"error"});
                return
            } else {
                if (resp.code === ImportSuccCode) {
                    parent.showTipMessage({message:ImportText+SuccessText+','+ResetConfigText,type:"info"});   
                } else {
                    parent.showTipMessage({message:ImportText+FailedText,type:"error"});
                }
                location.reload();
                return
            }
        });
        return
    }
    const end = Math.min(file.size - 1, start + chunkSize - 1);  
    uploadFile(file, start, end, url, (error) => {  
        if (error) {  
            console.log("upload failed, err:", error);
            WaitTip.style.display = "none";
            parent.showTipMessage({message:ImportText+FailedText,type:"error"});
            location.reload();
            return   
        } else {  
            console.log("upload success");
            moveBar(((end + 1)/file.size),AlreadyText+UploadPkgText,Bar,PgBarText);
            uploadChunk(file, end + 1, chunkSize, url); // 递归调用  
        }  
    });
};