let PageSize = 10; //每页显示的条数
let CurPage = 1; //当前显示页码
let TotalPages = 0; //总页数
let CurBT; //当前页按钮

document.addEventListener('DOMContentLoaded', function () { 
    // 周期获取事件信息
    getEventInfo()
    setInterval(function () {
            getEventInfo()
    }, 5000)

    // 监听分页按钮
    const prevPageBT = document.getElementById("prevPage");
    const nextPageBT = document.getElementById("nextPage");
    const selectPage = document.getElementById("xiala");
    const jump = document.getElementById("jump");
    
    // 上一页
    prevPageBT.onclick = (() => {
        if (CurPage != 1) {
            CurPage--;
            console.log("prev pageId:", CurPage);
            getAlarmInfo();
        }
    });
    // 下一页
    nextPageBT.onclick = (() => {
        if (CurPage != TotalPages) {
            console.log("next page");
            CurPage++;
            console.log("next pageId:", CurPage);
            getAlarmInfo();
        }
    });
    // 分页
    selectPage.addEventListener('change', function () {
        console.log("select val:", this.value);
        let match = this.value.match(/\d+/);
        PageSize = match ? parseInt(match[0], 10) : 0;
        getAlarmInfo();
    });
    // 跳转
    jump.addEventListener('input', function (event) {
        let match = this.value.match(/\d+/);
        let pageId = match ? parseInt(match[0], 10) : 0;
        if (pageId <= TotalPages && pageId >= 1) {
            console.log("input val:", pageId);
            CurPage = pageId;
            getAlarmInfo();
        }; 
    });
});

// 获取告警信息
function getEventInfo() {
    HttpGet("/api/v1/event-info", (error, resp) => {
        if (error) {
            console.log("get event info failed, err:", error)
        } else if (resp.data != null) {
            let eventData = JSON.parse(resp.data)
            eventData = eventData.reverse();
            displayPage(eventData);
        }
    })
};

// 显示当前分页
function displayPage(data) {
    console.log("pageId:", CurPage, ", size:", PageSize);
    TotalPages = Math.ceil(data.length / PageSize);
    const startIndex = (CurPage - 1) * PageSize;
    const endIndex = startIndex + PageSize;
    const pageData = data.slice(startIndex, endIndex);

    const tableBody = document.getElementById('alarmTable').getElementsByTagName('tbody')[0];
    tableBody.innerHTML = ''; // 清空当前页的数据  

    pageData.forEach(item => {
        const row = tableBody.insertRow();
        const timeCell = row.insertCell(0);
        const nameCell = row.insertCell(1);
        const locInfCell = row.insertCell(2);
        const addInfCell = row.insertCell(3);
        // 时间
        timeCell.textContent = item.time;
        timeCell.style.width = "240px";
        timeCell.style.paddingLeft = "10px";

        // 事件名称
        nameCell.textContent = item.name;
        nameCell.style.width = "500px";
        // nameCell.style.paddingLeft = "50px";

        // 定位信息
        locInfCell.textContent = formatShowArryInfo(item.locInf);
        locInfCell.style.width = "460px";

        // 附加信息
        addInfCell.textContent = formatShowArryInfo(item.addInf);
        // addInfCell.style.width = "400px";
    });

    updatePagination(data);
};

// 更新分页控件
function updatePagination(data) {  
    // 清空旧的分页控件  
    const pageItem = document.getElementById("page");
    pageItem.querySelectorAll('button').forEach((item) => {
        if (item.className == "") {
            pageItem.removeChild(item);
        }
    })
    const nextPage = document.getElementById('nextPage');  
    for (let i = 1; i <= TotalPages; i++) {
        const button = document.createElement('button');
        button.textContent = i; 
        pageItem.insertBefore(button, nextPage);
        button.onclick = () => {
            CurPage = i;
            displayPage(data)
        };
        if (i === CurPage) {
            button.style.background = "#0B65A0";
            button.style.color = "#FFFFFF";
        }
    };

};