let player;
let parser;
let isPlaying = true;
let pausePercentage = 0;
let ModuleList = [];
let StartTimeStamp =0;
let EndTimeStamp = 0;
const AllSelectBT = document.getElementById("allSelect");
const AllSelectModule = document.querySelectorAll('input[name="collectList"]');
const StartTimeBT = document.getElementById("startTime");
const EndTimeBT = document.getElementById("endTime");
const ApplyBT = document.getElementById("apply");
const StopBT = document.getElementById("stop");
const DownloadDisableBT = document.getElementById("download-disable");
const DownloadShowBT = document.getElementById("download-show");
const WaitForCollectResText = document.getElementById("waitForCollectRes").value;
const GetHistCollectText = document.getElementById("getCollectRes").value;
const StopHistCollectText = document.getElementById("stopCollect").value;
const SuccText = document.getElementById("success").value;
const FailedText = document.getElementById("failed").value;
const CollecResSucc = 1;//信息采集成功返回值
const CollecResFal = -1;//信息采集失败返回值
const CollecResWait = 0;//信息采集等待返回值

const StartHistoryCollectSuccCode = 50010;//启动日志采集返回正确码


document.addEventListener('DOMContentLoaded', function () {
    loadSvga()
    AllSelectBT.addEventListener('click', function () { 
        if (!AllSelectBT.checked) {
            ModuleList = [];
            console.log("clear all module list");
        }
        AllSelectModule.forEach(function (m) { 
            m.checked = AllSelectBT.checked;
            if (AllSelectBT.checked) {
                if (m.value === "gnb-local-config"){
                    ModuleList.push("cu-config","du-config","phy-config","agent-config","logwriter-config","sysrepocfgtool-config","baseservice-config")
                }else{
                    ModuleList.push(m.value)
                }
            }
        });
        console.log("module list:", ModuleList);
    });
    submitModule();

    StartTimeBT.addEventListener('change', function () { 
        StartTimeStamp = turn2SecTimeStamp(StartTimeBT.value);
        console.log("start time:", StartTimeStamp);
    });

    EndTimeBT.addEventListener('change', function () { 
        EndTimeStamp = turn2SecTimeStamp(EndTimeBT.value);
        console.log("end time:", EndTimeStamp);
    });

    // 应用
    ApplyBT.addEventListener('click', function () { 
        loadSvga();
        console.log("start collect, req.data:",JSON.stringify({
            "list": ModuleList,
            "startTime": StartTimeStamp,
            "endTime":EndTimeStamp
        }));
        HttpPost('/api/v1/history-collect', JSON.stringify({
            "list": ModuleList,
            "startTime": StartTimeStamp,
            "endTime":EndTimeStamp
        }), (error, resp) => {
            if (error) {
                console.log("start collect history failed, err:", error);
                parent.showTipMessage({message:error,type:"error"})
            } else {
                if (resp.code === StartHistoryCollectSuccCode) {
                    console.log("start collec history succ");
                    waitForCollectRes();
                } else {
                    console.log("start collec history failed, err:",resp.msg);
                    parent.showTipMessage({message:error,type:"error"})
                }
            }
        });
    });
    // 下载
    DownloadShowBT.addEventListener('click', function () { 
        console.log("start download collect info");
        download("historyInfo", document);
        console.log("download success");
        ApplyBT.style.display = "block";
        StopBT.style.display = "none";
        DownloadShowBT.style.display = "none";
    });

    // 停止
    StopBT.addEventListener('click', function () { 
        console.log("stop collect info");
        HttpGet('/api/v1/stop-history-collect', (error, resp) => {
            if (error) {
                console.log("stop collect info failed, err:", error);
                ApplyBT.style.display = "block";
                StopBT.style.display = "none";
                DownloadShowBT.style.display = "none";
                DownloadDisableBT.style.display = "none";
                parent.showTipMessage({message:StopHistCollectText + FailedText,type:"error"});
            } else {
                if (resp.code === 200) {
                    console.log("stop collect success");
                    ApplyBT.style.display = "block";
                    StopBT.style.display = "none";
                    DownloadShowBT.style.display = "none";
                    DownloadDisableBT.style.display = "none";
                    parent.showTipMessage({message:StopHistCollectText + SuccText,type:"info"});
                } else {
                    console.log("stop collect failed, err:", error);
                    parent.showTipMessage({message:StopHistCollectText + FailedText,type:"error"});
                }
            }
        });
    });
});


// 等待返回结果
function waitForCollectRes() {
    // 显示暂停、下载按钮
    ApplyBT.style.display = "none";
    StopBT.style.display = "block";
    DownloadDisableBT.style.display = "block";
    parent.showTipMessage({message:WaitForCollectResText,type:"info"});
    // 周期查询结果
    var timerId = setInterval(function () {  
        HttpGet('/api/v1/query-history-collect', (error, resp) => {
            if (error) {
                console.log("query history collect info failed, err:", error);
                ApplyBT.style.display = "block";
                StopBT.style.display = "none";
                DownloadDisableBT.style.display = "none";
                parent.showTipMessage({message:GetHistCollectText+ FailedText,type:"error"});
                clearTimeout(timerId);
                return
            } else {
                if (resp.data === CollecResSucc) {
                    console.log("history collect info success");
                    // 下载收集压缩日志
                    parent.showTipMessage({message:GetHistCollectText + SuccText,type:"info"});
                    DownloadDisableBT.style.display = "none";
                    DownloadShowBT.style.display = "block";
                    clearTimeout(timerId);
                }
                if (resp.data === CollecResFal) {
                    console.log("history collect info failed");
                    parent.showTipMessage({message: GetHistCollectText + FailedText,type:"error"});
                    ApplyBT.style.display = "block";
                    StopBT.style.display = "none";
                    DownloadDisableBT.style.display = "none";
                    clearTimeout(timerId);
                }
                if (resp.data === CollecResWait) {
                    console.log("wait for collect res");
                    parent.showTipMessage({message:WaitForCollectResText,type:"info"},document);
                }
            };
        });
    }, 5000);
};


// 监听选择的module
function submitModule() {
    AllSelectModule.forEach(function (module) { 
        module.addEventListener('change', function () {
            if (module.checked) {
                ModuleList.push(module.value); 
                console.log("choose module:", ModuleList);
            } else {
                let index = ModuleList.indexOf(module.value);
                if (index !== -1) {
                    ModuleList.splice(index, 1);
                }
                console.log("choose module:",ModuleList)
            }
        });
    });
};

// 加载动画
function loadSvga() {
        player = new SVGA.Player('#sports-search');
        player.loops=0;
        parser = new SVGA.Parser('#sports-search');
        parser.load('src/image/search.svga', function(videoItem) {
            player.setVideoItem(videoItem);
            player.startAnimation();
            player.onFrame(function(iframe) {
                pausePercentage = iframe;
            })
        })
};

// 动画暂停
function playPause() {
    if (isPlaying) {
        player.stepToFrame(pausePercentage,true);
        isPlaying = true;
    } else {
        player.pauseAnimation();
        isPlaying = false;
    }
};
