function HttpGet(url,callback) {
  fetch(url)  
    .then(response => {  
      if (!response.ok) {  
          throw new Error('Network response was not ok');  
      }  
      return response.json(); // 假设服务器返回JSON  
    })  
    .then(data => {  
      // console.log(data); // 处理数据 
      callback(null,data)
    })  
    .catch(error => {  
      callback(error);  
    });
};

function HttpPost(url,data,callback) {
  // 将数据转换为JSON字符串，并设置正确的Content-Type  
  fetch(url, {  
    method: 'POST',  
    // headers: {  
    //   'Content-Type': 'application/json',  
    // },  
    body: data, 
  })  
  .then(response => {  
    if (!response.ok) {  
        throw new Error('Network response was not ok');  
    }  
    return response.json(); // 假设服务器响应JSON  
  })  
  .then(data => {  
    console.log(data); // 处理响应数据 
    callback(null,data)
  })  
  .catch(error => {  
    console.error('Fetch error:', error);  
    callback(error)
  });
};

