const INVALID_PWD_MSG = document.getElementById("invalidPwdText").innerText; //密码不规范
const INVALID_LOGIN_TIME_MSG = document.getElementById("invalidLoginTimeText").innerText; //无效的登陆超时时间
const EDIT_PWD_MSG = document.getElementById("editPwdText").innerText; //修改密码
const SUCC_MSG = document.getElementById("successText").innerText; //成功
const FAL_MSG = document.getElementById("failedText").innerText; //失败
const NOT_SAME_MSG = document.getElementById("notSameText").innerText; //不匹配
const NEW_PWD_MSG = document.getElementById("newPwdText").innerText; //新密码
const CUR_PWD_MSG = document.getElementById("curPwdText").innerText; //当前密码
const REPEAT_PWD_MSG = document.getElementById("repeatNewPwdText").innerText; //重复密码
const successMsg =  document.getElementById("successText").innerText;
const IS_EMPTY_MSG = document.getElementById("isEmptyText").innerText; //为空
const loginTimeInput = document.getElementById('loginTime');
const DateInfo = document.getElementById('date');
const TimeInfo = document.getElementById('timeStr');
const iframe = document.getElementById('myIframe')


document.addEventListener("DOMContentLoaded", function () {
    getTime()
setInterval(function () {
        getTime()
}, 1000)
    var thumbnail = document.getElementById('thumbnail_11');
    var dropdown = document.getElementById('dropdown');

    thumbnail.addEventListener('click', function () {
        if (dropdown.style.display === 'none' || dropdown.style.display === '') {
            dropdown.style.display = 'block';
        } else {
            dropdown.style.display = 'none';
        }
    });

    // Optional: Add a click listener to the document to close the dropdown if clicked outside
    document.addEventListener('click', function (event) {
        if (!thumbnail.contains(event.target) && !dropdown.contains(event.target)) {
            dropdown.style.display = 'none';
        }
    });

    // 处理侧边栏菜单的点击事件
    let items = document.querySelectorAll(".sidebar ul li:not(.has-submenu)");
    items.forEach(function(item) {
        item.addEventListener("click", function(event) {
            let src = this.getAttribute("data-src");
            if (src) {
                document.getElementById("embedded").src = src;
            }
        });
    });

    // 处理网元监控的下拉菜单显示和隐藏
    let submenuItems = document.querySelectorAll(".sidebar ul li.has-submenu");
    submenuItems.forEach(function(item) {
        item.addEventListener("click", function(event) {
            event.stopPropagation(); // 阻止事件冒泡
            let isOpen = item.classList.contains("open");
            submenuItems.forEach(function(subItem) {
                subItem.classList.remove("open"); // 关闭其他子菜单
            });
            if (!isOpen) {
                item.classList.add("open"); // 打开点击的子菜单
            }
            // 更新菜单项位置
            updateMenuPositions();
        });
    });

    let submenuLinks = document.querySelectorAll(".sidebar ul li.has-submenu .submenu li");
    submenuLinks.forEach(function(link) {
        link.addEventListener("click", function(event) {
            event.stopPropagation();
            let src = this.getAttribute("data-src");
            if (src) {
                document.getElementById("embedded").src = src;
            }
        });
    });

    // 获取修改密码的链接或按钮
    const changePasswordLink = document.getElementById('editPwd');
    // 获取退出登录按钮
    var logout = document.getElementById('logout');
    // 登陆设置按钮
    var loginCfg = document.getElementById('loginCfg');

    // 获取弹窗元素
    const changePasswordModal = document.getElementById('changePasswordModal');
    const loginCfgTable = document.getElementById('loginCfgTable');
    const modalOverlay = document.getElementById('modalOverlay');

    const closeModalElements = document.querySelectorAll('.close-modal');
    const submitButton = document.getElementById('submitChangePassword');
    
    const loginCfgBT = document.getElementById('loginCfg-datermine');
    const loginCfgExitButton = document.getElementById('loginCfg-cancelTable');
    const changePwdExitButton = document.getElementById('changePwd-cancelTable');


    // 点击链接或按钮时显示弹窗和遮罩层
    changePasswordLink.addEventListener('click', function(event) {
        event.preventDefault(); // 阻止默认行为，这里防止链接跳转
        changePasswordModal.style.display = 'block'; // 显示弹窗
        modalOverlay.style.display = 'block';
    });

    // 点击弹窗外部或退出按钮关闭弹窗
    changePasswordModal.addEventListener('click', function(event) {
        if (event.target === changePasswordModal || event.target.classList.contains('close-modal')) {
            changePasswordModal.style.display = 'none'; // 隐藏弹窗
            loginCfgTable.style.display = 'none';
        }
    });
    closeModalElements.forEach(function(element) {
        element.addEventListener('click', function() {
            changePasswordModal.style.display = 'none';
            modalOverlay.style.display = 'none';
            loginCfgTable.style.display = 'none';
        });
    });

    loginCfgExitButton.addEventListener('click', function() {
        loginCfgTable.style.display = 'none';
        modalOverlay.style.display = 'none';
    });

    changePwdExitButton.addEventListener('click', function() {
        changePasswordModal.style.display = 'none';
        modalOverlay.style.display = 'none';
    });

    // 登陆设置
    loginCfg.addEventListener('click',function(){
        getLoginTime();
        loginCfgTable.style.display = "block";
        modalOverlay.style.display = 'block';
    });

    // 下发登陆设置
    loginCfgBT.addEventListener('click',function(){
        if (loginTimeInput.value >=1 && loginTimeInput.value <=1440){
            HttpPost('/api/v1/config', JSON.stringify({
                "module": "gnb_agent",
                "operation": "update",
                "extension": {"loginTime":loginTimeInput.value},
        }), (error, resp) => { 
            if (error) {
                console.log("set loginTime config err:",error);
            } else {
                if (resp.code === 1034) {
                    parent.showTipMessage({message: successMsg, type: "success"});
                        // 复位agent
                    HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"restart"}) ,(error, resp) => { 
                    if (error) {
                            console.log("restart gnb_agent error:",error)
                        } else {
                            if (resp.code === 1034){
                                parent.showTipMessage({message:resp.msg,type:"info"});
                            }else{
                                parent.showTipMessage({message:resp.msg,type:"error"});
                            }
                        }
                    });
                    window.parent.location.href = "/wait"
                }else{
                    parent.showTipMessage({message: resp.msg, type: "error"});
                }
            }
        });
        }else{
            showTipMessage({message:INVALID_LOGIN_TIME_MSG,type:"error"})
        }
    });

    // 清除缓存数据并跳转到login.html
    logout.addEventListener('click', function () {
        HttpGet("/logout",(error,resp)=>{
            if (error){
                console.log(error);
            }else{
                if (resp.code === 200){
                    console.log("logout success")
                    window.parent.location.href = "/login"
                }
            }
        });
    });

    // 防止页面缓存
    window.onpageshow = function(event) {
        if (event.persisted) {
            window.location.reload();
        }   
    };

    // 修改密码提交事件
    submitButton.addEventListener('click', function(event) {
        event.preventDefault(); // 阻止默认表单提交
        let userNameElement = document.getElementById("inputUserName");
        let userName = userNameElement.value || userNameElement.innerText; // 尝试获取value，如果没有再尝试获取innerText
        let newPassword = document.getElementById("newPassword").value;
        let repeatNewPassword = document.getElementById("repeatNewPassword").value;
        let password = document.getElementById("inputPassword").value;
        //最短6位，大小写字母、数字、特殊字符中至少包含2种
        if (newPassword === ""|| repeatNewPassword === ""||password === "") {
            showTipMessage({message:NEW_PWD_MSG+CUR_PWD_MSG+REPEAT_PWD_MSG+IS_EMPTY_MSG,type:"error"});
            return;
        }
        if (!checkPassword(newPassword)) {
            showTipMessage({message:EDIT_PWD_MSG + FAL_MSG+":"+INVALID_PWD_MSG,type:"error"});
            return;
        }

        if (newPassword !== repeatNewPassword) {
            showTipMessage({message:NEW_PWD_MSG+REPEAT_PWD_MSG+NOT_SAME_MSG,type:"error"});
            return;
        }
        // 发送修改密码请求
        HttpPost("/changePassword", JSON.stringify({
            "curPwd":password,
            "name": userName,
            "password": newPassword
        }), (error, respData) => {
            if (error) {
                console.log("修改密码失败:", error);
            } else {
                if (respData.code == 2000) {
                    console.log("修改密码成功");
                    showTipMessage({message:EDIT_PWD_MSG + SUCC_MSG,type:"info"});
                    changePasswordModal.style.display = 'none';
                    modalOverlay.style.display = 'none';
                    window.parent.location.href = "/login"
                } else {
                    console.log("修改密码失败:", respData);
                    showTipMessage({message:EDIT_PWD_MSG + FAL_MSG+":" + respData.msg,type:"error"});
                }
            }
        });
    });


    // 更新菜单项位置
    function updateMenuPositions() {
        let netElementsMonitor = document.querySelector('.has-submenu');
        let isnetElementsMonitorOpen = netElementsMonitor.classList.contains('open');
        let softwareManage = document.querySelector('.softwareManage');
        let isSoftwareManageOpen = softwareManage.classList.contains('open');
        let historyCollect = document.querySelector('[data-src="historyCollect"]');
        
        if (isnetElementsMonitorOpen) {
            softwareManage.style.marginTop = (5 * 50) + "px"; // Adjust based on submenu items
        } else {
            softwareManage.style.marginTop = "";
        }

        if (isSoftwareManageOpen) {
            historyCollect.style.marginTop = (3 * 50) + "px";
        } else {
            historyCollect.style.marginTop = "";
        }
    }

    const menuItems = document.querySelectorAll('.sidebar ul li');
    const submenuItems1 = document.querySelectorAll('.sidebar .submenu li');

    menuItems.forEach(item => {
        item.addEventListener('click', function () {
            menuItems.forEach(li => li.classList.remove('active'));
            submenuItems1.forEach(li => li.classList.remove('active'));
            this.classList.add('active');
            const submenu = this.querySelector('.submenu');
            if (submenu) {
                submenu.querySelectorAll('li').forEach(subItem => {
                    subItem.addEventListener('click', function () {
                        submenu.querySelectorAll('li').forEach(li => li.classList.remove('active'));
                        this.classList.add('active');
                    });
                });
            }
        });
    });


    let submenuLinks1 = document.querySelectorAll(".sidebar ul li.has-submenu .submenu li");
    submenuLinks1.forEach(function(link) {
        link.addEventListener("click", function(event) {
            event.stopPropagation();
            let src = this.getAttribute("data-src");
            if (src) {
                document.getElementById("embedded").src = src;
            }

            // 高亮显示父菜单项
            let parentItem = this.closest('.has-submenu');
            if (parentItem) {
                parentItem.classList.add('active');
            }
        });
    });
    setInterval(() => {
        HttpGet("/updateSession",(error,resp)=>{
            if (error){
                console.log("update session failed, err:",error);
                window.parent.location.href = "login";
            }else{
                if (resp.code !== 1034){
                    console.log("session timeout");
                    window.parent.location.href = "login";
                }
            }
        });
    }, 5000); // 每5s检查一次会话状态
});


//根据permissionName设置背景颜色
document.addEventListener('DOMContentLoaded', (event) => {
    const textWrapper = document.querySelector('.text-wrapper_5');
    const textElement = document.querySelector('.text_8');
    const permissionName = textWrapper.getAttribute('data-permission-name');

    if (permissionName === "管理员" || permissionName === "Administrator") {
        // textWrapper.style.backgroundColor = 'rgba(250,220,51,0.1)';
        textWrapper.style.backgroundColor = '#FFF0D6';
        textElement.style.color = '#FF8933';
                
    } else if (permissionName === "维护员" || permissionName === "Maintainer") {
        textWrapper.style.backgroundColor = 'rgba(234, 249, 255, 1)';
        textElement.style.color = 'rgba(11, 101, 160, 1)';
    } 
});


// 提示条显示
function showTipMessage({ message = '', type = 'info', duration = 2000 }) {
    // console.log("showMsg:", message, ", type:", type);
    let messageContainer = document.getElementById("message-container");
    // 创建消息元素
    const messageElement = document.createElement('div');
    messageElement.textContent = message;
    messageElement.style.cssText = `
        min-width: 460px;
        min-height: 40px;
        padding:10px 50px;
        box-sizing: border-box;
        margin-top:5px;
        border-radius: 4px;
        border: 1px solid ${getMessageBorder(type)};
        font-size: 12px;
        line-height: 16px;
        text-align: left;
        font-style: normal;
        color: ${getMessageColor(type)};
        background-color: ${getMessageBackgroundColor(type)};
        opacity: 0;
        transition: opacity 0.3s ease;
        position: relative;
    `;

    const icon = document.createElement('span');
    icon.style.cssText=`
        position: absolute;
        top:10px;
        left:20px;

    `;
    icon.className = getMessageClass(type);

    // console.log(icon);
    messageElement.appendChild(icon);

    // 将消息添加到容器中
    messageContainer.appendChild(messageElement);

    // 显示消息
    requestAnimationFrame(() => {
        messageElement.style.opacity = '1';
    });

    // 设置自动隐藏
    setTimeout(() => {
        messageElement.style.opacity = '0';
        messageElement.addEventListener('transitionend', () => {
            messageElement.remove();
        });
    }, duration);
};
function getMessageBackgroundColor(type) {
    switch (type) {
        case 'success':
            return '#F1F7E5';
        case 'warning':
            return '#FFF3EA';
        case 'error':
            return '#FFEEEA';
        default:
            return '#F1F7E5';
    }
};

function getMessageColor(type){
    switch (type) {
        case 'success':
            return '#77B300';
        case 'warning':
            return '#FF8933';
        case 'error':
            return '#FF5533';
        default:
            return '#77B300';
    }
};

function getMessageBorder(type){
    switch (type) {
        case 'success':
            return 'rgba(119,179,0,0.3)';
        case 'warning':
            return 'rgba(255,137,51,0.3)';
        case 'error':
            return 'rgba(255,85,51,0.3)';
        default:
            return 'rgba(119,179,0,0.3)';
    }
};

function getMessageClass(type){
    switch (type) {
        case 'success':
            return 'iconfont icon-chenggong';
        case 'warning':
            return 'iconfont icon-jinggao';
        case 'error':
            return 'iconfont icon-shibai';
        default:
            return 'iconfont icon-chenggong';
    }
};

function checkPassword(newPassword) {
    // 检查是否既有大写字母又有小写字母
    const hasBothCases = /[a-z]/.test(newPassword) && /[A-Z]/.test(newPassword);
    
    // 检查是否包含字母和数字
    const hasLettersAndNumbers = /[a-zA-Z]/.test(newPassword) && /\d/.test(newPassword);
    
    // 检查是否包含字母和特殊字符
    const hasLettersAndSpecialChars = /[a-zA-Z]/.test(newPassword) && /[^a-zA-Z0-9]/.test(newPassword);
    
    // 检查是否包含数字和特殊字符
    const hasNumbersAndSpecialChars = /\d/.test(newPassword) && /[^a-zA-Z0-9]/.test(newPassword);
    
    // 如果以上条件都不满足，则不符合规范
    return (hasBothCases || hasLettersAndNumbers || hasLettersAndSpecialChars || hasNumbersAndSpecialChars)
}

// 模糊背景
function blurBG() { 
    document.getElementById("bg").classList.add('blur-bg');
};

// 取消模糊背景
function showBG() { 
    // console.log("清晰")
    document.getElementById("bg").classList.remove('blur-bg');
};

function getLoginTime(){
    HttpPost('/api/v1/config', JSON.stringify({
        "module": "gnb_agent",
        "operation": "get",
        "extension": {"loginTime":""},
}), (error, resp) => { 
    if (error) {
        console.log("get loginTime config err:",error);
    } else {
        var recv = JSON.parse(resp.data);
        loginTimeInput.value = recv.loginTime;
    }
});
}

function getTime(){
    HttpPost('/api/v1/get-time', null, (error, resp) => { 
    if (error) {
        console.log("get time err:",error);
    } else {
        var recv = JSON.parse(resp.data);
        DateInfo.textContent = recv.date;
        TimeInfo.textContent = recv.timeStr;
        if (document.getElementById("embedded").contentWindow.document.getElementById("UTCTime")){
            document.getElementById("embedded").contentWindow.document.getElementById("UTCTime").innerText = recv.date+" "+recv.timeStr;
        }
    }
});
}