let CellId = 1;
const SelectCellId = document.getElementById("selectCellId");

document.addEventListener('DOMContentLoaded', function () {
    // timer get status info
    getIndicatorData()
    setInterval(function () {
        getIndicatorData()
    }, 2000)

    // cell id select
    SelectCellId.addEventListener('change',function(event){
        CellId = event.target.options[event.target.selectedIndex].textContent;
        getIndicatorData()
    });
});

// 获取指标数据
function getIndicatorData(){
    HttpGet('/api/v1/gnb-indicator', (error, resp) => {
        if (error) {
            console.log("get indicator data error:",error);
        } else {
            var data = JSON.parse(resp.data);
            // console.log("recv indicator:",data)
            // update cell indicator
            if (data.cell[CellId] === undefined || data.cell[CellId] === null || data.cell.len === 0){
                updateSection({"timeStr":""});
                return
            };
            if (data.timeStr !== undefined && data.timeStr !== ""){
                updateSection({"timeStr":data.timeStr});
            };
            updateCellData(data.cell);
        };
    })
};

// 更新基站小区指标
function updateCellData(data){
    let cellidArry = Object.keys(data);
    if (SelectCellId.options.length != cellidArry.length){
        //清除CellID option
        while (SelectCellId.firstChild) {
            SelectCellId.removeChild(SelectCellId.firstChild); 
        }
        for (const cellId of cellidArry) {
            // console.log("cellId:",cellId)
            const option = document.createElement("option");
            option.textContent = cellId;
            SelectCellId.appendChild(option);
        }
    }

    updateSection({
        "phyUlTput": data[CellId]["ul-phy-tput"],
        "phyDlTput": data[CellId]["dl-phy-tput"],
        "cuCellRecvDlTput": data[CellId]["cu_ul_gnb_recv_tput"], //cu接收吞吐量上下行颠倒
        "cuCellRecvUlTput": data[CellId]["cu_dl_gnb_recv_tput"],
        "cuCellSendUlTput": data[CellId]["cu_ul_gnb_snd_tput"],
        "cuCellSendDlTput": data[CellId]["cu_dl_gnb_snd_tput"],
        "cellDlTput": data[CellId]["dl-cell-tput"],
        "cellUlTput": data[CellId]["ul-cell-tput"],
        "socTemp":data[CellId]["soc-temp"],
        "paDrainVoltage1":data[CellId]["pa-drainVoltage-0"],
        "paDrainVoltage2":data[CellId]["pa-drainVoltage-1"],
        "paDrainVoltage3":data[CellId]["pa-drainVoltage-2"],
        "paDrainVoltage4":data[CellId]["pa-drainVoltage-3"],
        "paGridVoltage1":data[CellId]["pa-gridVoltage-0"],
        "paGridVoltage2":data[CellId]["pa-gridVoltage-1"],
        "paGridVoltage3":data[CellId]["pa-gridVoltage-2"],
        "paGridVoltage4":data[CellId]["pa-gridVoltage-3"],
        "paFinalCurrent1":data[CellId]["pa-finalCurrent-0"],
        "paFinalCurrent2":data[CellId]["pa-finalCurrent-1"],
        "paFinalCurrent3":data[CellId]["pa-finalCurrent-2"],
        "paFinalCurrent4":data[CellId]["pa-finalCurrent-3"],
        "paTemp1":data[CellId]["pa-temp-0"],
        "paTemp2":data[CellId]["pa-temp-1"],
        "paTemp3":data[CellId]["pa-temp-2"],
        "paTemp4":data[CellId]["pa-temp-3"],
        "paOutputPower1":data[CellId]["pa-outputPower-0"],
        "paOutputPower2":data[CellId]["pa-outputPower-1"],
        "paOutputPower3":data[CellId]["pa-outputPower-2"],
        "paOutputPower4":data[CellId]["pa-outputPower-3"],
        "paReflectPower1":data[CellId]["pa-reflectPower-0"],
        "paReflectPower2":data[CellId]["pa-reflectPower-1"],
        "paReflectPower3":data[CellId]["pa-reflectPower-2"],
        "paReflectPower4":data[CellId]["pa-reflectPower-3"],
        "paVSWR1" :data[CellId]["pa-VSWR-0"],
        "paVSWR2" :data[CellId]["pa-VSWR-1"],
        "paVSWR3" :data[CellId]["pa-VSWR-2"],
        "paVSWR4" :data[CellId]["pa-VSWR-3"],
    });
};