const ShuaXin = document.getElementById("shuaxin");
const ActiveDate = document.getElementById("activeDate");
const SetActive = document.getElementById("setActivated");
const UploadFile = document.getElementById("uploadFile");
const FailedTip = window.parent.document.getElementById("failedTipWindow");
const SuccessTip = window.parent.document.getElementById("successTipWindow");
const WaitTip = window.parent.document.getElementById("waitTipWindow");
const LicenseTip = document.getElementById("licenseTip");

const WaitPkgName = window.parent.document.getElementById("waitPkgName");
const Bar = window.parent.document.getElementById("bar");
const PgBarText = window.parent.document.getElementById("pgBarText");


const AlreadyText = document.getElementById("alreadyText").innerText;
const UploadPkgText = document.getElementById("uploadText").innerText;
const InvalidFileText = document.getElementById("invalidFileText").innerText;
const FileSizeExceedLmitText = document.getElementById("fileSizeExceedLmitText").innerText;
const ToBeActivatedText = document.getElementById("toBeActivatedText").innerText;

const GetLicenseSuccCode = 4070; //获取license文件信息正确码;
const LicenseFileLmit = 1024 * 1024 * 50;//mb


getLicenseInfo();
document.addEventListener('DOMContentLoaded', function () {
    ShuaXin.addEventListener('click', function () {
        getLicenseInfo();
    });
    SetActive.addEventListener('click', function () {
        UploadFile.click();
        UploadFile.addEventListener("change", function (event) {
            SetLicenseActive(event);
        });
    });
    SetActive.addEventListener('mouseover', function () {
        LicenseTip.style.display = "block";
    });
    SetActive.addEventListener('mouseout', function () {
        LicenseTip.style.display = "none";
    });
});


// 激活license
function SetLicenseActive(event) {
    if (event.target.files && event.target.files[0]) {
        const file = event.target.files[0];
        WaitTip.style.display = "block";
        parent.blurBG();
        WaitPkgName.innerText = file.name;
        const chunkSize = 1024 * 1024;
        console.log("upload license file size:", file.size);
        if (file.name != "sys_license.cfg") {
            WaitTip.style.display = "none";
            showWindow(FailedTip, "#uploadFal", InvalidFileText, false);
            return
        }

        if (file.size >=  LicenseFileLmit) {
            WaitTip.style.display = "none";
            showWindow(FailedTip, "#uploadFal", FileSizeExceedLmitText, false);
            return
        }
        console.log("check license file success");
        uploadChunk(file, 0, chunkSize, "api/v1/upload-license");
    }
};

// 回调上传chunk
function uploadChunk(file, start, chunkSize, url) {  
    if (start >= file.size) {  
        console.log("All chunks uploaded successfully");
        WaitTip.style.display = "none";
        showWindow(SuccessTip, "#uploadSucc");
        console.log("show success tip");
        return  
    }
    const end = Math.min(file.size - 1, start + chunkSize - 1);  
    uploadFile(file, start, end, url, (error) => {  
        if (error) {  
            console.log("upload failed, err:", error);
            WaitTip.style.display = "none";
            showWindow(FailedTip, "#uploadFal", error,false);
            return   
        } else {  
            console.log("upload success");
            moveBar(((end + 1)/file.size),AlreadyText+UploadPkgText,Bar,PgBarText)
            uploadChunk(file, end + 1, chunkSize, url); // 递归调用  
        }  
    });
};

// 获取license文件
function getLicenseInfo() {
    console.log("start get license info");
        HttpGet("api/v1/license-info", (error, resp) => {
        if (error) {
            console.log("get license file failed, err:", error);
            return
        } else {
            if (resp.code === GetLicenseSuccCode) {
                let data = JSON.parse(resp.data);
                let licenseInfo;
                
                if (data.name !="" && data.activeTime != "") {
                    licenseInfo = {
                        "licenseName": data.name,
                        "activeDate":data.activeTime
                    };
                    ActiveDate.style.color = "#77B300";
                } else if (data.name !=""&& data.activeTime == "") {
                    licenseInfo = {
                        "licenseName": data.name,
                    };
                    ActiveDate.style.color = "#FF5533";
                } else {
                    licenseInfo = {
                        "licenseName": "",
                        "activeDate": ""
                    };
                    ActiveDate.style.color = "#77B300";
                }
                updateSection(licenseInfo);
            } else {
                console.log("get license file failed, err:", resp.msg);
            }
        }
    });
};