let MemData = [];
let CpuUsageData = [];
let CpuTempData = [];
let MemCharts 
let CpuUsageCharts
let CpuTempCharts
document.addEventListener('DOMContentLoaded', function () {
    MemCharts = createCharts(document.getElementById("mem-chart"),"MEM","line");
    CpuUsageCharts = createCharts(document.getElementById("cpu-usage-chart"),"CPU-USAGE","line");
    CpuTempCharts = createCharts(document.getElementById("cpu-temp-chart"),"CPU-TEMP","line");
    getResourceData()
    setInterval(function () {
        getResourceData()
    }, 2000)
});



// 获取资源监控数据
function getResourceData(){
    HttpGet('/api/v1/gnb-resource-data',(error,response)=>{
        if (error){
            console.log(error);
            return
        }else{
            //处理mem
            let data = JSON.parse(response.data)
            updateChartData(MemCharts,MemData,data.time,data.memUsage)
            updateChartData(CpuUsageCharts,CpuUsageData,data.time,data.cpuUsage)
            updateChartData(CpuTempCharts,CpuTempData,data.time,data.cpuTemp)
        }
    });
};

// 获取mem数据
function updateChartData(c,d,timeD,recvVal){
    d.push([timeD * 1000, recvVal]);
    c.hideLoading();
    // 移除最旧的元素
    if (d.length > 60) {
        d.shift(); 
    }
    updateEchartTableData(c,d);
}
