// 正常状态描述信息
const normal = document.getElementById("normalText").innerText;
// 异常状态描述信息
const abnormal = document.getElementById("abnormalText").innerText;
// 未知状态描述信息
const unknown = document.getElementById("unknownText").innerText;
// 同步状态描述信息
const synchro = document.getElementById("synchroText").innerText;
// 不同步状态描述信息
const unsynchro = document.getElementById("unsynchroText").innerText;
// 失锁状态描述信息
const unlock = document.getElementById("unlockText").innerText;
// 停止状态描述信息
const stopStr = document.getElementById("stopText").innerText;
// 启动状态描述信息
const startStr = document.getElementById("startText").innerText;
// 合并状态描述信息
const merger = document.getElementById("mergerText").innerText;
// 未合并状态描述信息
const unmerger = document.getElementById("unmergerText").innerText;
// 是否继续操作确认弹窗
const isRebootTipWindow = window.parent.document.getElementById("isRebootTipWindow");
// 确认操作
const isRebootBT = window.parent.document.getElementById("isReboot");
//取消操作
const noRebootBT = window.parent.document.getElementById("noReboot");
// cmd success code
const SuccessCode = 1034;
// watch dog switch
const WatchDogBT = document.getElementById("watchdog-button");
// 请先关闭看门狗使能，再执行操作
const PleaseStopWatcgDog = document.getElementById("pleaseStopWatchdogText").innerText;


document.addEventListener('DOMContentLoaded', function () {
    // 获取当前看门狗使能开关配置
    getWatchDogSw();
    
    // edit agent watch dog switch
    const watchDogServer = new MutationObserver(mutations => {
        mutations.forEach(
            mutation => {
                if (mutation.attributeName === 'value') {
                    console.log("watch dog val:", WatchDogBT.getAttribute("value"))
                    let reqData = {};
                    if (WatchDogBT.getAttribute("value") === "on") {
                        reqData = {"watchDogSw":true}
                    } else {
                        reqData = {"watchDogSw":false}
                    }
                    console.log("send update watch dog")
                    HttpPost('/api/v1/config', JSON.stringify({
                        "module": "gnb_agent",
                        "operation": "update",
                        "extension": reqData,
                    }), (error, resp) => { 
                    if (error) {
                        console.log("update watch dog config error:",error)
                    } else {
                        if (resp.code == SuccessCode){
                            parent.showTipMessage({message:resp.msg,type:"info"});
                        }else{
                            parent.showTipMessage({message:resp.msg,type:"error"});
                        }
                        
                    }
                });
                    // 复位agent
                    HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"restart"}) ,(error, resp) => { 
                        if (error) {
                            console.log("restart gnb_agent error:",error)
                        } else {
                            if (resp.code === SuccessCode){
                                parent.showTipMessage({message:resp.msg,type:"info"});
                            }else{
                                parent.showTipMessage({message:resp.msg,type:"error"});
                            }
                        }
                    });
                    window.parent.location.href = "/wait"
                }
            }
        )
    });
    watchDogServer.observe(WatchDogBT, { attributes: true ,attributeFilter: ['value'] });

    // timer get status info
    getStatusInfo()
    setInterval(function () {
        getStatusInfo()
    }, 10000)
    noRebootBT.onclick = function (){
        isRebootTipWindow.style.display = "none"
        parent.showBG();
    };
    document.getElementById("reboot").onclick = function () {
        isRebootTipWindow.style.display = "block";
        parent.blurBG();
        isRebootBT.onclick = function(){
        parent.blurBG();
        isRebootTipWindow.style.display = "none"
        console.log("确认复位基站服务器");
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"system","operation":"restart"}) ,(error, resp) => { 
            if (error) {
                console.log("gnb commond reboot error:",error)
            } else {
                console.log("gnb commond reboot success")
            }
        });
        window.parent.location.href = "/wait";
    }
    }
    
    //software
    document.getElementById("restart-software").onclick = function () {
        isRebootTipWindow.style.display = "block";
        parent.blurBG()
        isRebootBT.onclick = function(){
        isRebootTipWindow.style.display = "none"
        parent.blurBG();
        console.log("确认复位基站软件");
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"software","operation":"restart"}) ,(error, resp) => { 
            if (error) {
                console.log("restart software error:",error)
            } else {
                if (resp.code === SuccessCode){
                    parent.showTipMessage({message:resp.msg,type:"info"});
                }else{
                    parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        });
        // 转到登录页面
        window.parent.location.href = "/wait";
    }
    }
    
    //gnbModule
    document.getElementById("start-gnb").onclick = function () {
    HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb","operation":"start"}) ,(error, resp) => { 
            if (error) {
                console.log("start gnb error:",error)
            } else {
                if (resp.code === SuccessCode){
                    parent.showTipMessage({message:resp.msg,type:"info"});
                }else{
                    parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        });
        // 转到登录页面
        window.parent.location.href = "/wait";
    }
    document.getElementById("stop-gnb").onclick = function () {
    // 看门狗开启时提示需要关闭开门狗
    if (WatchDogBT.textResult.textContent === "on"){
        parent.showTipMessage({message:PleaseStopWatcgDog,type:"warning"})
        return
    }
    HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb","operation":"stop"}) ,(error, resp) => { 
        if (error) {
            console.log("stop gnb error:",error)
        } else {
            if (resp.code === SuccessCode){
                parent.showTipMessage({message:resp.msg,type:"info"});
            }else{
                parent.showTipMessage({message:resp.msg,type:"error"});
            }
        }
    })
    }
    document.getElementById("restart-gnb").onclick = function () {
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb","operation":"restart"}) ,(error, resp) => { 
            if (error) {
                console.log("restart gnb error:",error)
            } else {
                if (resp.code === SuccessCode){
                    parent.showTipMessage({message:resp.msg,type:"info"});
                }else{
                    parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        });
        // 转到登录页面
        window.parent.location.href = "/wait";
    }
    //agent
    document.getElementById("start-agent").onclick = function () {
        isRebootTipWindow.style.display = "block";
        parent.blurBG();
        isRebootBT.onclick = function(){
        isRebootTipWindow.style.display = "none"
        parent.blurBG();
        console.log("确认启动agent");
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"start"}) ,(error, resp) => { 
            if (error) {
                console.log("start gnb_agent error:",error)
            } else {
                if (resp.code === SuccessCode){
                    parent.showTipMessage({message:resp.msg,type:"info"});
                }else{
                    parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        });
        window.parent.location.href="/wait"
        }
    }
    document.getElementById("stop-agent").onclick = function () {
        isRebootTipWindow.style.display = "block";
        parent.showBG();      
        isRebootBT.onclick = function(){
            isRebootTipWindow.style.display = "none"
            parent.showBG();
            console.log("确认停止agent");
            HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"stop"}) ,(error, resp) => { 
                if (error) {
                    console.log("stop gnb_agent error:",error)
                } else {
                    if (resp.code === SuccessCode){
                        parent.showTipMessage({message:resp.msg,type:"info"});
                    }else{
                        parent.showTipMessage({message:resp.msg,type:"error"});
                    }
                }
            });
            window.parent.location.href = "/wait"
        }
    }
    document.getElementById("restart-agent").onclick = function () {
        isRebootTipWindow.style.display = "block";
        parent.blurBG();
        isRebootBT.onclick = function(){
            isRebootTipWindow.style.display = "none"
            parent.blurBG();
            console.log("确认复位agent");
            HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"restart"}) ,(error, resp) => { 
                if (error) {
                    console.log("restart gnb_agent error:",error)
                } else {
                    if (resp.code === SuccessCode){
                        parent.showTipMessage({message:resp.msg,type:"info"});
                    }else{
                        parent.showTipMessage({message:resp.msg,type:"error"});
                    }
                }
            });
            window.parent.location.href = "/wait"
        }
    }
    // logwriter
    document.getElementById("restart-logwriter").onclick = function () {
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"logwriter","operation":"restart"}) ,(error, resp) => { 
                if (error) {
                    console.log("restart logwriter error:",error)
                } else {
                    if (resp.code === SuccessCode){
                        parent.showTipMessage({message:resp.msg,type:"info"});
                    }else{
                        parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        })
    }
    document.getElementById("start-logwriter").onclick = function () {
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"logwriter","operation":"start"}) ,(error, resp) => { 
                if (error) {
                    console.log("start logwriter error:",error)
                } else {
                    if (resp.code === SuccessCode){
                        parent.showTipMessage({message:resp.msg,type:"info"});
                    }else{
                        parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        })
    }
    document.getElementById("stop-logwriter").onclick = function () {
        HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"logwriter","operation":"stop"}) ,(error, resp) => { 
                if (error) {
                    console.log("stop logwriter error:",error)
                } else {
                    if (resp.code === SuccessCode){
                        parent.showTipMessage({message:resp.msg,type:"info"});
                    }else{
                        parent.showTipMessage({message:resp.msg,type:"error"});
                }
            }
        })
    }
}
);


// 获取开门狗配置开关状态
function getWatchDogSw(){
        HttpPost('/api/v1/config', JSON.stringify({
            "module": "gnb_agent",
            "operation": "get",
            "extension": {"watchDogSw":""},
    }), (error, resp) => { 
        if (error) {
            console.log("get watch dog config err:",error)
        } else {
            let curWatchDogSw = WatchDogBT.getAttribute("value");
            var recv = JSON.parse(resp.data)
            if (recv.watchDogSw) {
                if (curWatchDogSw !== "on"){
                    WatchDogBT.input.checked = !WatchDogBT.input.checked;
                    WatchDogBT.textResult.textContent = "on";
                }
            } else {
                if (curWatchDogSw === "on"){
                    WatchDogBT.input.checked = !WatchDogBT.input.checked;
                    WatchDogBT.textResult.textContent = "off";
                }
            }
        }
    });
};



// 获取状态信息
function getStatusInfo() { 
    HttpGet('/api/v1/gnb-module-status', (error, resp) => {
        if (error) {
            console.log("get module status error:",error);
        } else {
            var data = JSON.parse(resp.data);
            // console.log("recv status info:",data)
            // gnb status update
            updateSection({
                "phyStatus": getStatus(document.getElementById("phyStatus"),data.phy),
                "duStatus": getStatus(document.getElementById("duStatus"),data.du),
                "cuStatus": getStatus(document.getElementById("cuStatus"),data.cu),
                "logWriterStatus": getStatus(document.getElementById("logWriterStatus"),data.logwriter),
                "baseServiceStatus": getStatus(document.getElementById("baseServiceStatus"),data.baseservice),
                "agentStatus": getStatus(document.getElementById("agentStatus"),"NORMAL"),
                "gpsStatus": getStatus(document.getElementById("gpsStatus"),data.gpsStatus),   
                "cpuMaxTemp":data.cpuMaxTemp,
            });
        };
    })  
}


function getStatus(id,status) {
    switch (status) {
        case "OPEN":
            id.style.color = "#77B300";
            return openStr;
        case "CLOSE":
            id.style.color = "#FF5533";
            return closeStr;
        case "NORMAL":
            id.style.color = "#77B300";
            return normal;
        case "ABNORMAL":
            id.style.color = "#FF5533";
            return abnormal;
        case "UNKNOWN":
            id.style.color = "#FF5533";
            return unknown;
        case "SYNCHRO":
            id.style.color = "#77B300";
            return synchro;
        case "UNSYNCHRO":
            id.style.color = "#FF5533";
            return unsynchro;
        case "UNLOCK":
            id.style.color = "#FF5533";
            return unlock;
        case "STOP":
            id.style.color = "#FF5533";
            return stopStr;
        case "MERGER":
            id.style.color = "#77B300";
            return merger;
        case "UNMERGER":
            id.style.color = "#FF5533";
            return unmerger;
        default:
            console.log("undefined ",status,id)
    }
}

function updateRuStatusInfo(id, info) {
    let pruElement = document.getElementById(id)
    if (info === undefined) {
        // console.log("not found ru status info")
        pruElement.style.display = "block"
        return 
    }
    console.log(id, ", ruInfo:",info)
    pruElement.style.display = "block"

    // version
    if (info.version !== 0){
        pruElement.querySelector("#ruVersion").innerHTML = info.version;
    }

    // channelSw
    let channelSw = pruElement.querySelector("#channelSw");
    channelSw.innerHTML = getStatus(channelSw, info.status);

    // paDrainVoltage paGridVoltage paFinalCurrent freq
    if (info.status === "OPEN"){
        pruElement.querySelector("#ruFreq").innerHTML = info.freq+"HZ";
        pruElement.querySelector("#paDrainVoltage").innerHTML = info.paDrainVoltage + "mV"
        pruElement.querySelector("#paGridVoltage").innerHTML = info.paGridVoltage + "mV"
        pruElement.querySelector("#paFinalCurrent").innerHTML = info.paFinalCurrent + "mV"
        pruElement.querySelector("#paTemp").innerHTML = info.paTemp + "℃"
        pruElement.querySelector("#paOutputPower").innerHTML = info.paOutputPower + "dBm"
        pruElement.querySelector("#paReflectPower").innerHTML = info.paReflectPower + "dBm"
        pruElement.querySelector("#paVSWR").innerHTML = info.paVSWR;
    }
}

function updatePruStatusInfo(id, info) {
    let pruElement = document.getElementById(id)
    if (info === undefined) {
        console.log("not found pru status info")
        pruElement.style.display = "block"
        return 
    }
    console.log(id, ", pruInfo:",info)
    pruElement.style.display = "block"

    // mergerStatus runStatus
    let runStatus = pruElement.querySelector("#runStatus")
    let mergerStatus = pruElement.querySelector("#upwardMergerStatus")

    runStatus.innerHTML = getStatus(runStatus, info.status)
    mergerStatus.innerHTML = getStatus(mergerStatus, info.mergerStatus)

    // atten power
    pruElement.querySelector("#powerAtten0").innerHTML = info.atten[0] + "db"
    pruElement.querySelector("#powerAtten0").style.color = "#1284BB"
    pruElement.querySelector("#powerAtten1").innerHTML = info.atten[1] + "db"
    pruElement.querySelector("#powerAtten1").style.color = "#1284BB"
    pruElement.querySelector("#powerAtten2").innerHTML = info.atten[2] + "db"
    pruElement.querySelector("#powerAtten2").style.color = "#1284BB"
    pruElement.querySelector("#powerAtten3").innerHTML = info.atten[3] + "db"
    pruElement.querySelector("#powerAtten3").style.color = "#1284BB"

    // gain power
    pruElement.querySelector("#powerGain0").innerHTML = info.gain[0] + "db"
    pruElement.querySelector("#powerGain0").style.color = "#1284BB"
    pruElement.querySelector("#powerGain1").innerHTML = info.gain[1] + "db"
    pruElement.querySelector("#powerGain1").style.color = "#1284BB"
    pruElement.querySelector("#powerGain2").innerHTML = info.gain[2] + "db"
    pruElement.querySelector("#powerGain2").style.color = "#1284BB"
    pruElement.querySelector("#powerGain3").innerHTML = info.gain[3] + "db"
    pruElement.querySelector("#powerGain3").style.color = "#1284BB"
    
}