function B2GB(num) {
    let res = num / (1024 * 1024 * 1024)
    return (res).toFixed(1);
}

function formatTimestamp(timestamp) {  
    let date = new Date(timestamp);  
    let year = date.getFullYear();  
    let month = String(date.getMonth() + 1).padStart(2, '0'); // 月份是从0开始的  
    let day = String(date.getDate()).padStart(2, '0');  
    let hours = String(date.getHours()).padStart(2, '0');  
    let minutes = String(date.getMinutes()).padStart(2, '0');  
    let seconds = String(date.getSeconds()).padStart(2, '0');  
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;  
}  

function showPassword() {
    var eye = document.getElementById("icon-eye");
    var password = document.getElementById("inputPassword");
    var btn = document.getElementById("showPwdButton");

    btn.onclick = function () {
        if (password.type === "text") {
            replaceClass(eye, "icon-zhengyan","icon-biyan")
            password.type = "password";
        } else {
            replaceClass(eye, "icon-biyan","icon-zhengyan")
            password.type = "text";
        }
    }
}

function checkUser(userName,password) {
return new Promise((resolve, reject) => {
    HttpPost("/checkPassword", JSON.stringify({
    "name": userName,
    "password": password,
    }), (error, respData) => {
    if (error) {
        console.log("check user pwd err:", error);
        reject(error);
    } else {
        if (respData.code == 2000) {
        console.log("校验成功:", respData);
        resolve({
            result: true,
            msg: respData.msg
        });
        } else {
            console.log("校验失败", respData);
            resolve({
                result: false,
                msg: respData.msg
            });
        }
    }
}); 
})};




function updateSection(info) {
    for (const [k, v] of Object.entries(info)) {
        if (v === ""|| v=== undefined) {
            document.getElementById(k).innerText="- -"
        } else {
            // console.log("set ",k," ",v)
            document.getElementById(k).innerText =v
        }
    }
}

// 格式化信息数组
function formatShowArryInfo(info) {
    let res = "";
    if (info.length != 1) { 
        for (let i = 0; i < info.length; i++) {
            if ( i === (info.length-1)){
                res +=  info[i];
            }else{
                res +=  info[i]+", ";
            }
        }   
    } else {
        res = info[0]
    }
    if (res === ""){
        return "- -"
    }else{
        return res
    }
};

// 替换类
function replaceClass(element, oldClass, newClass) {  
    element.classList.remove(oldClass);  
    element.classList.add(newClass);  
};

// 去除文件后缀
function removeFileExtension(filename) {  
    // 使用split()方法以"."为分隔符分割字符串，得到数组  
    const parts = filename.split('.');
    // 使用slice(0, -1)去除数组的最后一项，即文件扩展名  
    // 然后使用join('.')将数组重新组合成字符串  
    return parts.slice(0, -1).join('.');  
};

// 断点续传版本包
function uploadFile(file, start, end, url, callback) {
    // console.log("start:", start, ", end:", end, "start-end:",end-start);
    const blob = file.slice(start, end+1);  
    const formData = new FormData();  
    formData.append('file', blob);
    fetch(url, {  
        method: 'POST',  
        body: blob,  
        headers: {  
            // 'Content-Type': 'multipart/form-data',  
            // 假设这里以简单方式传递分片信息，实际可能需要更复杂的方式  
            'Range': `${start}-${end}`,
            'FileName':file.name
        } 
    })
    .then(response => response.json())  
    .then(data => {  
        console.log(data);  
        // 这里可以处理下一个分片，或者处理上传完成 
        callback(null);
    })  
    .catch(error => {  
        console.error('Error:', error);  
        callback(error);
    });  
};


// 显示弹窗
function showWindow(tipWindow, child, desc, isHead) {
    if (child != undefined) {
        showResMsg(tipWindow, child, desc, isHead);
    }
    
    parent.blurBG();
    tipWindow.style.display = "block";
    setTimeout(function() {  
        tipWindow.style.display = "none";
        if (tipWindow.querySelector(child) != null){
            tipWindow.querySelector(child).style.display = "none";
        }
        location.reload();
        parent.showBG();
    }, 2000);
};

// 进度条移动
function moveBar(barLen,desc,bar,barText) {
    bar.style.width = barLen*300+"px";
    barText.textContent = desc + Math.floor(barLen* 100)  + '%';
    console.log("当前进度:",barText.textContent);
};


// 显示弹窗结果信息
function showResMsg(parentTip, child, desc, isHead) {
    parentTip.querySelector(child).style.display = "block";
    if (desc != undefined) {
        if (isHead) {
            parentTip.querySelector(child).textContent = desc + parentTip.querySelector(child).textContent ;
        } else {
            parentTip.querySelector(child).textContent = parentTip.querySelector(child).textContent + desc;        
        }
    }
};

function download(filetype,doc) {
    // 构建URL  
    const url = `/api/v1/download/${encodeURIComponent(filetype)}`;  
    // 创建一个临时的a标签用于下载  
    const a = doc.createElement('a');  
    a.href = url;  
    doc.body.appendChild(a);  
    a.click(); // 模拟点击以触发下载  
    doc.body.removeChild(a); // 清理a标签  
};

// 转换为秒级时间戳
function turn2SecTimeStamp(timeStr) { 
    if (timeStr) {
        var dataTime = new Date(timeStr);
        if (!isNaN(dataTime.getTime())) {
            return dataTime.getTime()/1000;
        } else {
            console.error('invalid time str:', timeStr);
            return ""
        }
    } else {
        console.log("timeStr is empty");
        return ""
    }
};


// 创建表格
function createCharts(e,n,t){
    let mycharts = echarts.init(e);

    let option = {
        animation: true, 
        smooth:'0.9',
        grid: {
            top: 10,
            bottom: 10,
            left: 10,
            right: 10, 
            containLabel: true  // 确保坐标轴标签不会超出图表容器
        },
        xAxis: {
            type: 'time',
        },
        yAxis: {
            type: 'value',
            scale: true
        },
        series: [
            {
                name: n,
                type: t,
                data: [], 
                lineStyle: {
                    color: '#FF8933',
                    type: 'dotted'
                },
                areaStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                        { offset: 0, color: 'rgba(255,113,10,0.2)' },
                        { offset: 1, color: 'rgba(255,252,205,0.1)' }
                    ])
                },
                itemStyle:{
                    color:'#FF8933 ',
                },
                symbolSize:2,
            
            }
        ],
        tooltip: {
            trigger: 'axis',
            axisPointer:{
                type:'cross',
            },
            formatter: function (params) {
                let date = new Date(params[0].data[0]);
                let year = date.getFullYear();
                let month = ('0' + (date.getMonth() + 1)).slice(-2);
                let day = ('0' + date.getDate()).slice(-2);
                let hour = ('0' + date.getHours()).slice(-2);
                let minute = ('0' + date.getMinutes()).slice(-2);
                let second = ('0' + date.getSeconds()).slice(-2);
                let timeStr = year + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second;
                return timeStr + '<br/>' + params[0].seriesName + ': ' + params[0].data[1];
            }
        }
    };
    // 设置初始配置
    mycharts.setOption(option);

    mycharts.showLoading();
    return mycharts;
}

// 更新表格数据
function updateEchartTableData(charts,d) {
    charts.setOption({
        animation: true, 
        series: [{
            data: d
        }]
    });
}

// 获取xpath val
async function getXpathVal(xpath){
    return new Promise((resolve,reject) =>{{
            let xpathMap = {};
            xpathMap[".xml"] = {};
            xpathMap[".xml"][xpath] = "";
            HttpPost('/api/v1/config', JSON.stringify({
            module: "software",
            operation: 'get',
            extension: xpathMap
        }), (error, resp) => {
            if (error) {
                reject(error);
            } else {
                if (resp.code === 200) {
                    let val = JSON.parse(resp.data);
                    if (val){
                        console.log("get xpath val:",val);
                        resolve(val[xpath]);
                    };
                };
            };
        });
    }});
};

function evaluateExpression(expr) {
  // 提取操作数和运算符
    const match = expr.match(/^([\s\S]+?)\s*(==|===|!=|!==|>|<|>=|<=)\s*(\d+)$/);
    if (!match) throw new Error("Invalid expression");
    // console.log("match:",match);
    const left = match[1];
    const operation = match[2];
    const right = match[3];
    // const numLeft = Number(left);
    // const numRight = Number(right);

    switch (operation) {
        case "==": return left == right;
        case "===": return left === right;
        case "!=": return left != right;
        case "!==": return left !== right;
        case ">": return left > right;
        case "<": return left < right;
        case ">=": return left >= right;
        case "<=": return left <= right;
        default: throw new Error("Unsupported operator");
    }
};

function extractXPathAndOperator(condition) {
     // 确保输入是字符串
    if (typeof condition !== 'string') {
        console.error("Input is not a string");
        return null;
    }
    condition = condition.trim();
    // 打印输入字符串以检查格式
    // console.log("Input string:", JSON.stringify(condition));

    const match = condition.match(/^([\s\S]+?)\s*(==|===|!=|!==|>|<|>=|<=)\s*(\d+)$/);
    // console.log("match1",match,"input:",condition);
    return match ? { xpath: match[1], operator: match[2],value: match[3] } : null;
}