const InsText = document.getElementById("installText").innerText;
const UpgText = document.getElementById("upgradeText").innerText;
const UninsText = document.getElementById("uninstallText").innerText;
const AlreadyText = document.getElementById("alreadyText").innerText;
const FallbackText = document.getElementById("fallbackText").innerText;
const DelPkgText = document.getElementById("delPkgText").innerText;
const UploadPkgText = document.getElementById("uploadPkgText").innerText;
const YESText = document.getElementById("yesText").innerText;
const NOText = document.getElementById("noText").innerText;
const FileSizeExceedLmitText = document.getElementById("fileSizeExceedLmitText").innerText;
const UploadTipText = document.getElementById("uploadTipText").innerText;

const PkgList = document.getElementById("pkgList");
const VerList = document.getElementById("curVerList");
const GnbVerName = document.getElementById("gnb-verName");
const GnbVerInfo =  document.getElementById("gnb-versionInfo");
const DelPkgBT = document.getElementById("delVerPkg");
const UploadPkgBT = document.getElementById("uploadVer");
const InstallBT = document.getElementById("installVer");
const UpgradeBT = document.getElementById("upgradeVer");
const UninstallBT = document.getElementById("uninstallVer");
const FallbackeBT = document.getElementById("fallbackVer");

const CancelBT = window.parent.document.getElementById("cancel");

const GnbDescMsg = window.parent.document.getElementById("gnbDesMsg");


const InstallTip = window.parent.document.getElementById("installTipWindow");
const UpgTip = window.parent.document.getElementById("upgradeTipWindow");
const UninstallTip = window.parent.document.getElementById("uninstallTipWindow");
const FallbackTip = window.parent.document.getElementById("fallbackTipWindow");
const IsDBTip = window.parent.document.getElementById("isDBTipWindow");
const ErrorChooseTip = window.parent.document.getElementById("errorChooseTipWindow");
const FailedTip = window.parent.document.getElementById("failedTipWindow");
const SuccessTip = window.parent.document.getElementById("successTipWindow");
const WaitTip = window.parent.document.getElementById("waitTipWindow");
const DelPkgTip = window.parent.document.getElementById("delPkgTipWindow");


const WaitPkgName = window.parent.document.getElementById("waitPkgName");
const DelPkgName = window.parent.document.getElementById("delPkgName");
const TipBT = window.parent.document.getElementById("tipBT");
const IsDBBT = window.parent.document.getElementById("isDB");
const NoDBBT = window.parent.document.getElementById("noDB");
const Bar = window.parent.document.getElementById("bar");
const PgBarText = window.parent.document.getElementById("pgBarText");


const ErrorCode = -1;//网络原因操作错误
const GnbCMDRespWaitTimer = 1000; //gnb操作应答检验周期
const GnbCMDRespWaitNum = 180; //gnb操作应答检验次数

const UploadCMDRespWaitTimer = 1000; //上传文件操作软应答检验周期
const UploadCMDRespWaitNum = 300; //上传文件应答检验次数
const DelPkgCMDRespWaitTimer = 1000; //删除文件操作软应答检验周期
const DelPkgCMDRespWaitNum = 30; //删除文件应答检验次数
const InstallSuccCode = 4056; //安装软件响应正确code
const UpgSuccCode = 4058;//升级软件响应正确code
const UninsSuccCode = 4062;//卸载软件响应正确code
const FallBKSuccCode = 4060;//回退软件响应正确code
const DelPkgSuccCode = 4050;//删除软件响应正确code
const RemovePkgSuccCode = 4054;//上传软件响应正确code

let IsDB; //是否集成配置(true：集成配置；false：不继承配置)；
let PkgID = ""; //包fileId；
let PkgName = "";//包名称
let Module = ""; //模块名称；
let Resp;//安装升级等操作应答结果；

// 空白处点击取消所有单选框
document.addEventListener("click", function (event) {
    // 检查点击事件的目标是否不是单选框  
    if (!event.target.closest('#pkgList') && !event.target.closest('#curVerList')&& !event.target.closest('button') && event.target.id !== "datermine" && event.target.id !== "cancel"&& event.target.id !== "installVer" && event.target.id !== "upgradeVer") {  
    console.log("id:",event.target.id);
    console.log("clear pkgId pkgName Module");
    UninstallBT.style.color = "rgba(0, 0, 0, 0.25)";
    UninstallBT.disabled = true;
    FallbackeBT.style.color = "rgba(0, 0, 0, 0.25)";
    FallbackeBT.disabled = true;
    DelPkgBT.style.color = "rgba(0, 0, 0, 0.25)";
    DelPkgBT.disabled = true;
    PkgID="";
    PkgName="";
    Module="";
    // 获取所有具有相同name属性的单选框  
    var verRadios = document.querySelectorAll('input[name="radio-verList"]');  
    // 遍历这些单选框并将它们的checked属性设置为false  
    verRadios.forEach(function(verRadio) {  
        verRadio.checked = false;  
    });
    var pkgRadios = document.querySelectorAll('input[name="radio-pkglist"]');  
    // 遍历这些单选框并将它们的checked属性设置为false  
    pkgRadios.forEach(function(pkgRadio) {  
        pkgRadio.checked = false;  
    }); 
    } 
})

document.addEventListener('DOMContentLoaded', function () {
    // 监听可用版本fileid
    PkgList.addEventListener('click', function () {
        document.querySelectorAll('input[name="radio-pkglist"]').forEach((radio) => {
            radio.addEventListener('change', function () { 
                if (this.checked) {
                    PkgID = this.id;
                    PkgName = this.parentNode.querySelector("#pkgName").textContent;
                    console.log("id:", this.id + ", 版本包:", PkgName);
                    DelPkgBT.style.color = "#0B65A0";
                    DelPkgBT.disabled = false;
                }
            });
        });
    });

    // 监听模块id
    VerList.addEventListener('click', function () {
        document.querySelectorAll('input[name="radio-verList"]').forEach((radio) => {
        radio.addEventListener('change', function () { 
                if (this.checked) {
                    // console.log(this.id + "模块");
                    Module = this.id;
                    UninstallBT.disabled = false;
                    FallbackeBT.disabled = false;
                    UninstallBT.style.color = "#0B65A0";
                    FallbackeBT.style.color = "#0B65A0";
                }
            });
        });
    });

    // 监听删除版本
    DelPkgBT.addEventListener('click',function() { 
        if (PkgID === "") {
            showWindow(ErrorChooseTip);
        } else {
            DelPkgName.textContent = PkgName;
            DelPkgTip.style.display = "block";
            parent.blurBG();
            DelPkgTip.querySelector("#datermine").addEventListener('click',function(){
                DelPkgTip.style.display = "none";
                delPkg();
                return
            });
            DelPkgTip.querySelector("#cancel").addEventListener('click', function () {
                clearAllTip();
                parent.showBG();
            });
        }
    });

    // 监听上传版本
    UploadPkgBT.addEventListener('change', function (event) {
        console.log("pkg file:", event.target.files.length)
        if (event.target.files && event.target.files[0]) {
            const file = event.target.files[0];
            WaitTip.style.display = "block";
            parent.blurBG();
            WaitPkgName.innerText = file.name;
            const chunkSize = 1024 * 1024;
            console.log("upload version pkg size:", file.size);
            if (file.size >= 1024 * 1024 * 300) {
                WaitTip.style.display = "none";
                showWindow(FailedTip, "#uploadFal", FileSizeExceedLmitText, false);
                return
            }
            uploadChunk(file, 0, chunkSize, "api/v1/upload-version-pkg");
        }
    });

    // 监听安装版本
    InstallBT.addEventListener('click', function () {
        // 显示弹窗
        if (checkPkgIdAndModuleInvalid()) {
            showWindow(ErrorChooseTip);
            return
        } else {
            InstallTip.style.display = "block";
            parent.blurBG();
            showModuleDescMsg(InstallTip);
            InstallTip.querySelector("#datermine").addEventListener('click', function () {
                console.log("start install gnb")
                clearModuleDescMsg();
                InstallTip.style.display = "none";
                install();
                return
            });
            InstallTip.querySelector("#cancel").addEventListener('click', function () {
                clearAllTip();
                parent.showBG();
            });
        }
    });

    // 监听升级版本
    UpgradeBT.addEventListener('click', function () {
        if (checkPkgIdAndModuleInvalid()) {
            showWindow(ErrorChooseTip);
            return 
        } else {
            UpgTip.style.display = "block";
            parent.blurBG();
            showModuleDescMsg(UpgTip);
            UpgTip.querySelector("#datermine").addEventListener('click', function () {
                clearModuleDescMsg();
                UpgTip.style.display = "none";
                IsDBTip.style.display = "block";
                console.log("开始升级");
                upgrade();
                return
            });
            UpgTip.querySelector("#cancel").addEventListener('click', function () {
                clearAllTip();
                parent.showBG();
            });
        }
    });

    // 监听卸载版本
    UninstallBT.addEventListener('click', function () {
        if (Module === "") {
            showWindow(ErrorChooseTip);
        } else {
            UninstallTip.style.display = "block";
            parent.blurBG();
            showModuleDescMsg(UninstallTip);
            const gnbDesMsg = UninstallTip.querySelector("#gnbDesMsg");
            UninstallTip.querySelector("#datermine").addEventListener("click", function () {
                console.log("uninstall start");
                gnbDesMsg.style.display = "none";
                const yesBT = UninstallTip.querySelector("#datermine");
                const noBT = UninstallTip.querySelector("#cancel");
                UninstallTip.querySelector("#agentDesMsg").style.display = "block";
                yesBT.textContent = YESText;
                noBT.textContent = NOText;
                yesBT.addEventListener("click", function () {
                    console.log("卸载agent");
                    UninstallTip.style.display = "none";
                    uninstall(true);
                    // 显示等待页面，提示用户等待后刷新页面
                    window.parent.location.href = "/wait"
                });
                noBT.addEventListener("click", function () {
                    console.log("不卸载agent");
                    UninstallTip.style.display = "none";
                    uninstall(false);
                    // 显示等待页面，提示用户等待后刷新页面
                    window.parent.location.href = "/wait"
                });
            });
            UninstallTip.querySelector("#cancel").addEventListener('click', function () {
                clearAllTip();
                parent.showBG();
            });
        }
    });

    // 监听回退版本
    FallbackeBT.addEventListener('click', function () {
        if (Module === "") {
            showWindow(ErrorChooseTip);
            return
        } else { 
            FallbackTip.style.display = "block";
            parent.blurBG();
            showModuleDescMsg(FallbackTip);
            FallbackTip.querySelector("#datermine").addEventListener("click", function () {
                clearModuleDescMsg();
                FallbackTip.style.display = "none";
                console.log("fallback start");
                fallback();
                return
            });
            FallbackTip.querySelector("#cancel").addEventListener('click', function () {
                clearAllTip();
                parent.showBG();
            });
        }
    });
    getVersionInfo();
    showDetalVerInfo();
});

// 回调上传chunk
function uploadChunk(file, start, chunkSize, url) {  
    if (start >= file.size) {
        console.log("All chunks uploaded successfully");
        removeVerPkg();
        return  
    }
    const end = Math.min(file.size - 1, start + chunkSize - 1);  
    uploadFile(file, start, end, url, (error) => {  
        if (error) {  
            console.log("upload failed, err:", error);
            WaitTip.style.display = "none";
            showWindow(FailedTip, "#uploadFal")
            return   
        } else {  
            console.log("upload success");
            moveBar(((end + 1)/file.size),AlreadyText+UploadPkgText,Bar,PgBarText)
            uploadChunk(file, end + 1, chunkSize, url); // 递归调用  
        }  
    });
};




// 转储版本包
function removeVerPkg() { 
    HttpGet("api/v1/remove-version-pkg", (error, resp) => {
        if (error) {
            console.log("remove ver pkg failed, err:", error);
            WaitTip.style.display = "none";
            showWindow(FailedTip,"#uploadFal");
            return 
        } else {
            if (resp.code == RemovePkgSuccCode) {
                console.log("remove ver pkg success");
                WaitTip.style.display = "none";
                showWindow(SuccessTip, "#uploadSucc");
    
                return
            } else {
                console.log("remove ver pkg failed, err:", resp.msg);
                WaitTip.style.display = "none";
                showWindow(FailedTip,"#uploadFal");
                return
            }
        };
    });
};

// 显示详细版本信息
function showDetalVerInfo(){
        HttpGet("/api/v1/version-detal-info", (error, resp) => {
        if (error) {
            console.log("get version detal info failed,err:", error);
        } else {
            let info = JSON.parse(resp.data);
            updateSection({
                "cu-versionId":info.cu.verId,
                "du-versionId":info.du.verId,
                "phy-versionId":info.phy.verId,
                "baseservice-versionId":info.baseservice.verId,
                "agent-versionId":info["gnb_agent"].verId,
                "logwriter-versionId":info.logwriter.verId,

                "cu-innerVersion":info.cu.innerVer,
                "du-innerVersion":info.du.innerVer,
                "phy-innerVersion":info.phy.innerVer,
                "baseservice-innerVersion":info.baseservice.innerVer,
                "agent-innerVersion":info["gnb_agent"].innerVer,
                "logwriter-innerVersion":info.logwriter.innerVer,

                "cu-buildTime":info.cu.buildTime,
                "du-buildTime":info.du.buildTime,
                "phy-buildTime":info.phy.buildTime,
                "baseservice-buildTime":info.baseservice.buildTime,
                "agent-buildTime":info["gnb_agent"].buildTime,
                "logwriter-buildTime":info.logwriter.buildTime,
                
                "cu-description":info.cu.description,
                "du-description":info.du.description,
                "phy-description":info.phy.description,
                "baseservice-description":info.baseservice.description,
                "agent-description":info["gnb_agent"].description,
                "logwriter-description":info.logwriter.description,

                "cu-gitSHA":info.cu.gitSHA,
                "du-gitSHA":info.du.gitSHA,
                "phy-gitSHA":info.phy.gitSHA,
                "baseservice-gitSHA":info.baseservice.gitSHA,
                "agent-gitSHA":info["gnb_agent"].gitSHA,
                "logwriter-gitSHA":info.logwriter.gitSHA,
            });
        };
    });
};


// 获取版本包信息
function getVersionInfo() {
    HttpGet("/api/v1/version-info", (error, resp) => {
        if (error) {
            console.log("get version info failed,err:", error);
        } else {
            let info = JSON.parse(resp.data);
            // 显示包信息
            showPkgInfo(info)

            // 显示版本信息
            showVerInfo(info)
        };
    });
};

// 生成版本包信息列表
function showPkgInfo(data) { 
    console.log("recv pkg data:", data);
    if (data.gnb.pkgInfo) {
        data.gnb.pkgInfo.forEach(pkg => {
            addPkgList(pkg)
        });
    }
};

// 生成版本信息列表
function showVerInfo(data) { 
    console.log("recv ver data:", data);
    if (data.gnb) {
        addVerList(data.gnb,"gnb")
    }
};

// 添加版本包条数
function addPkgList(pkgInfo) {
    let newLi = document.createElement("li");
    let input = document.createElement("input");
    input.className = "radio-input";
    input.name = "radio-pkglist";
    input.type = "radio";
    input.style.display = "none";
    input.id = pkgInfo.fileId;

    let label = document.createElement("label");
    label.className = "pkgList-radio-label";
    label.htmlFor = input.id;
    label.name = "radio-pkglist";

    let pkgName = document.createElement("span")
    pkgName.className = "pkgName";
    pkgName.textContent = pkgInfo.name;
    pkgName.id = "pkgName"

    let uploadTime = document.createElement("span")
    uploadTime.className = "uploadTime";
    uploadTime.textContent = pkgInfo["upload-time"];

    let line = document.createElement("div")
    line.className = "listLine";

    let pkgType = document.createElement("span");
    pkgType.className = "pkgType";
    pkgType.textContent = "all";

    newLi.appendChild(input);
    newLi.appendChild(label);
    newLi.appendChild(pkgName);
    newLi.appendChild(uploadTime);
    newLi.appendChild(line);
    newLi.appendChild(pkgType);
    PkgList.appendChild(newLi);
}

// 添加版本信息条数
function addVerList(info, module) {
    if (module == "gnb") {
        if (info.showVersion != "") {
            // gnb 版本信息
            GnbVerName.textContent = info.showVersion;
            GnbVerName.className = "verName";
            let insTime = document.createElement("span");
            insTime.className = "insTime";
            insTime.textContent = info["install-time"];
            GnbVerInfo.appendChild(insTime);
        }
    } else { 
        let newLi = document.createElement("li");
        let input = document.createElement("input");
        input.className = "radio-input";
        input.name = "radio-verList";
        input.type = "radio";
        input.style.display = "none";
        input.id = module;
        // console.log("recv module:", input.id);

        let label = document.createElement("label");
        label.className = "curVerList-radio-label";
        label.htmlFor = input.id;
        label.name = "radio-verList";

        let line = document.createElement("div")
        line.className = "verLine";

        let gnbModule = document.createElement("span")
        gnbModule.className = "gnbModule";
        gnbModule.textContent = module;

        let divInfo = document.createElement("div");
        let verName = document.createElement("span");
        verName.className = "verName";
        verName.textContent = info.version;

        let insTime = document.createElement("span");
        insTime.className = "insTime";
        insTime.textContent = info["install-time"];
        
        divInfo.appendChild(verName);
        divInfo.appendChild(insTime);
        newLi.appendChild(input);
        newLi.appendChild(label);
        newLi.appendChild(line);
        newLi.appendChild(gnbModule);
        newLi.appendChild(divInfo);
        VerList.appendChild(newLi);
    }
};

// 校验包id模块合法性
function checkPkgIdAndModuleInvalid() {
    return (PkgID === "") || (Module === "");
};

// 等待响应结果
function waitForResp(timer, num, code,desc,operation) {
    WaitTip.style.display = "block";
    WaitTip.getElementsByClassName("tipUploadMsg").style.display = "none";
    parent.blurBG();
    if (PkgName != undefined) {
        WaitPkgName.innerText = removeFileExtension(PkgName);    
    }
    let count = 0;
    let intervalId = setInterval(function () {
        count++
        console.log("等待操作结果,累计时间:", count * timer, "ms");
        moveBar(count / num, desc,Bar,PgBarText);
        if (count >= num) {
            setTimeout(function() {  
                WaitTip.style.display = "none";
                WaitTip.getElementsByClassName("tipUploadMsg").style.display = "block";
            }, 1000);
            console.log("请求响应超时");
            if (Module != undefined) {
                showResMsg(FailedTip,turnOp2ChildName(operation,false,Module,true));    
                parent.showBG();
            } else {
                showResMsg(FailedTip,turnOp2ChildName(operation,false));
                parent.showBG();
            }
            
            showWindow(FailedTip);
            clearInterval(intervalId);
            return 
        } else {
            if (Resp != null) {
                console.log("获取到结果:", Resp);
                setTimeout(function() {  
                    WaitTip.style.display = "none";
                    WaitTip.getElementsByClassName("tipUploadMsg").style.display = "block";
                }, 1000);
                if (Resp.code === code) {
                    moveBar(1, desc, Bar, PgBarText);
                    if (Module != undefined) {
                        showResMsg(SuccessTip,turnOp2ChildName(operation,true),Module,true);
                        parent.showBG();
                    } else {
                        showResMsg(SuccessTip,turnOp2ChildName(operation,true));
                        parent.showBG();
                    }
                    console.log(operation,"操作成功");
                    showWindow(SuccessTip);
                } else {
                    console.log(operation,"操作失败", Resp.msg);
                    if (Module != undefined) {
                        showResMsg(FailedTip,turnOp2ChildName(operation,false),Module,true);    
                        parent.showBG();
                    } else {
                        showResMsg(FailedTip,turnOp2ChildName(operation,false));
                        parent.showBG();
                    }
                    showWindow(FailedTip);
                    parent.showBG();
                }
                clearInterval(intervalId);
                return
            }
        }
    }, timer)
};

// 安装基站软件
function install() {
    console.log("开始安装",Module);
    HttpPost("/api/v1/gnb-commond",JSON.stringify({
            "module": "software",
            "operation": "install",
            "extension": JSON.stringify({
                "id":PkgID,
                "moduleName":Module
            }),
            }), (error, resp) => {
        if (error) {
            console.log("isntall failed ,err:", error);
            Resp = {
                "code":ErrorCode
            }
            return
        } else {
            Resp = resp
            console.log("recv install msg", Resp.msg);
        }
    });
    if (Module == "gnb") {
        // 显示等待页面，提示用户等待后刷新页面
        window.parent.location.href = "/wait"
    };
};

// 升级基站软件
function upgrade() { 
    HttpPost("/api/v1/gnb-commond", JSON.stringify({
    "id": PkgID,
    "module": "software",
    "operation": "upgrade",
    "extension": JSON.stringify({
        "id": PkgID,
        "moduleName":Module,
        "isDB":true,
    })
}), (error, resp) => {
        if (error) {
            console.log("upg failed ,err:", error);
            Resp = {
                "code":ErrorCode
            }
            return
        } else {
            Resp = resp
        }
    });
    // 显示等待页面，提示用户等待后刷新页面
    window.parent.location.href = "/wait"
};

// 回退版本
function fallback() {
    HttpPost("/api/v1/gnb-commond", JSON.stringify({
            "module": "software",
            "operation": "fallback",
            "extension":Module,
        }), (error, resp) => {
            if (error) {
                console.log("fallback failed ,err:", error);
                Resp = {
                    "code":ErrorCode
                }
                return
            } else {
                Resp = resp
            }
    });
    // 显示等待页面，提示用户等待后刷新页面
    window.parent.location.href = "/wait"
};

// 卸载版本
function uninstall(isAgent) {
    HttpPost("/api/v1/gnb-commond", JSON.stringify({
            "module": "software",
            "operation": "uninstall",
            "extension": JSON.stringify({
                "isAgent": isAgent,
                "moduleName":Module,
            })
        }), (error, resp) => {
                if (error) {
                    console.log("卸载失败:",error);
                    // 显示等待页面，提示用户等待后刷新页面
                    window.parent.location.href = "/wait"
                } else {
                    if (resp.code === UninsSuccCode){
                    console.log("卸载成功");
                    showWindow(SuccessTip,"#uninsSucc");
                    // 复位agent
                    HttpPost('/api/v1/gnb-commond',JSON.stringify({"module":"gnb_agent","operation":"restart"}) ,(error, resp) => { 
                        if (error) {
                            console.log("restart gnb_agent error:",error)
                        } else {
                            if (resp.code === 1034){
                                parent.showTipMessage({message:resp.msg,type:"info"});
                            }else{
                                parent.showTipMessage({message:resp.msg,type:"error"});
                            }
                        }
                    });
                    setTimeout(()=>{
                        window.parent.location.href = "/wait"
                    },2000);
                    
                    }else{
                        console.log("卸载失败,原因:",resp.msg);
                        showWindow(FailedTip, "#uninsFal");
                    }
                }
            });
};

// 删除版本
function delPkg() { 
    console.log("开始删除版本，包id: ", PkgID, ", 包名:", PkgName);
    HttpPost("api/v1/del-version-pkg", JSON.stringify({"id": PkgID}), (error, resp) => {
        if (error) {
            console.log("del pkg",PkgName," failed ,err:", error);
            showWindow(FailedTip, "#delFal",error,false);
            return
        } else {
            if (resp.code === DelPkgSuccCode) {
                showWindow(SuccessTip, "#delSucc");
            } else {
                console.log("del pkg",PkgName," failed ,msg:", resp.msg);
                showWindow(FailedTip, "#delFal",resp.msg,false);
            }
        }
    });
};

// 显示模块描述
function showModuleDescMsg(parentElement) {
    let module;
    if (Module.includes("gnb")) {
        module = "#gnbDesMsg";
    };
    parentElement.querySelector(module).style.display = "block";
};

// 消除模块描述信息
function clearModuleDescMsg() {
    GnbDescMsg.style.display = "none";
};

// 清除提示框
function clearAllTip() {
    InstallTip.style.display = "none";
    UpgTip.style.display = "none";
    UninstallTip.style.display = "none";
    FallbackTip.style.display = "none";
    IsDBTip.style.display = "none";
    ErrorChooseTip.style.display = "none";
    FailedTip.style.display = "none";
    SuccessTip.style.display = "none";
    FailedTip.style.display = "none";
    DelPkgTip.style.display = "none";
    console.log("清除提示框");
};

function turnOp2ChildName(operation, isSucc) {
    let res;
    if (operation === "install") {
        res = "#ins";
    } else if (operation === "uninstall") {
        res = "#unins";
    } else if (operation === "upgrade") {
        res = "#upg";
    } else if (operation === "fallback") {
        res = "#fallbk";
    } else if (operation === "upload") {
        res = "#upload";
    } else if (operation === "delPkg") {
        res = "#del";
    } else {
        console.log("unsupport op:", operation)
        return undefined
    }
    if (isSucc) {
        res += "Succ";
    } else {
        res += "Fal";
    }
    return res
}