/*
ui文件引用方式：<script defer src="js/yzui.js"></script>

yz-bt使用说明：
调用方法：<yz-bt></yz-bt>
type默认是主色调[primary,info,danger,disabled]
icon属性在文本左侧
启用方法：enableButton()
禁用方法：disableButton()
传递参数：params=""
默认自动传递this，需要在形参中写对象{ params, self }即可通过self访问this
所有方法写在被调用页面
举例：

<div id='diva'>
  <yz-bt type="primary" click="abc" params="[1,2,3,4]">主按钮</yz-bt>
</div>

function abc({ params, self }) {
  console.log('参数:', params);
  console.log('调用的父元素:', self.parentNode);
}



*/
const YZUI_SWITCH_OPEN = window.parent.document.getElementById("openText").innerText; //开
const YZUI_SWITCH_CLOSE = window.parent.document.getElementById("closeText").innerText; //关


//定义全局变量
const fontFamily = '';
const fontSize = '12PX'

/* Button组件 */
class YzBt extends HTMLElement {
    constructor() {
        super();

        // 创建 Shadow DOM与外界保持隔离
        this.shadow = this.attachShadow({mode: 'open'});

        // 创建样式元素
        const style = document.createElement('style');
        style.textContent = `

      button {
          font-family: ${fontFamily},
          font-size:  ${fontSize};
          position: relative;
          display: inline-flex;
          align-items: center;
          justify-content: center;
          vertical-align: middle;
      }
      .icon-left, .icon-right {
          // position: relative;
          color: var(--icon-color, #FFFFFF);
          font-size: ${fontSize};
          display: inline-flex;
          margin-left: 4px;
          margin-right: 8px;
      }
      .icon-right {
          margin-left: 8px;
          margin-right: 0px;
      }
      .primary {
          min-width: 68px;
          height: 28px;
          border-radius: 4px;
          background: var(--background-color, #1284BB);
          border: 1px solid var(--border-color, #1284BB);
          color: var(--text-color, #FFFFFF);
          text-align: center;
          line-height: 18px;
          padding: 2px 16px;
          padding-left: var(--paddingLeft,16px);
          padding-right: var(--paddingRight,16px);
      }
       // .primary:hover {
    //   background: #095A8F;
    //   border-color: #095A8F;
    //   color:#FFFFFF;
    // }
    // .primary:active {
    //   background: #085080;
    // }
    .pop1{
        min-width: 68px;
        height: 28px;
        border: 1px solid #1284BB;
        border-radius: 4px;
        background: #FFFFFF;
        color: #1284BB;
        text-align: center;
        line-height: 18px;
        padding: 2px 16px;
    }
    // .pop1:hover {
    //     color: #FFFFFF;
    //     background: #0B65A0;
    // }
    // .pop1:active {
    //     color: #FFFFFF;
    //     background: #0B65A0;
    // }
    .info {
        min-width: 68px;
        height: 28px;
        background: #FFFFFF;
        border: 1px solid rgba(217,217,217,1);
        border-radius: 4px;
        color: rgba(0,0,0,0.45);
        text-align: center;
        line-height: 18px;
        padding: 2px 16px;
    }
    .info:hover {
        background: #FFFFFF;
        border: 1px solid rgba(11,101,160,1);
    }
    .info:active {
      background: rgba(11,101,160,0.10);
      border: 1px solid rgba(11,101,160,1);
      border-radius: 4px;
    }
    .danger {
        min-width: 68px;
        height: 28px;
        background: #FF5533;
        border: 0;
        border-radius: 4px;
        color: #FFFFFF;
        text-align: center;
        line-height: 18px;
        padding: 2px 16px;
    }
    .danger:hover {
        background: #E54C2D;
        border: 0;
    }
    .danger:active {
        background: #CC4428;
        border: 0;
        border-radius: 4px;
    }
    .disabled {
        min-width: 68px;
        height: 28px;
        border-radius: 4px;
        background: #F7F7F7;
        border: 1px solid rgba(217,217,217,1);
        color: rgba(0,0,0,0.25);
        text-align: center;
        line-height: 18px;
        padding: 2px 16px;
    }
    .disabled:hover,
    .disabled:active {
        background: #F5F5F5; /* 灰色背景 */
        border: 1px solid #D9D9D9; /* 灰色边框 */
        color: rgba(0,0,0,0.25); /* 灰色文字 */
        opacity: 0.8; /* 调整透明度，让整体效果柔和 */
        cursor: url('/static/image/notAllowed.png'), not-allowed;
    }

      `;
        this.shadow.appendChild(style);

        // 引入外部 CSS 文件
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.type = 'text/css';
        link.href = '/static/css/iconfont.css'; // 替换为你的外部 CSS 文件路径
        this.shadow.appendChild(link);

        // 创建按钮元素
        this.button = document.createElement('button');
        this.shadow.appendChild(this.button);

        // 创建 slot 元素，用于插入按钮文本内容
        this.textSlot = document.createElement('slot');
        this.button.appendChild(this.textSlot);

        // 创建图标元素
        this.iconElem = document.createElement('i');
        this.iconElem.classList.add('iconfont');
        this.button.appendChild(this.iconElem);

        // 初始化样式和事件绑定
        this.updateType();
        this.updateIcon();
        this.updateEventBinding();
    }

    // 更新按钮的样式类
    updateType() {
        let type = this.getAttribute('type') || 'primary';
        this.button.className = type;

        // 如果是disabled类型，添加禁用属性
        if (type === 'disabled') {
            this.button.setAttribute('disabled', true);
        } else {
            this.button.removeAttribute('disabled');
        }
    }

    // 更新图标的位置和样式
    updateIcon() {
        const icon = this.getAttribute('icon');
        const position = this.getAttribute('position') || 'left';

        if (icon) {
            this.iconElem.className = `iconfont ${icon} icon-${position}`;
        } else {
            this.iconElem.className = ''; // 如果没有 icon 属性，则清空 class
        }

        // this.button.appendChild(this.iconElem);
        if (position === 'left') {
            this.iconElem.style.order = '-1';  // 将图标的顺序调到文本之前
        } else {
            this.iconElem.style.order = '1';   // 将图标的顺序调到文本之后
        }

    }

    // 更新按钮的事件绑定
    updateEventBinding() {
        const clickHandlerName = this.getAttribute('click');

        // 先移除旧的点击事件绑定，避免重复绑定
        const newButton = this.button.cloneNode(true);
        this.button.replaceWith(newButton);
        this.button = newButton;

        if (clickHandlerName) {
            this.button.addEventListener('click', () => {
                if (window[clickHandlerName] && typeof window[clickHandlerName] === 'function') {
                    const params = this.getAttribute('params');
                    window[clickHandlerName].call(this, {params, self: this});
                }
            });
        }
    }

    // 动态属性更新时重新绑定样式和事件
    static get observedAttributes() {
        return ['type', 'click', 'icon', 'posinset'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'type') {
            this.updateType();
        } else if (name === 'click') {
            this.updateEventBinding();
        } else if (name === 'icon' || name === 'posinset') {
            this.updateIcon();
        }
    }

    enableButton() {
        this.button.classList.remove('disabled');
        this.button.removeAttribute('disabled');
    }

    disableButton() {
        this.button.classList.add('disabled');
        this.button.setAttribute('disabled', true);
    }
}

// 定义自定义元素
customElements.define('yz-bt', YzBt);


/*左侧树组件*/

class YzTree extends HTMLElement {

    constructor() {
        super();
        // 创建 Shadow DOM与外界保持隔离
        this.shadow = this.attachShadow({mode: 'open'});

        let data = this.getAttribute('data');
        data = JSON.parse(data);
        let expandedState = {};

        this.createNavMenu = (data, parentElement, parentObject = null) => {
            Object.keys(data).forEach(key => {
                const item = data[key];
                const listItem = document.createElement('li');
                listItem.textContent = key;
                listItem.classList.add(`nav-item${item.level}`);
                listItem.setAttribute('data-level', item.level);
                listItem.setAttribute('data-name', key);
                if (item.active) {
                    listItem.setAttribute('active', item.active);
                }
                if (item.showNu) {
                    listItem.setAttribute('showNu', item.showNu);
                }
                if (item.SelfContent) {
                    listItem.setAttribute('SelfContent', item.SelfContent);
                }
                if (item.ip) {
                    listItem.setAttribute('ip', item.ip);
                }
                if (item.type) {
                    listItem.setAttribute('type', item.type);
                }
                if (item.icon) {
                    let iconElement = document.createElement('i');
                    iconElement.className = `iconfont ${item.icon}`;
                    listItem.prepend(iconElement);
                }

                item.ParentObject = parentObject; // 将父节点对象保存到当前项

                // 如果是第一级目录项，创建一个 div 包裹
                let container;
                if (item.level === 1) {
                    container = document.createElement('div');
                    parentElement.appendChild(container);
                    container.appendChild(listItem);
                } else {
                    parentElement.appendChild(listItem);
                }

                if (item.ChildObject && item.ChildObject.length > 0) {
                    const childList = document.createElement('ul');
                    childList.classList.add(`nav-level-${item.level + 1}`);

                    // 如果是第一级目录项的子目录，继续使用容器
                    if (item.level === 1) {
                        container.appendChild(childList);
                    } else {
                        parentElement.appendChild(childList);
                    }

                    this.createNavMenu(item.ChildObject.reduce((acc, cur) => {
                        acc[cur.name] = cur;
                        return acc;
                    }, {}), childList, item);

                    // 初始化子项的 display 属性
                    const childItems = childList.querySelectorAll('li');
                    childItems.forEach(childItem => {
                        childItem.style.display = 'none';
                    });
                }

                listItem.addEventListener('mouseover', () => {
                    // 判断是否是 nav-item3
                    if (listItem.classList.contains('nav-item3')) {
                        // 比较元素的 scrollWidth 和 clientWidth
                        if (listItem.scrollWidth > listItem.clientWidth) {

                            let content = listItem.getAttribute('data-name');

                            const tooltip = document.getElementById('tooltip');


                            // 设置 tooltip 内容
                            tooltip.textContent = content;
                            tooltip.style.display = 'block';

                            document.addEventListener('mousemove', (e) => {
                                tooltip.style.left = e.pageX + 10 + 'px';  // 跟随鼠标移动，偏移10px
                                tooltip.style.top = e.pageY + 10 + 'px';
                            });

                            listItem.addEventListener('mouseout', () => {
                                const tooltip = document.getElementById('tooltip');
                                tooltip.style.display = 'none';  // 隐藏 tooltip
                            });

                        }
                    }
                });

                listItem.addEventListener('click', (event) => {
                    event.stopPropagation(); // 阻止冒泡
                    const currentLevel = parseInt(listItem.getAttribute('data-level')); // 等级解构

                    // 切换下一级项目的显示
                    const nextElement = listItem.nextElementSibling; // 获取下一级元素
                    if (nextElement) {
                        const nextLevelItems = nextElement.querySelectorAll(`.nav-item${currentLevel + 1}`);
                        nextLevelItems.forEach(item => {
                            item.style.display = item.style.display === 'none' ? 'block' : 'none';
                        });

                        // 确保当前层级的直接子菜单项被正确显示，而更深层次的子菜单项被隐藏
                        for (let i = currentLevel + 2; i <= 4; i++) {
                            const higherLevelItems = nextElement.querySelectorAll(`.nav-item${i}`);
                            higherLevelItems.forEach(item => {
                                item.style.display = 'none';
                            });
                        }
                    }

                    // 清除所有项目的 active 状态
                    clearAllActiveStates(parentElement);

                    // 更新扩展状态
                    const itemName = listItem.getAttribute('data-name');
                    expandedState[itemName] = expandedState[itemName] ? !expandedState[itemName] : true;

                    // 设置被点击的项目为活动状态
                    setActiveState(itemName, data, true);
                    listItem.classList.add('active');

                    // 获取点击元素的位置
                    const rect = listItem.getBoundingClientRect();

                    // 处理不同层次的点击事件
                    switch (currentLevel) {
                        case 1:
                            this.handleLevel1Click(listItem, rect);
                            break;
                        case 2:
                            this.handleLevel2Click(listItem, rect);
                            break;
                        case 3:
                            this.handleLevel3Click(listItem, rect);
                            break;
                        case 4:
                            this.handleLevel4Click(listItem, rect);
                            break;
                        default:
                            break;
                    }

                    // 折叠所有兄弟项及其子项
                    const siblingItems = parentElement.querySelectorAll(`.nav-item${currentLevel}`);
                    siblingItems.forEach(sibling => {
                        if (sibling !== listItem) {
                            const siblingName = sibling.getAttribute('data-name');
                            expandedState[siblingName] = false;
                            const siblingNextElement = sibling.nextElementSibling;
                            if (siblingNextElement) {
                                hideAllChildItems(siblingNextElement);
                            }
                            setActiveState(siblingName, data, false);
                            sibling.classList.remove('active');
                        }
                    });
                });
            });
        };

        this.handleLevel1Click = (element, rect) => {


            if (element.classList.contains('menuShrink')) {
                show();
                document.getElementsByTagName("toggle-button")[0].toggleIcon();
            }
            if (element.getAttribute('active')) {

                this.dispatchEvent(new CustomEvent('treeclick1', {
                    detail: {
                        value: element.getAttribute('data-name'),
                        level: element.getAttribute('data-level'),
                    }
                }));

                homePageDisplay(1, element.getAttribute('active'));
            } else {
                this.dispatchEvent(new CustomEvent('treeclick1', {
                    detail: {
                        value: element.getAttribute('data-name'),
                        level: element.getAttribute('data-level'),
                        noPageAction: true
                    }
                }));
            }

        };

        this.handleLevel2Click = (element, rect) => {

            this.dispatchEvent(new CustomEvent('treeclick2', {
                detail: {
                    value: element.getAttribute('data-name'),
                    level: element.getAttribute('data-level'),
                    type: element.getAttribute('type'),

                }
            }));
            return3Display(element);

            // 获取下一层节点， 如果是<ul>标签 并且 class是 nav-level-3，那么就控制 nav-level-3的显示位置
            const nextElement = element.nextSibling;
            if (nextElement) {
                if (nextElement.nodeName.toLowerCase() === 'ul' && nextElement.className === 'nav-level-3') {
                    // 控制 nav-level-3 的显示位置,显示在点击对应位置
                    nextElement.style.left = '115%';
                    nextElement.style.top = '15%';
                }
            }

            const debouncedFunc = debounce(() => {
                homePageDisplay(element.getAttribute('showNu'), element.getAttribute('SelfContent'))
            }, 200);

            // 在需要防抖的地方调用它
            debouncedFunc();


        };

        this.handleLevel3Click = (element, rect) => {

            if (element.getAttribute('clicked')) {
                returnUpperLevel(element);
                element.removeAttribute('clicked');
                return3Display(element);
                return;
            }

            this.dispatchEvent(new CustomEvent('treeclick3', {
                detail: {
                    value: element.getAttribute('data-name'),
                    level: element.getAttribute('data-level'),
                    ip: element.getAttribute('ip'),
                }
            }));

            // textContent不考虑css样式，innerTEST会考虑

            const nextElement = element.nextSibling;

            // 获取下一层节点， 如果是<ul>标签 并且 class是 nav-level-4，那么关闭三级目录，显示四级目录，并且创建div显示所点击的三级目录内容，控制返回
            if (nextElement.nodeName.toLowerCase() === 'ul' && nextElement.className === 'nav-level-4') {
                // 首先关闭展示出来的三级目录
                let allThreeLevel = document.querySelectorAll('.nav-item3');
                allThreeLevel.forEach(item => {
                    item.style.display = 'none';

                    if (item == element) {
                        item.style.display = 'block';
                        // item.style.top = `-${element.scrollHeight * 1.3}px`;
                        item.style.bottom = '50px';
                        item.style.left = '0px';
                        item.setAttribute('clicked', 'true');
                    }
                });

                // 显示四级目录
                if (nextElement && nextElement.firstElementChild) {
                    nextElement.firstElementChild.classList.add('active', 'nav-item4active');
                }

                homePageDisplay(nextElement.firstChild.getAttribute('showNu'), nextElement.firstChild.getAttribute('SelfContent'));

                this.dispatchEvent(new CustomEvent('treeclick4', {
                    detail: {
                        value: nextElement.firstChild.getAttribute('data-name'),
                        level: nextElement.firstChild.getAttribute('data-level'),
                    }
                }));

                nextElement.style.left = '0';
                nextElement.style.top = '0';
            }

        };

        this.handleLevel4Click = (element, rect) => {

            this.dispatchEvent(new CustomEvent('treeclick4', {
                detail: {
                    value: element.getAttribute('data-name'),
                    level: element.getAttribute('data-level'),
                }
            }));
            // console.log(`Level 4 item clicked: ${element.textContent}, Element position: (${rect.left}, ${rect.top})`);
            homePageDisplay(element.getAttribute('showNu'), element.getAttribute('SelfContent'));

        }


        function return3Display(dom) {


            // 获取传递的 dom 元素的父节点
            let parent = dom.parentNode;

            // 获取父节点下所有同级的 .nav-item3 元素
            let allThreeLevel = parent.querySelectorAll('.nav-item3');

            // 遍历这些元素，清除样式并设置 display 为 none
            allThreeLevel.forEach(item => {

                if (item.getAttribute('clicked')) {
                    item.removeAttribute('clicked');
                }

                if (item.style.bottom) {
                    item.style.removeProperty('bottom');
                    item.style.removeProperty('left');
                    item.style.display = "none";
                }
            });

            // 再次遍历这些元素，将 display 设置为 block
            allThreeLevel.forEach(item => {
                item.style.display = "block";
            });
        }

        function returnUpperLevel(dom) {

            // 获取传递的 dom 元素的父节点
            let parent = dom.parentNode;

            // 获取父节点下所有同级的 .nav-item3 元素
            let allThreeLevel = parent.querySelectorAll('.nav-item3');

            // 遍历这些元素，清除样式并设置 display 为 none
            allThreeLevel.forEach(item => {
                if (item == dom) {
                    if (dom.style.top) {
                        item.style.removeProperty('top');
                        item.style.removeProperty('left');
                        item.style.display = "none";
                    }
                }
            });

            // 再次遍历这些元素，将 display 设置为 block
            allThreeLevel.forEach(item => {
                item.style.display = "block";
            });
        }

        function hideAllChildItems(element) {
            const childItems = element.querySelectorAll('li');
            childItems.forEach(item => {
                item.style.display = 'none';
                const nextElement = item.nextElementSibling;
                if (nextElement) {
                    hideAllChildItems(nextElement);
                }
            });
        };


        const setActiveState = (itemName, data, isActive) => {
            Object.keys(data).forEach(key => {
                const item = data[key];
                if (key === itemName) {
                    item.status = isActive ? 'active' : 'inactive';
                }
                if (item.ChildObject && item.ChildObject.length > 0) {
                    setActiveState(itemName, item.ChildObject.reduce((acc, cur) => {
                        acc[cur.name] = cur;
                        return acc;
                    }, {}), isActive);
                }
            });
        };

        const clearAllActiveStates = (parentElement) => {
            const allItems = parentElement.querySelectorAll('li');
            allItems.forEach(item => {
                item.classList.remove('active');
                setActiveState(item.getAttribute('data-name'), data, false);
            });
        };

        this.getClassHasActive = (updataValue = '') => {

            let navMenu = this.getAttribute('build');
            navMenu = document.getElementById(navMenu);
            if (updataValue != '') {
                this.createNavMenu(updataValue, navMenu);
            } else {
                this.createNavMenu(data, navMenu);
            }


            // 为了一二层目录显示效果
            var children = document.getElementsByClassName('nav-item1');

            // 创建一个回调函数来处理mutations作用是监听dom的变化
            var callback = (mutationsList, observer) => {
                for (let mutation of mutationsList) {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                        let targetElement = mutation.target;
                        if (targetElement.classList.contains('active')) {
                            // 如果子元素有 'active' 类，给父元素添加 'nav-container' 类
                            targetElement.parentNode.classList.add('nav-container');

                            // 展开情况下如果有子元素那么增加底边距
                            // console.log('展开情况下', targetElement.parentNode);
                            if (targetElement.parentNode.querySelector('.nav-item2') && document.querySelector('[class^="left"]').getAttribute('data-state') == 'expanded') {
                                targetElement.parentNode.style.paddingBottom = '1vh';
                            }

                        } else {
                            // 如果子元素没有 'active' 类，给父元素移除 'nav-container' 类
                            targetElement.parentNode.classList.remove('nav-container');
                            targetElement.parentNode.style.paddingBottom = '';
                        }
                    }
                }
            };

            // 创建一个observer实例与回调函数关联
            var observer = new MutationObserver(callback);

            // 遍历所有的子元素
            for (var i = 0; i < children.length; i++) {
                observer.observe(children[i], {attributes: true});
            }

            let navItems = document.querySelectorAll('.nav-item1, .nav-item2, .nav-item3, .nav-item4');

            navItems.forEach((item) => {
                // 创建一个观察器实例并传入回调函数
                let observer = new MutationObserver(function (mutations) {
                    mutations.forEach(function (mutation) {
                        if (mutation.attributeName === "class") {
                            // 断开观察器
                            observer.disconnect();

                            if (item.classList.contains('active')) {

                                if (item.classList.contains('nav-item2')) {
                                    item.classList.add('nav-item2active');
                                } else if (item.classList.contains('nav-item3')) {
                                    item.classList.add('nav-item3active');
                                } else if (item.classList.contains('nav-item4')) {
                                    item.classList.add('nav-item4active');
                                }
                            } else {

                                if (item.classList.contains('nav-item2active')) {
                                    item.classList.remove('nav-item2active');
                                } else if (item.classList.contains('nav-item3active')) {
                                    item.classList.remove('nav-item3active');
                                } else if (item.classList.contains('nav-item4active')) {
                                    item.classList.remove('nav-item4active');
                                }
                            }

                            // 重新连接观察器
                            observer.observe(item, config);
                        }
                    });
                });

                // 配置观察器选项：仅观察类名的变化
                let config = {attributes: true, attributeFilter: ['class']};

                // 开始观察指定的元素
                observer.observe(item, config);
            });
        };

        this.getClassHasActive();
    };

    updateMenu(data1) {
        let navMenu = this.getAttribute('build');
        navMenu = document.getElementById(navMenu);

        if (data1) {
            this.data1 = data1;
            // 清空所有 div 元素，而不是整个 innerHTML
            const divs = navMenu.querySelectorAll('div');
            divs.forEach(div => div.remove());
            // 更新菜单内容
            this.getClassHasActive(data1);
        }

    }

}

// 定义切换元素
customElements.define('yz-tree', YzTree);


class ToggleButton extends HTMLElement {
    constructor() {
        super();

        // 创建 Shadow DOM与外界保持隔离
        this.shadow = this.attachShadow({mode: 'open'});

        // 创建样式元素
        const style = document.createElement('style');
        style.textContent = `
          .toggle-button {
              display: flex;
              flex-direction: column; /* 垂直排列 */
              justify-content: space-around; /* 设置主轴对齐方式 */
              align-items: center; /* 副轴居中（水平） */
              cursor: pointer;
              height: 22px;
              width: 22px;
          }
          .line {
              height: 2px;
              background-color: #595959;
              width: 100%;
          }
          .middle {
              width: 100%;
              display: flex;
          }
          .middleLeft {
              width: 40%;
              box-sizing: border-box;
              display: flex;
              justify-content: center;
              align-items: center;
          }
          .middleRight {
              box-sizing: border-box;
              width: 50%;
              transform: translateX(1.5px);
              display: flex;
              flex-direction: column; /* 垂直排列 */
              justify-content: space-between; /* 设置主轴对齐 */
              align-items: flex-end; /* 副轴靠右（水平） */
          }
          .middleRight .line:first-child {
              transform: translateY(0px);
          }
          .icon {
              border-top: 4px solid transparent;
              border-bottom: 4px solid transparent;
              border-right: 5px solid #595959;
              transition: transform 0.5s ease;
              transform-origin: center; /* 设置旋转中心为元素中心 */
              transform: translateX(-1px); /* 向左移动5px */
          }
          .icon.open {
              transform: translateX(-1px) rotate(180deg); /* 保持移动并旋转 */
          }
      `;
        this.shadow.appendChild(style);

        // 创建按钮元素
        this.button = document.createElement('div');
        this.button.classList.add('toggle-button');
        this.button.addEventListener('click', this.toggleIcon.bind(this));
        this.shadow.appendChild(this.button);

        // 创建内部元素
        this.createLine();
        this.createMiddle();
        this.createLine();

        // 获取事件处理函数名
        const clickHandlerName = this.getAttribute('click');
        if (clickHandlerName) {
            // 监听点击事件
            this.button.addEventListener('click', () => {
                // 调用页面定义的函数，并传递参数和this指针

                if (window[clickHandlerName] && typeof window[clickHandlerName] === 'function') {
                    const params = this.getAttribute('params');
                    window[clickHandlerName].call(this, {params, self: this}); // 传递参数和this指针
                }
            });
        }

    }

    createLine() {
        const line = document.createElement('div');
        line.classList.add('line');
        this.button.appendChild(line);
    }

    createMiddle() {
        const middle = document.createElement('div');
        middle.classList.add('middle');

        const middleLeft = document.createElement('div');
        middleLeft.classList.add('middleLeft');
        const icon = document.createElement('div');
        icon.classList.add('icon');
        middleLeft.appendChild(icon);

        const middleRight = document.createElement('div');
        middleRight.classList.add('middleRight');
        const line1 = document.createElement('div');
        line1.classList.add('line');
        const line2 = document.createElement('div');
        line2.classList.add('line');
        middleRight.appendChild(line1);
        middleRight.appendChild(line2);

        middle.appendChild(middleLeft);
        middle.appendChild(middleRight);
        this.button.appendChild(middle);
    }

    toggleIcon() {
        const icon = this.shadow.querySelector('.icon');
        icon.classList.toggle('open');
    }


}

// 定义切换元素
customElements.define('toggle-button', ToggleButton);

//顶部菜单
class TopMenu extends HTMLElement {
    constructor() {
        super();

        // 创建 Shadow DOM与外界保持隔离
        this.shadow = this.attachShadow({mode: 'open'});

        let menuData = JSON.parse(this.getAttribute('data'));

        function clearShield() {

            document.querySelectorAll('.firstMenu').forEach(function (m) {
                m.classList.remove('menuClicked');
            });

            let overlay = document.getElementById('overlay');
            if (overlay) {

                document.body.removeChild(overlay);
            }
        }


        document.addEventListener('DOMContentLoaded', function () {
            let systemDir2 = document.querySelector('.systemDir2');

            Object.keys(menuData).forEach(function (firstMenuName) {
                // 创建一级菜单
                let firstMenuDiv = document.createElement('div');
                firstMenuDiv.classList.add('firstMenu');
                firstMenuDiv.innerText = firstMenuName;

                // 创建二级菜单容器
                let secondaryMenuDiv = document.createElement('div');
                secondaryMenuDiv.classList.add('secondaryMenu');

                Object.keys(menuData[firstMenuName]).forEach(function (secondMenuName) {
                    // 创建二级菜单项
                    let secondMenuItem = document.createElement('div');
                    secondMenuItem.innerText = secondMenuName;

                    // 添加点击事件
                    secondMenuItem.addEventListener("click", function (event) {
                        event.stopPropagation(); // 阻止冒泡
                        let str = menuData[firstMenuName][secondMenuName];
                        let url = str.replace(/\(.*?\)/, '');
                        secondMenuItem.parentNode.parentNode.classList.remove('menuClicked');
                        buildTopLevelMenuItem(url);
                        clearShield();
                    });

                    secondaryMenuDiv.appendChild(secondMenuItem);
                });

                firstMenuDiv.appendChild(secondaryMenuDiv);
                systemDir2.appendChild(firstMenuDiv);

                firstMenuDiv.addEventListener('mouseover', function (event) {

                    event.stopPropagation(); // 阻止冒泡
                    // 移除所有菜单项的 menuClicked 类
                    document.querySelectorAll('.firstMenu').forEach(function (m) {
                        m.classList.remove('menuClicked');
                    });
                    // 为被点击的菜单项添加 menuClicked 类
                    firstMenuDiv.classList.add('menuClicked');
                    // 添加覆盖层用于捕获点击事件
                    // let overlay = document.createElement('div');
                    // overlay.id = 'overlay';
                    // overlay.style.position = 'absolute';
                    // overlay.style.top = 0;
                    // overlay.style.left = 0;
                    // overlay.style.width = '100%';
                    // overlay.style.height = '100%';
                    // overlay.style.zIndex = 1111;
                    // document.body.appendChild(overlay);

                    // setTimeout(() => {
                    //   document.addEventListener('click', clearShield);
                    // }, 100);
                });

                firstMenuDiv.addEventListener('mouseleave', function (event) {
                    // 在这里添加你希望在鼠标移出时执行的逻辑
                    firstMenuDiv.classList.remove('menuClicked');

                    // 也可以移除覆盖层
                    let overlay = document.getElementById('overlay');
                    if (overlay) {
                        document.body.removeChild(overlay);
                    }
                });

            });
        });
    }
}

// 定义自定义元素
customElements.define('top-menu', TopMenu);


//input time类型引用的css需要在外部调用。
class YzInput extends HTMLElement {
    static formAssociated = true; // 启用表单关联

    constructor() {
        super();

        this.shadow = this.attachShadow({mode: 'open'});
        const style = document.createElement('style');
        style.textContent = `
    .input-container {
      position: relative;
      display: inline-flex;
      align-items: center;
      width: var(--input-width, 220px);
      

    }
    .icon-left, .icon-right {
      position: absolute;
      color: var(--icon-color, #999999);
    }
    .icon-left {
      left: 8px;
    }
    .icon-right {
      right: 8px;
    }
    input[type="text"], input[type="password"], input[type="time"]{
      width: 100%;
      height: 32px;
      background: var(--background, #FFFFFF);
      border-radius: var(--border-radius, 4px);
      border-width: var(--border-width, 1px);
      border-style: var(--border-style, solid);
      border-color: var(--border-color, #D9D9D9);
      padding: var(--padding, 1px 8px);
      padding-right : 22px;
      box-sizing: border-box;
      outline: none;
      color: var(--color, rgba(0,0,0,0.65));
      cursor: pointer;
    }
    input[type="text"]:hover, input[type="password"]:hover, input[type="time"]:hover {
      border: 1px solid #0B65A0;
    }
    input[type="text"]:focus, input[type="password"]:focus, input[type="time"]:focus {
      border: 1px solid #0B65A0;
    }
    input[type="text"]::placeholder, input[type="password"]::placeholder, input[type="time"]::placeholder {
      color: rgba(0,0,0,0.25);
    }

    input[type="text"][disabled], input[type="password"][disabled], input[type="time"][disabled] {
        background: var(--background, #F5F5F5); /* 灰色背景 */
        border: 1px solid var(--border-color, #D9D9D9); /* 灰色边框 */
        color: var(--color, rgba(0,0,0,0.65));
        opacity: 0.9; /* 调整透明度，让整体效果柔和 */
        cursor: url('/static/image/notAllowed.png'), not-allowed;
    }

    /* 隐藏默认的文件输入按钮 */
    input[type="file"] {
      opacity: 0;  /*完全透明 */
      position: absolute;
      top: 0;
      right: 0;
      width: 100%;
      height: 100%;
      cursor: pointer;
      z-index: 2;
    }

    /* 自定义文件输入按钮样式 */
    .file-label {
      display: inline-block;
      min-width: 68px;
      font-size: 14px;
      height: 28px;
      border-radius: 4px;
      background:#1284BB;
      border: 1px solid var(--border-color, #1284BB);
      color: var(--text-color, #FFFFFF);
      text-align: center;
      line-height: 21px;
      padding: 2px 16px;
      cursor: pointer;
      box-sizing: border-box;
      z-index: 1;
    }

    .file-label:hover {
      background: var(--background-hover-color, #094A7B);
      border-color: var(--border-hover-color, #094A7B);
    }
    `;
        this.shadow.appendChild(style);

        // 引入外部 CSS 文件
        const linkIconfont = document.createElement('link');
        linkIconfont.rel = 'stylesheet';
        linkIconfont.type = 'text/css';
        linkIconfont.href = '/static/css/iconfont.css';
        this.shadow.appendChild(linkIconfont);

        const container = document.createElement('div');
        container.classList.add('input-container');
        this.shadow.appendChild(container);

        let type = this.getAttribute('type') || 'text';
        let icon = this.getAttribute('icon');
        let position = this.getAttribute('position');


        if (type === 'password') {
            icon = 'icon-zhengyan';
            position = 'right';
        }

        if (icon && type !== 'file') {
            this.iconElem = document.createElement('i');
            this.iconElem.classList.add('iconfont', icon);

            if (type === 'password') {
                this.iconElem.addEventListener('click', this.showPad.bind(this));
            }

            const inputStyle = {};
            if (position === 'right') {
                this.iconElem.classList.add('icon-right');
                inputStyle.paddingRight = '28px';
                inputStyle.paddingLeft = '8px';
            } else if (position === 'left') {
                this.iconElem.classList.add('icon-left');
                inputStyle.paddingLeft = '28px';
                inputStyle.paddingRight = '8px';
            }
            container.appendChild(this.iconElem);

        }

        if (type === 'file') {
            this.iconElem = document.createElement('i');
            this.iconElem.classList.add('iconfont', icon);

            const label = document.createElement('label');
            label.classList.add('file-label');
            label.textContent = this.getAttribute('placeholder') || 'Choose file';
            container.appendChild(label);

            this.input = document.createElement('input');
            this.input.type = 'file';
            container.appendChild(this.input);

            this.input.style.opacity = 0;
            this.input.style.position = 'absolute';
            this.input.style.width = '100%';
            this.input.style.height = '100%';
            this.input.style.cursor = 'pointer';
            this.input.style.zIndex = 2;

            this.input.addEventListener('change', () => {
                if (this.input.files.length > 0) {
                    const formData = new FormData();
                    formData.append('file', this.input.files[0]); // 将文件添加到表单数据

                    const uploadUrl = this.getAttribute('upload-url');

                    fetch(uploadUrl, {
                        method: 'POST',
                        body: formData,
                    })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('网络响应失败');
                            }
                            // 解析响应数据，如果是JSON格式
                            return response.text().then(text => {
                                try {
                                    return JSON.parse(text);
                                } catch (err) {
                                    console.warn('响应内容不是JSON格式:', text);
                                    return text; // 返回纯文本
                                }
                            });
                        })
                        .then(data => {

                            let res = JSON.parse(data.rep)
                            if (res.code != 0) {

                                this.dispatchEvent(new CustomEvent('uploadResult', {
                                    detail: {
                                        type: 'error',
                                        value: res.msg
                                    }
                                }));
                            } else {

                                this.dispatchEvent(new CustomEvent('uploadResult', {
                                    detail: {
                                        type: 'success',
                                        value: 'ok'
                                    }
                                }));

                            }
                        })
                        .catch(error => {
                            console.error('文件上传失败:', error);
                            // 在这里处理上传失败后的逻辑
                        });
                }
            });

            label.style.position = 'relative';
            label.style.zIndex = 1;
        } else {
            this.input = document.createElement('input');
            this.input.type = type;
            container.appendChild(this.input);

            const inputStyle = {};
            Object.assign(this.input.style, inputStyle);

            if (this.getAttribute('value') != null) {
                this.input.value = this.getAttribute('value');
            }

            if (this.getAttribute('name') != null) {
                this.input.name = this.getAttribute('name');
            }

            this.style.setProperty('--input-width', this.getAttribute('width') || '220px');


            const placeholder = this.getAttribute('placeholder');
            if (placeholder) {
                this.input.placeholder = placeholder;
            }

            if (this.getAttribute('click')) {
                const clickHandlerName = this.getAttribute('click');
                this.input.addEventListener('click', () => {
                    if (window[clickHandlerName] && typeof window[clickHandlerName] === 'function') {
                        const params = this.getAttribute('params');
                        window[clickHandlerName].call(this, {params, self: this});
                    }
                });
            }


            if (this.hasAttribute('disabled')) {
                this.input.setAttribute('disabled', true);
            }

            if (type === 'time') {
                this.initFlatpickr();
            }

            this.selectedDate = null;

            this.internals = this.attachInternals();
            this.internals.setFormValue(this.input.value || '');

            this.input.addEventListener('input', () => {
                this.setAttribute('value', this.input.value);
                this.internals.setFormValue(this.input.value);
            });
        }

        const inputStyle = this.input.style;
        const updateColor = () => {
            const computedColor = getComputedStyle(this).getPropertyValue('--changeBC');
            const borderColor = getComputedStyle(this).getPropertyValue('--changeBDC');
            inputStyle.background = computedColor;
            inputStyle.borderColor = borderColor;
        };

        // 初始设置
        updateColor();

        // 观察样式变化
        const observer = new MutationObserver(updateColor);
        observer.observe(this, {attributes: true, attributeFilter: ['style']});


    }

    static get observedAttributes() {
        return ['value'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'value' && this.input && this.input.type !== 'file') {
            this.input.value = newValue;
            this.internals.setFormValue(newValue || '');
        }
    }

    get value() {
        return this.input.value;
    }

    set value(newValue) {
        this.setAttribute('value', newValue);
        this.internals.setFormValue(newValue);
    }

    get form() {
        return this.internals.form;
    }

    get name() {
        return this.getAttribute('name');
    }

    get type() {
        return this.localName;
    }

    getValue() {
        return this.input.value;
    }

    setValue(val) {
        this.input.value = val;
        this.internals.setFormValue(val);
    }

    enableInput() {
        if (this.input) {
            this.input.removeAttribute('disabled');
        }
    }

    disableInput() {
        if (this.input) {
            this.input.setAttribute('disabled', true);
        }
    }

    showPad() {
        if (this.input.type === 'password') {
            this.input.type = 'text';
            this.iconElem.classList.remove('icon-zhengyan');
            this.iconElem.classList.add('icon-biyan');
        } else {
            this.input.type = 'password';
            this.iconElem.classList.remove('icon-biyan');
            this.iconElem.classList.add('icon-zhengyan');
        }
    }

    initFlatpickr() {
        const scriptFlatpickr = document.createElement('script');
        scriptFlatpickr.src = '/static/js/flatpickr.js';
        const scriptFlatpickrcss = document.createElement('link');
        scriptFlatpickrcss.rel = 'stylesheet';
        scriptFlatpickrcss.type = 'text/css';
        scriptFlatpickrcss.href = '/static/css/flatpickr.css';

        scriptFlatpickr.onload = () => {
            const scriptFlatpickrZH = document.createElement('script');
            scriptFlatpickrZH.src = '/static/js/flatpickrZH.js';
            scriptFlatpickrZH.onload = () => {
                flatpickr(this.input, {
                    enableTime: true,
                    dateFormat: 'Y-m-d H:i:S',
                    time_24hr: true,
                    locale: 'zh',
                    enableSeconds: true,
                    onChange: (selectedDates) => {
                        this.selectedDate = selectedDates[0];
                    }
                });
            };
            this.shadow.appendChild(scriptFlatpickrZH);
        };
        this.shadow.appendChild(scriptFlatpickr);
        this.shadow.appendChild(scriptFlatpickrcss);
    }

    getSelectedTime() {
        return this.selectedDate ? this.selectedDate.getTime() : null;
    }
}

customElements.define('yz-input', YzInput);


class YzSelect extends HTMLElement {
    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});

        const style = document.createElement('style');
        style.textContent = `
        /* 修改滚动条默认样式 */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: none;
        }

        ::-webkit-scrollbar-thumb {
            background: #DBE8F1;
            border-radius: 6px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #DBE8F1;
        }
      .select-container {
        position: relative;
        width: var(--select-width,220px);
        height: var(--select-height,32px);
        box-sizing: border-box;
        display: inline-flex;
        background: var(--background,#FFFFFF);
        border-radius: 4px;
        border: 1px solid var(--border-color,#D9D9D9);
        vertical-align: top;
        font-size:14px;
        font-weight: normal;
      }
      .select-container.disabled {
        background: #F5F5F5; /* 灰色背景 */
        border: 1px solid #D9D9D9; /* 灰色边框 */
        color: rgba(0,0,0,0.25); /* 灰色文字 */
        opacity: 0.8; /* 调整透明度，让整体效果柔和 */
        cursor: url('/static/image/notAllowed.png'), not-allowed;
      }
      .select-container.disabled:hover{
        border: 1px solid #D9D9D9; /* 灰色边框 */
      }
      .select-container:hover {
        border:1px solid #0B65A0;
      }
      .select-container.open {
        border: 1px solid #0B65A0;
      }
    .custom-select-trigger {
        width: 70%;
        color: var(--color,rgba(0,0,0,0.25)); /* 默认提示信息颜色 */
        border-radius: 4px;
        padding: 4px 8px; /* 增加一点上下 padding */
        display: block; /* block 显示 */
        overflow: hidden;
        text-overflow: ellipsis; /* 使用省略号 */
        white-space: nowrap; /* 单行显示 */
        box-sizing: border-box; /* 确保 padding 在宽度内 */
        height: auto; /* 高度由内容决定 */
        line-height: normal; /* 保持正常行高 */
        display: flex; /* 使用 Flexbox */
        align-items: center; /* 垂直居中 */
    }

      .custom-select-trigger:hover {
          // overflow: visible;
          // white-space: normal;
      }
      .custom-select-trigger.selected {
        color: var(--color,rgba(0,0,0,0.65));
      }
      .custom-options {
        position: absolute;
        top: 110%; /* 控制下拉菜单的位置 */
        box-sizing: border-box;
        left: 0;
        width: 100%;
        background: var(--optionsbackground,#FFFFFF);
        border: 1px solid var(--border-color,#D9D9D9);
        border-radius: 4px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        display: none;
        flex-direction: column;
        z-index: 1000;
        max-height: 300px; 
        transition: none;

      }
      .custom-option {
        line-height:28px;
        padding: 1px 8px;
        color: var(--color,rgba(0,0,0,0.65));
        cursor: pointer;
        white-space: nowrap; /* 单行显示 */
      }
      .custom-option:hover {
        overflow: visible; /* 隐藏超出部分 */
        white-space: normal; /* 单行显示 */
      }
      .custom-option-null {
        line-height:28px;
        padding: 1px 8px;
        color: var(--color,rgba(0,0,0,0.65));
        cursor: pointer;
        text-align: center;
        font-size: 0.8em;
      }
      .custom-option:hover {
        background:var(--hover,#f0f0f0);
      }
      .select-container.open .custom-options {
        display: flex;
        max-height: 300px;
        overflow: auto;
        overflow-x: hidden; 
        text-overflow: ellipsis; /* 使用省略号 */
      }
      .iconPosition {
        color: #999999;
        position: absolute;
        top: 50%;
        right: 10px;
        transform: translateY(-50%);
        pointer-events: none;
      }
        .custom-options.reverse-position {
        box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
        bottom: calc(100% + 5px);
        top: auto !important;
    }

    `;
        this.shadow.appendChild(style);

        // 引入外部 CSS 文件
        const linkIconfont = document.createElement('link');
        linkIconfont.rel = 'stylesheet';
        linkIconfont.type = 'text/css';
        linkIconfont.href = '/static/css/iconfont.css';
        this.shadow.appendChild(linkIconfont);

        this.selectContainer = document.createElement('div');
        this.selectContainer.classList.add('select-container');
        this.selectContainer.style.setProperty('--select-width', this.getAttribute('width') || '220px');

        if (this.hasAttribute('disabled')) {
            this.selectContainer.classList.add('disabled');
        }

        this.selectTrigger = document.createElement('div');
        this.selectTrigger.classList.add('custom-select-trigger');
        this.selectTrigger.textContent = this.getAttribute('placeholder') || "请选择";

        this.selectContainer.appendChild(this.selectTrigger);

        this.optionsContainer = document.createElement('div');
        this.optionsContainer.classList.add('custom-options');

        this.selectContainer.appendChild(this.optionsContainer);

        // 创建小箭头
        this.iconElem = document.createElement('i');
        this.iconElem.classList.add('iconfont', 'icon-xiala', 'iconPosition');
        this.selectContainer.appendChild(this.iconElem);

        this.shadow.appendChild(this.selectContainer);


        if (!this.hasAttribute('disabled')) {
            this.selectContainer.addEventListener('click', this.toggleOptions.bind(this));
            this.optionsContainer.addEventListener('click', this.selectOption.bind(this));
        }

        // 绑定事件处理器
        this.boundCloseOptions = this.closeOptions.bind(this);

        const inputStyle = this.selectContainer.style;
        const updateColor = () => {

            const computedColor = getComputedStyle(this).getPropertyValue('--changeBC');
            const borderColor = getComputedStyle(this).getPropertyValue('--changeBDC');
            inputStyle.background = computedColor;
            inputStyle.borderColor = borderColor;

        };

        // 初始设置
        updateColor();

        // 观察样式变化
        const observer = new MutationObserver(updateColor);
        observer.observe(this, {attributes: true, attributeFilter: ['style']});

        // 鼠标移出下拉框时延迟关闭
        this.selectContainer.addEventListener('mouseleave', () => {
            setTimeout(() => {
                // 如果鼠标已经不在当前下拉框内，则关闭它
                if (!this.selectContainer.matches(':hover') && !this.optionsContainer.matches(':hover')) {
                    this.selectContainer.classList.remove('open');
                }
            }, 300);
        });

    }

    static get observedAttributes() {
        return ['data'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'data' && oldValue !== newValue) {
            const allowCustom = this.hasAttribute('allow-custom'); // 获取 allow-custom 属性
            this.updateOptions(JSON.parse(newValue), allowCustom); // 传递 allowCustom
        }
        if (name === 'allow-custom') {
            const data = this.getAttribute('data');
            this.updateOptions(JSON.parse(data), this.hasAttribute('allow-custom'));
        }
    }

    setDisabled(disabled) {
        if (disabled) {
            this.selectContainer.classList.add('disabled');
            this.setAttribute('disabled', '');
            const iTag = this.selectContainer.querySelector('i');
            if (iTag) {
                this.selectContainer.removeChild(iTag);
            }

        } else {
            this.selectContainer.classList.remove('disabled');
            this.removeAttribute('disabled');
        }
    }

    updateOptions(options, allowCustom = false) { // 添加 allowCustom 参数
        this.optionsContainer.innerHTML = '';
        if (options == null || options.length == 0) {
            let optionElem = document.createElement('div');
            optionElem.classList.add('custom-option-null');
            optionElem.setAttribute('data-value', -1);
            // optionElem.innerText = YZUI_NO_DATA;
            this.optionsContainer.appendChild(optionElem);
        } else {
            options.forEach(option => {
                let optionElem = document.createElement('div');
                optionElem.classList.add('custom-option');
                optionElem.setAttribute('data-value', option.key);
                optionElem.innerText = option.label;
                this.optionsContainer.appendChild(optionElem);
            });

            if (allowCustom) { // 如果允许自定义
                let customOptionElem = document.createElement('div');
                customOptionElem.classList.add('custom-option');
                customOptionElem.innerText = "其他/自定义"; // 自定义选项文本
                customOptionElem.setAttribute('data-value', 'custom'); // 自定义选项值
                this.optionsContainer.appendChild(customOptionElem);
            }
        }
    }


    toggleOptions(event) {

        event.stopPropagation();
        const container = this.shadow.querySelector('.select-container');
        container.classList.toggle('open');

        if (container.classList.contains('open')) {
            this.adjustDropdownPosition();
        }

    }

    adjustDropdownPosition() {
        const options = this.shadow.querySelector('.custom-options');
        const containerRect = this.selectContainer.getBoundingClientRect();
        const viewportHeight = window.innerHeight;
        // 计算可用空间
        const spaceBelow = viewportHeight - containerRect.bottom;
        const spaceAbove = containerRect.top;

        // 确定显示方向
        if (spaceBelow < options.getBoundingClientRect().height + 10 && spaceAbove > spaceBelow) { // 下方空间不足且上方空间足够
            options.classList.add('reverse-position');
            options.style.top = 'auto';
            options.style.bottom = '110%';
        } else {
            options.classList.remove('reverse-position');
            options.style.top = '110%';
            options.style.bottom = 'auto';
        }
    }


    selectOption(event) {
        event.stopPropagation();
        const option = event.target.closest('.custom-option');
        if (option) {
            if (option.getAttribute('data-value') === 'custom') {
                this.selectTrigger.textContent = "";
                this.selectTrigger.classList.remove('selected');

                // 创建输入框
                const input = document.createElement('input');
                input.type = 'text';
                input.classList.add('custom-input');
                input.style.width = 'calc(100% - 20px)';
                input.style.boxSizing = 'border-box';
                input.style.border = 'none';
                input.style.outline = 'none';

                this.selectTrigger.appendChild(input);
                input.focus();

                const handleInputBlur = () => {
                    const inputValue = input.value;
                    this.selectTrigger.textContent = inputValue || this.getAttribute('placeholder') || "请选择";
                    this.selectTrigger.classList.add('selected');

                    this.selectContainer.setAttribute('select-value', inputValue);
                    this.selectContainer.setAttribute('select-label', inputValue);

                    this.updateHiddenInput(inputValue);

                    this.dispatchEvent(new CustomEvent('change', {detail: {value: inputValue}}));
                    this.selectContainer.classList.remove('open');
                    input.removeEventListener('blur', handleInputBlur);
                    input.remove();
                };

                input.addEventListener('blur', handleInputBlur);
                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter') {
                        input.blur();
                    }
                });
            } else {
                this.selectTrigger.textContent = option.textContent;
                this.selectContainer.setAttribute('select-value', option.getAttribute('data-value'));
                this.selectContainer.setAttribute('select-label', option.textContent);
                this.selectTrigger.classList.add('selected');

                this.updateHiddenInput(option.getAttribute('data-value'));

                this.dispatchEvent(new CustomEvent('change', {detail: {value: option.getAttribute('data-value')}}));

                this.shadow.querySelector('.select-container').classList.remove('open');
            }
        }
    }


    closeOptions(event) {
        if (!this.shadow.contains(event.target)) {
            this.shadow.querySelector('.select-container').classList.remove('open');
        }
    }

    getValue() {
        return this.selectContainer.getAttribute('select-value');
    }

    getLabel() {
        return this.selectContainer.getAttribute('select-label');
    }

    setValue(value) {
        const options = this.shadow.querySelectorAll('.custom-option');
        options.forEach(option => 
            { 
            if (option.getAttribute('data-value') == value || option.getAttribute('data-value') === "custom") {
                if (option.getAttribute('data-value') === "custom"){
                    this.selectTrigger.textContent = value;
                }else{
                    this.selectTrigger.textContent = option.textContent;
                }
                this.selectContainer.setAttribute('select-value', value);
                this.selectContainer.setAttribute('select-label', option.textContent);
                this.selectTrigger.classList.add('selected');

                // 更新隐藏输入字段的值
                this.updateHiddenInput(value);
            }
        });
    }

    setLabel(value) {
        const options = this.shadow.querySelectorAll('.custom-option');
        options.forEach(option => {
            if (option.textContent == value) {
                this.selectTrigger.textContent = value;
                this.selectContainer.setAttribute('select-value', option.getAttribute('data-value'));
                this.selectContainer.setAttribute('select-label', value);
                this.selectTrigger.classList.add('selected');

                // 更新隐藏输入字段的值
                this.updateHiddenInput(value);
            }
        });
    }

    updateHiddenInput(value) {
        let hiddenInput = document.querySelector(`input[name="${this.getAttribute('name')}"]`);
        if (!hiddenInput) {
            hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = this.getAttribute('name');
            this.parentNode.appendChild(hiddenInput);
        }
        hiddenInput.value = value;
    }

    reset() {
        this.selectTrigger.textContent = this.getAttribute('placeholder') || "请选择";
        this.selectContainer.removeAttribute('select-value');
        this.selectContainer.removeAttribute('select-label');
        this.selectTrigger.classList.remove('selected');

        // 更新隐藏输入字段的值
        this.updateHiddenInput('');
    }

    connectedCallback() {
        document.addEventListener('click', this.boundCloseOptions);

        // 支持直接 value 传值
        if (this.getAttribute('value') && this.getAttribute('value').trim() !== '') {
            this.setValue(this.getAttribute('value'));
        }

        const data = this.getAttribute('data');
        const allowCustom = this.hasAttribute('allow-custom');
        if (!data) {
            this.setAttribute('data', JSON.stringify([]));
        } else {
            this.updateOptions(JSON.parse(data), allowCustom);
        }

    }

    static get observedAttributes() {
        return ['data', 'allow-custom'];
    }
}

customElements.define('yz-select', YzSelect);


class YzTextarea extends HTMLElement {
    static formAssociated = true;

    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});

        const style = document.createElement('style');
        style.textContent = `
      textarea {
        width: var(--textarea-width, 200px);
        height: var(--textarea-height, 100px);
        resize: none;
        border-radius: 4px;
        border: 1px solid #D9D9D9;
        outline: 0;
        padding: 6px 20px 6px 10px;
        font-size: 14px;
        color: rgba(0,0,0,0.65);
        line-height: 21px;
        text-align: left;
        font-style: normal;
      }
      textarea::placeholder {
        color: rgba(0,0,0,0.25);
      }
      textarea:hover {
        border: 1px solid #0B65A0;
      }
      textarea:focus {
        border: 1px solid #0B65A0;
      }
      .textarea-container {
        position: relative;
        display: inline-block;
      }
      .char-counter {
        position: absolute;
        bottom: 6px;
        right: 10px;
        font-size: 12px;
        color: rgba(0,0,0,0.25);
      }
    `;
        this.shadow.appendChild(style);

        const container = document.createElement('div');
        container.classList.add('textarea-container');
        this.shadow.appendChild(container);

        this.textarea = document.createElement('textarea');
        container.appendChild(this.textarea);

        this.counter = document.createElement('div');
        this.counter.classList.add('char-counter');
        container.appendChild(this.counter);

        this.textarea.placeholder = this.getAttribute('placeholder') || '';

        this.maxBytes = this.getAttribute('max-length') || 120; // 假设这个值是字节数
        this.textarea.setAttribute('maxlength', this.maxBytes);

        this.updateDimensions();
        this.computedChar();

        this.textarea.addEventListener('input', () => {
            this.limitInputToBytes();
            this.internals.setFormValue(this.textarea.value);
            this.dispatchEvent(new CustomEvent('inputchange', {
                detail: {value: this.textarea.value}
            }));
        });

        // 创建 ElementInternals 对象
        this.internals = this.attachInternals();
    }

    // 在表单提交时返回 textarea 的值
    get value() {
        return this.textarea.value;
    }

    getBytes(params) {
        let bytes = 0;
        for (let i = 0; i < params.length; i++) {
            const charCode = params.charCodeAt(i);
            // ASCII 字符占 1 字节，其他字符占 2 字节
            bytes += (charCode > 255) ? 2 : 1;
        }
        return bytes;
    }

    limitInputToBytes() {
        const currentValue = this.textarea.value;
        const currentBytes = this.getBytes(currentValue);

        if (currentBytes > this.maxBytes) {
            // 如果超过最大字节数，则截断到合适的长度
            let truncatedValue = '';
            let bytesCounted = 0;

            for (let i = 0; i < currentValue.length; i++) {
                const char = currentValue[i];
                const charBytes = (char.charCodeAt(0) > 255) ? 2 : 1;

                if (bytesCounted + charBytes > this.maxBytes) {
                    break;
                }

                truncatedValue += char;
                bytesCounted += charBytes;
            }

            this.textarea.value = truncatedValue;
        }

        this.computedChar();
    }

    set value(val) {
        this.textarea.value = val;
        this.computedChar();
        this.internals.setFormValue(val);
    }

    // 在属性变化时更新样式
    attributeChangedCallback(name, oldValue, newValue) {
        if (oldValue !== newValue) {
            this.updateDimensions();
        }
    }

    static get observedAttributes() {
        return ['width', 'height'];
    }

    updateDimensions() {
        const width = this.getAttribute('width') || '200px';
        const height = this.getAttribute('height') || '100px';
        this.style.setProperty('--textarea-width', width);
        this.style.setProperty('--textarea-height', height);
    }

    computedChar() {
        const currentBytes = this.getBytes(this.textarea.value);
        this.counter.textContent = `${currentBytes}/${this.maxBytes}`;
    }

    getValue() {
        return this.textarea.value;
    }

    setValue(val) {
        this.textarea.value = val;
        this.computedChar();
    }
}

customElements.define('yz-textarea', YzTextarea);


class YzCheckbox extends HTMLElement {
    static formAssociated = true; // 启用表单关联

    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});
        const style = document.createElement('style');
        style.textContent =
            `
        /* 隐藏默认复选框 */
        input[type="checkbox"] {
            display: none;
        }
        input[type="checkbox"]:disabled + label:before {
            border: 2px solid rgba(0, 0, 0, 0.15);
            background-color: #EFEFEF;
        }
        input[type="checkbox"]:disabled + label {
            color: rgba(0, 0, 0, 0.25);
        }
        /* 创建自定义复选框 */
        input[type="checkbox"] + label {
            position: relative;
            cursor: pointer;
            vertical-align: text-bottom;
        }
        /* 创建自定义复选框的外观 */
        input[type="checkbox"] + label:before {
            content: "";
            display: inline-block;
            width: 14px;
            height: 14px;
            border: 1px solid rgba(0, 0, 0, 0.45);
            border-radius: 4px;
            margin-right: 10px;
            vertical-align: text-bottom;
        }
        /* 在复选框被选中时显示对号 */
        input[type="checkbox"]:checked + label:after {
            content: "";
            position: absolute;
            left: 8px;
            top: 10px;
            font-size: 14px;
            width: 4px; /* 勾的宽度 */
            height: 8px; /* 勾的高度 */
            border: solid #0B65A0;
            border-width: 0 2px 2px 0;
            transform: translate(-50%, -50%) rotate(45deg); /* 勾的旋转角度 */
        }
        .yzcheckbox {
          display: inline-block;
          font-size: 14px;
          color: rgba(0,0,0,0.75);
          line-height: 20px;
          text-align: left;
          font-style: normal;
        }
      `;
        this.shadow.appendChild(style);

        // 获取展示名称
        let showName = this.getAttribute('show');
        // 获取id
        let id = this.getAttribute('id');

        if (!showName || !id) {
            if (!showName) {
                console.error('yz-checkbox 没有赋show');
            }
            if (!id) {
                console.error('yz-checkbox 没有赋id');
            }
        } else {
            this.container = document.createElement('div');
            this.container.classList.add('yzcheckbox');

            this.input = document.createElement('input');
            this.input.type = 'checkbox';
            this.input.id = id;

            // 判断是不是disabled
            let isdisabled = this.getAttribute('disabled');
            if (isdisabled != null) {
                this.input.setAttribute('disabled', '')
            }

            // 将name属性增加到input上
            let name = this.getAttribute('name');
            if (name != null) {
                this.input.setAttribute('name', name);
            }

            // 获取checked属性
            let checked = this.hasAttribute('checked');
            if (checked == true) {
                this.input.setAttribute('checked', true);
            }

            this.container.appendChild(this.input);

            this.label = document.createElement('label');
            this.label.setAttribute('for', id);
            this.label.textContent = showName;
            this.container.appendChild(this.label);

            this.shadow.appendChild(this.container);
        }

        // 创建Internals对象
        this.internals = this.attachInternals();
    }

    // 在表单提交时返回复选框的值
    get formAssociated() {
        return true;
    }

    // 返回复选框的值
    get value() {
        return this.input.checked ? this.getAttribute('value') || '' : '';
    }

    // 当checked属性改变时同步更新internals的value
    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'checked' && this.input) {
            this.internals.setFormValue(this.value);
        }
    }

    static get observedAttributes() {
        return ['checked'];
    }

    connectedCallback() {
        this.input.addEventListener('change', () => {
            if (this.input.checked) {
                this.setAttribute('value', this.getAttribute('value'));
            } else {
                // this.removeAttribute('value');
            }
            this.internals.setFormValue(this.value);
        });
    }

    enableCheckbox() {
        if (this.input) {
            this.input.removeAttribute('disabled');
        }
    }

    disableCheckbox() {
        if (this.input) {
            this.input.setAttribute('disabled', true);
        }
    }
}

customElements.define('yz-checkbox', YzCheckbox);


// 上传文件组件

class YzUpload extends HTMLElement {
    static formAssociated = true; // 启用表单关联

    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});
        const style = document.createElement('style');
        style.textContent = `
        :host {
          width: 100%;
        }
        .container {
          border: 1px dashed #D9D9D9;
          width: calc(100% - 40px);
          height: var(--height, 170px);
          border-radius: 4px;
          text-align: center;
          padding: 10px;
          margin: 0 auto;
        }
        .container:hover {
          border-color: #1890ff;
        }
        .iconfont {
          margin-top: 17px !important;
          margin-bottom: 22px !important;
          font-size: 48px !important;
          color: #B7E6F8 !important;
        }
        .textStyle{
          font-size: 12px;
          color: rgba(0,0,0,0.65);
          line-height: 16px;
        }
        #fileElem {
          display: none;
        }
        .errorMessage {
          color: red;
          font-size: 12px;
        }
        .drag-over {
          border-color: #1890ff;
        }
      `;
        this.shadow.appendChild(style);

        // 引入外部 CSS 文件
        const linkIconfont = document.createElement('link');
        linkIconfont.rel = 'stylesheet';
        linkIconfont.type = 'text/css';
        linkIconfont.href = '/static/css/iconfont.css';
        this.shadow.appendChild(linkIconfont);

        const action = this.getAttribute('action');
        const text1 = this.getAttribute('text1');
        const text2 = this.getAttribute('text2');
        const text3 = this.getAttribute('text3');

        if (text1 == null && text2 == null && text3 == null) {
            // 有一个或多个属性未被设置，提示报错并退出
            throw new Error('使用 yz-upload 需要指定 text1, text2, text3');
        }

        // 创建容器
        this.container = document.createElement('div');
        this.container.classList.add('container');

        // 创建form表单
        this.form = document.createElement('form');
        this.form.action = action;
        this.form.method = 'post';
        this.form.enctype = 'multipart/form-data';

        // 创建图片
        this.icon = document.createElement('div');
        this.icon.classList.add('loginIcon', 'iconfont', 'icon-shangchuan');
        this.form.appendChild(this.icon);

        // 创建第一行提示信息
        this.p1 = document.createElement('P');
        this.p1.classList.add('textStyle');
        this.p1.textContent = text1;
        this.label = document.createElement('label');
        this.label.setAttribute('for', 'fileElem');
        this.label.style.color = '#0B65A0';
        this.label.textContent = text2;
        this.p1.appendChild(this.label);
        this.form.appendChild(this.p1);

        // 创建第二行提示信息
        this.p2 = document.createElement('P');
        this.p2.classList.add('textStyle');
        this.p2.textContent = text3;
        this.p2.style.color = 'rgba(0,0,0,0.45)';
        this.form.appendChild(this.p2);

        // 创建input type等于file
        this.input = document.createElement('input');
        this.input.type = 'file';
        this.input.id = 'fileElem';
        this.input.name = 'file';
        this.input.accept = '.zip';
        this.form.appendChild(this.input);

        // 创建错误消息显示元素
        this.errorMessage = document.createElement('div');
        this.errorMessage.classList.add('errorMessage');
        this.form.appendChild(this.errorMessage);

        // 添加form表单到容器
        this.container.appendChild(this.form);

        // 添加全部到shadow
        this.shadow.appendChild(this.container);

        // 添加验证函数
        this.input.addEventListener('change', () => {
            if (this.input.files.length > 0 && this.validateFile(this.input.files[0])) {
                // 重置 input
                this.input.value = '';
            }
        });

        // 添加拖动上传事件监听器
        this.container.addEventListener('dragover', (e) => this.handleDragOver(e));
        this.container.addEventListener('dragleave', (e) => this.handleDragLeave(e));
        this.container.addEventListener('drop', (e) => this.handleDrop(e));

        this.onSuccess = null;
    }

    connectedCallback() {
        if (this.hasAttribute('onSuccess')) {
            this.onSuccess = new Function('return ' + this.getAttribute('onSuccess'))();
        }
    }

    validateFile(file) {
        this.errorMessage.textContent = '';
        if (!file) {
            this.errorMessage.textContent = '未选择文件';
            return false;
        }

        const allowedTypes = ['application/zip', 'application/x-zip-compressed'];
        const maxSize = 300 * 1024 * 1024;

        if (!allowedTypes.includes(file.type)) {
            this.errorMessage.textContent = '文件类型不允许';
            return false;
        }

        if (file.size > maxSize) {
            this.errorMessage.textContent = '文件太大';
            return false;
        }

        if (this.getAttribute('action')) {

            var formData = new FormData(this.form);

            // 使用Fetch API发送异步请求
            fetch(this.form.action, {
                method: 'POST',
                body: formData
            })
                .then(response => {

                    if (!response.ok) {
                        throw new Error('网络响应失败');
                    }
                    return response.json(); // 解析JSON
                })
                .then(data => {

                    if (this.onSuccess) {
                        this.onSuccess(data);
                    }

                })
                .catch(error => {
                    console.error('Error:', error);
                });


        }
        return true;
    }

    handleDragOver(event) {
        event.preventDefault();
        event.stopPropagation();
        this.container.classList.add('drag-over');
    }

    handleDragLeave(event) {
        event.preventDefault();
        event.stopPropagation();
        this.container.classList.remove('drag-over');
    }

    handleDrop(event) {
        event.preventDefault();
        event.stopPropagation();
        this.container.classList.remove('drag-over');
        const files = event.dataTransfer.files;
        if (files.length > 0) {
            this.input.files = files;
            if (this.validateFile(files[0])) {
                // 重置 input
                this.input.value = '';
            }
        }
    }
}

customElements.define('yz-upload', YzUpload);


class YzSwitch extends HTMLElement {
    constructor() {
        super();
        this.attachShadow({mode: 'open'});

        // 创建并添加样式到 Shadow DOM 中
        const style = document.createElement('style');
        style.textContent = `
            .yz-switch {
                position: relative;
                display: inline-block;
                width: 60px;
                height: 24px;
            }

            .yz-switch input {
                opacity: 0;
                width: 0;
                height: 0;
            }

            .slider {
                position: absolute;
                cursor: pointer;
                width: 40px;
                height: 24px;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.15);
                transition: .4s;
                display: inline-block;
            }

            .slider:before {
                position: absolute;
                content: "";
                height: 18px;
                width: 18px;
                left: 3px;
                bottom: 3px;
                background-color: white;
                transition: .4s;
            }

            input:checked + .slider {
                background-color: #1284BB;
            }

            input:checked + .slider:before {
                transform: translateX(16px);
            }

            .slider.round {
                border-radius: 34px;
            }

            .slider.round:before {
                border-radius: 50%;
            }

            .textResult {
                position: absolute;
                left: 50px;
                font-size: 14px;
                color: rgba(0,0,0,0.25);
                line-height: 24px;
                font-style: normal;
            }
        `;
        this.shadowRoot.appendChild(style);


        const container = document.createElement('label');
        container.classList.add('yz-switch');

        this.input = document.createElement('input');
        this.input.type = 'checkbox';

        const slider = document.createElement('span');
        slider.classList.add('slider', 'round');

        this.textResult = document.createElement('span');
        this.textResult.classList.add('textResult');
        this.textResult.textContent = YZUI_SWITCH_CLOSE;

        container.appendChild(this.input);
        container.appendChild(slider);
        container.appendChild(this.textResult);

        //设置默认值
        let value = this.getAttribute('value');
        if (value && value === 'on') {
            this.textResult.textContent = YZUI_SWITCH_OPEN;
            this.input.setAttribute('checked', '');
        }

        this.shadowRoot.appendChild(container);

        this.internals = this.attachInternals();

        // 监听开关状态变化
        this.input.addEventListener('change', (event) => {
            event.stopPropagation();
            let customEvent = new CustomEvent('switch-change', {detail: this.input.checked});
            this.dispatchEvent(customEvent);

            if (this.input.checked) {
                this.textResult.textContent = YZUI_SWITCH_OPEN;
                this.internals.setFormValue('on');
                this.setAttribute('value', 'on');
            } else {
                this.textResult.textContent = YZUI_SWITCH_CLOSE;
                this.internals.setFormValue('');
                this.setAttribute('value', '');
            }
        });


        // 初始化值
        this.internals.setFormValue(this.input.checked ? 'on' : '');
    }

    // 需要声明表单关联
    static get formAssociated() {
        return true;
    }

    static get observedAttributes() {
        return ['value'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'value') {
            if (newValue === 'on') {
                this.input.checked = true;
                this.textResult.textContent = YZUI_SWITCH_OPEN;
                this.internals.setFormValue('on');
            } else {
                this.input.checked = false;
                this.textResult.textContent = YZUI_SWITCH_CLOSE;
                this.internals.setFormValue('');
            }
        }
    }

    getValue() {
        return this.getAttribute('value');
    }

    setCheck() {
        this.setAttribute('value', 'on');
    }

    setCancel() {
        this.setAttribute('value', '');
    }

}

customElements.define('yz-switch', YzSwitch);

class YzTable extends HTMLElement {
    static get observedAttributes() {
        return ['data', 'headers', 'col-widths', 'height'];
    }

    constructor() {
        super();
        this.attachShadow({ mode: 'open' });

        const style = document.createElement('style');
        style.textContent = `
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }

        ::-webkit-scrollbar-thumb {
            background: #DBE8F1;
            border-radius: 6px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            table-layout: auto;
            background: #FFFFFF;
        }

        thead th {
            height: 40px;
            padding: 10px;
            font-size: 14px;
            color: rgba(0, 0, 0, 0.65);
            background-color: #F7F7F7;
            border-bottom: 1px solid #EBEDF4;
            position: sticky;
            top: 0;
            z-index: 1;
            box-sizing: border-box;
            text-align: left; /* 将表头文本左对齐 */
        }

        tbody tr {
            height: 40px;
            border-bottom: 1px solid #EBEDF4;
        }

        tbody td {
            padding: 10px;
            font-size: 14px;
            color: rgba(0, 0, 0, 0.65);
            box-sizing: border-box;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        tbody tr:hover {
            background-color: #F7F7F7;
        }

        .table-wrapper {
            max-width: 100%;
            overflow-x: auto;
            border: 1px solid #EBEDF4;
            border-bottom:none;
            border-radius: 4px;
        }
        thead th.sticky-col {
            border-bottom: 2px solid #EBEDF4 !important;
            background-color: #F7F7F7;
            z-index: 3 !important;;
        }
      `;
        this.shadowRoot.appendChild(style);

        this.wrapper = document.createElement('div');
        this.wrapper.classList.add('table-wrapper');
        this.wrapper.style.maxHeight = 'var(--textarea-height, 490px)';
        this.shadowRoot.appendChild(this.wrapper);

        this.stickyColumnCount = 1;
        this.render();
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (oldValue !== newValue) {
            this.render();
        }
    }

    setStickyColumns(count) {
        this.stickyColumnCount = count;
        this.render(); // 重新渲染表格
    }

    render() {
        this.wrapper.innerHTML = '';

        const table = document.createElement('table');
        const colgroup = document.createElement('colgroup');
        const thead = document.createElement('thead');
        const tbody = document.createElement('tbody');

        const headers = this.getAttribute('headers').split(',');
        const data = JSON.parse(this.getAttribute('data'));
        const colWidthsAttr = this.getAttribute('col-widths');
        const height = this.getAttribute('height');
        this.style.setProperty('--textarea-height', height);

        const columnCount = headers.length;
        let widths = [];

        const isScrollable = columnCount >= 10;
        if (colWidthsAttr && colWidthsAttr.trim()) {
            widths = colWidthsAttr.split(',').map(w => w.trim());
        } else {
            widths = headers.map(() => isScrollable ? '150px' : 'auto');
        }

        headers.forEach((_, index) => {
            const col = document.createElement('col');
            col.style.width = widths[index] || 'auto';
            col.style.minWidth = '150px';
            colgroup.appendChild(col);
        });

        const trHead = document.createElement('tr');
        let leftOffset = 0;
        headers.forEach((header, index) => {
            const th = document.createElement('th');
            th.textContent = header.trim();

            if (index < this.stickyColumnCount) {
                th.style.position = 'sticky';
                th.style.left = `${leftOffset}px`;
                th.style.zIndex = 2;
                th.classList.add('sticky-col');
                leftOffset += parseInt(widths[index] || 150);
            }

            trHead.appendChild(th);
        });
        thead.appendChild(trHead);

        data.forEach(row => {
            const tr = document.createElement('tr');
            let leftOffset = 0;
            row.forEach((cell, index) => {
                const td = document.createElement('td');
                td.textContent = cell;

                if (index < this.stickyColumnCount) {
                    td.style.position = 'sticky';
                    td.style.left = `${leftOffset}px`;
                    td.style.background = '#FFFFFF';
                    td.style.zIndex = 1;
                    leftOffset += parseInt(widths[index] || 150);
                }

                tr.appendChild(td);
            });
            tbody.appendChild(tr);
        });

        table.appendChild(colgroup);
        table.appendChild(thead);
        table.appendChild(tbody);
        this.wrapper.appendChild(table);
    }

    applyCustomStyles(columnIndex, styleFunction, dependentColumnIndex = null) {
        const rows = this.shadowRoot.querySelectorAll('tbody tr');
        rows.forEach(row => {
            const cell = row.children[columnIndex];
            const dependentCell = dependentColumnIndex !== null ? row.children[dependentColumnIndex] : null;
            if (cell) {
                styleFunction(cell, dependentCell);
            }
        });
    }

    applyHeaderStyles(columnIndex, styleFunction) {
        const headerCells = this.shadowRoot.querySelectorAll('thead th');
        if (headerCells.length > columnIndex) {
            styleFunction(headerCells[columnIndex]);
        }
    }
}

customElements.define('yz-table', YzTable);



class YzPagination extends HTMLElement {
    constructor() {
        super();
        this.attachShadow({mode: 'open'});

        // 创建并添加样式到 Shadow DOM 中
        const style = document.createElement('style');
        style.textContent = `
      .pagination {
          display: flex;
          list-style: none;
          padding: 0;
          margin: 0;
      }
      .pagination li {
          margin: 0 5px;
          cursor: pointer;
          width: 28px;
          height: 28px;
          background: #FFFFFF;
          border-radius: 4px;
          border: 1px solid #D9D9D9;
          font-size: 12px;
          color: rgba(0,0,0,0.65);
          line-height: 28px;
          text-align:center;
      }
      .pagination li.active {
          background-color: #0B65A0 ;
          color: white;
          border-color: #0B65A0 ;
      }
      .pagination li.disabled {
          color: #ccc;
          cursor: not-allowed;
      }
      `;
        this.shadowRoot.appendChild(style);

        this.pageSize = parseInt(this.getAttribute('page-size')) || 10;
        this.total = parseInt(this.getAttribute('total')) || 0;
        this.currentPage = 1;

        const wrapper = document.createElement('div');
        this.paginationList = document.createElement('ul');
        this.paginationList.className = 'pagination';

        wrapper.appendChild(this.paginationList);
        this.shadowRoot.appendChild(wrapper);

        this.render();
    }

    render() {
        this.paginationList.innerHTML = '';

        const totalPages = Math.ceil(this.total / this.pageSize);

        const createPageItem = (text, page, isActive = false, isDisabled = false) => {
            const li = document.createElement('li');
            li.textContent = text;
            li.className = isActive ? 'active' : isDisabled ? 'disabled' : '';
            if (!isDisabled) {
                li.addEventListener('click', () => this.goToPage(page));
            }
            return li;
        };


        this.paginationList.appendChild(createPageItem('<', this.currentPage - 1, false, this.currentPage === 1));

        for (let i = 1; i <= totalPages; i++) {
            this.paginationList.appendChild(createPageItem(i, i, this.currentPage === i));
        }

        this.paginationList.appendChild(createPageItem('>', this.currentPage + 1, false, this.currentPage === totalPages));
    }

    goToPage(page) {
        const totalPages = Math.ceil(this.total / this.pageSize);
        if (page < 1 || page > totalPages) return;
        this.currentPage = page;
        this.render();
        this.dispatchEvent(new CustomEvent('page-change', {detail: {page: this.currentPage}}));
    }
}

customElements.define('yz-pagination', YzPagination);


class YzMultiSelect extends HTMLElement {
    static formAssociated = true; // 启用表单关联
    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});
        this.internals = this.attachInternals(); // 初始化 internals
        const style = document.createElement('style');
        style.textContent = `

  /* 样式更新 */
  ::-webkit-scrollbar {
      width: 6px;
  }

  ::-webkit-scrollbar-track {
      background: none;
  }

  ::-webkit-scrollbar-thumb {
      background: #DBE8F1;
      border-radius: 6px;
  }

  ::-webkit-scrollbar-thumb:hover {
      background: #DBE8F1;
  }

.select-container {
  position: relative;
  width: var(--select-width,220px);
  height: var(--select-height,32px);
  box-sizing: border-box;
  display: inline-flex;
  background: var(--background,#FFFFFF);
  border-radius: 4px;
  border: 1px solid var(--border-color,#D9D9D9);
  vertical-align: top;
  font-size:14px;
}

.select-container.disabled {
  background: #F5F5F5; /* 灰色背景 */
  border: 1px solid #D9D9D9; /* 灰色边框 */
  color: rgba(0,0,0,0.25); /* 灰色文字 */
  opacity: 0.8; /* 调整透明度，让整体效果柔和 */
  cursor: url('/static/image/notAllowed.png'), not-allowed;
}
.select-container.disabled:hover{
  border: 1px solid #D9D9D9; /* 灰色边框 */
}
.select-container:hover {
  border:1px solid #0B65A0;
}
.select-container.open {
  border: 1px solid #0B65A0;
}


.custom-select-trigger {
  width: 100%;
  color: var(--color,rgba(0,0,0,0.25));
  border-radius: 4px;
  padding: 4px 8px; /* 增加一点上下 padding */
  display: block; /* block 显示 */
  overflow: hidden;
  text-overflow: ellipsis; /* 使用省略号 */
  white-space: nowrap; /* 单行显示 */
  box-sizing: border-box; /* 确保 padding 在宽度内 */
  height: auto; /* 高度由内容决定 */
  line-height: normal; /* 保持正常行高 */
  display: flex; /* 使用 Flexbox */
  align-items: center; /* 垂直居中 */
  
}

.custom-select-trigger:hover {
    // overflow: visible;
    // white-space: normal;
}
.custom-select-trigger.selected {
  color: var(--color,rgba(0,0,0,0.65));
}

  .custom-options {
      position: absolute;
      top: 110%;
      left: 0;
      width: 100%;
      background: var(--background,#FFFFFF);
      border: 1px solid var(--border-color,#D9D9D9);
      border-radius: 4px;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
      max-height: 300px;
      overflow-y: auto;
      display: none;
      z-index: 1000;
  }

  .select-container.open .custom-options {
      display: flex;
      flex-direction: column;
  }

.custom-option {
  line-height:28px;
  padding: 1px 8px;
  color: var(--color,rgba(0,0,0,0.75));
  cursor: pointer;
  white-space: nowrap; /* 单行显示 */
  display:flex;
  align-items:center;
}


.custom-option:hover {
  overflow: visible; /* 隐藏超出部分 */
  white-space: normal; /* 单行显示 */
}

  .custom-option-null {
    line-height:28px;
    padding: 1px 8px;
    color: var(--color,rgba(0,0,0,0.65));
    cursor: pointer;
    text-align: center;
    font-size: 0.8em;
}


  .custom-option input {
      margin-right: 8px;
  }

  .custom-option label {
      pointer-events: none;
  }

  .iconPosition {
    color: #999999;
    position: absolute;
    top: 50%;
    right: 10px;
    transform: translateY(-50%);
    pointer-events: none;
  }


  /* 选中标签样式 */
  .selected-tags {
      width:100%;
      box-sizing: border-box; 
      flex-wrap: wrap;
      margin-right: 16px;
      display:flex;
      align-items:center;
  }

  .selected-tag {
      background-color: var(--optionsbackground,#F7F7F7);
      color: var(--color,rgba(0,0,0,0.75));
      padding: 2px 6px;
      border-radius: 5px;
      font-size: 12px;
      margin-right: 4px;
      margin-bottom: 2px;
  }

  .selected-tag:last-child {
      margin-right: 0;
  }


  .selected-count {
      font-size: 12px;
      color: #0075ff;
  }

  input[type="checkbox"] {
    width: 16px; /* 设置多选框的宽度 */
    height: 16px; /* 设置多选框的高度 */
    appearance: none; /* 隐藏默认的多选框样式 */
    background-color: white; /* 设置未选中的背景颜色 */
    border: 1px solid rgba(0,0,0,0.45); /* 边框颜色为灰色 */
    border-radius: 4px; /* 圆角边框 */
    cursor: pointer;
    position: relative;
    
}

  input[type="checkbox"]:checked {
     background-color: white; /* 选中时背景为蓝色 */
}

 input[type="checkbox"]:checked::after {
    content: "";
    position: absolute;
    top: 35%;
    left: 50%;
    width: 4px; /* 勾的宽度 */
    height: 8px; /* 勾的高度 */
    border: solid #0B65A0;
    border-width: 0 2px 2px 0;
    transform: translate(-50%, -50%) rotate(45deg); /* 勾的旋转角度 */
}

input[type="checkbox"].indeterminate {
    background-color: white; /* 确保背景颜色为白色 */
    border: 1px solid rgba(0,0,0,0.45); /* 边框颜色 */
    position: relative;
}

input[type="checkbox"].indeterminate::after {
    content: "";
    position: absolute;
    top: 50%;
    left: 2px;
    right: 2px;
    height: 2px; /* 直线的高度 */
    background-color: #0B65A0; /* 直线的颜色 */
    transform: translateY(-50%);
}
  .reverse-position {
      box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
      bottom: calc(100% + 5px);
      top: auto !important;
  }
`;

        this.shadow.appendChild(style);

// 引入外部 CSS 文件
        const linkIconfont = document.createElement('link');
        linkIconfont.rel = 'stylesheet';
        linkIconfont.type = 'text/css';
        linkIconfont.href = '/static/css/iconfont.css';
        this.shadow.appendChild(linkIconfont);

        this.selectContainer = document.createElement('div');
        this.selectContainer.classList.add('select-container');
        this.selectContainer.style.setProperty('--select-width', this.getAttribute('width') || '220px');

        this.selectTrigger = document.createElement('div');
        this.selectTrigger.classList.add('custom-select-trigger');
        this.selectTrigger.textContent = this.getAttribute('placeholder') || "请选择";
        this.selectContainer.appendChild(this.selectTrigger);

        this.selectedTagsContainer = document.createElement('div');
        this.selectedTagsContainer.classList.add('selected-tags');
        this.selectTrigger.appendChild(this.selectedTagsContainer);

        this.optionsContainer = document.createElement('div');
        this.optionsContainer.classList.add('custom-options');
        this.selectContainer.appendChild(this.optionsContainer);

// 创建小箭头
        this.iconElem = document.createElement('i');
        this.iconElem.classList.add('iconfont', 'icon-xiala', 'iconPosition');
        this.selectContainer.appendChild(this.iconElem);

        this.shadow.appendChild(this.selectContainer);

        if (!this.hasAttribute('disabled')) {
            this.selectTrigger.addEventListener('click', this.toggleOptions.bind(this));
            this.optionsContainer.addEventListener('click', this.handleOptionClick.bind(this));
        }

        this.selectedOptions = [];
    }

    static get observedAttributes() {
        return ['data', 'disabled'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'data' && oldValue !== newValue) {
            this.updateOptions(JSON.parse(newValue));
        } else if (name === 'disabled') {
            this.toggleDisabled(newValue !== null);
        }
    }

    updateOptions(options) {
        this.optionsContainer.innerHTML = '';
        if (!options || options.length === 0) {
            const noDataElem = document.createElement('div');
            noDataElem.classList.add('custom-option-null');
            noDataElem.setAttribute('data-value', -1);
            noDataElem.innerText = YZUI_NO_DATA;
            this.optionsContainer.appendChild(noDataElem);
            return;
        }

        const allOptionElem = document.createElement('div');
        allOptionElem.classList.add('custom-option');
        allOptionElem.innerHTML = `
          <input type="checkbox" class="select-all">
          <label>全部</label>
  `;
        this.optionsContainer.appendChild(allOptionElem);

        allOptionElem.addEventListener('click', (event) => {
            event.stopPropagation(); // 阻止事件冒泡
            const checkbox = allOptionElem.querySelector('.select-all');

            // 只在点击了该项时切换状态
            if (event.target !== checkbox) {
                checkbox.checked = !checkbox.checked; // 切换复选框的状态
            }

            const isChecked = checkbox.checked;
            this.toggleAllOptions(isChecked, options);
        });


        options.forEach(option => {
            const optionElem = document.createElement('div');
            optionElem.classList.add('custom-option');
            optionElem.innerHTML = `
            <input type="checkbox" value="${option.key}" class="option-checkbox">
            <label>${option.label}</label>
        `;

            optionElem.addEventListener('click', (event) => {
                event.stopPropagation(); // 阻止事件冒泡
                const checkbox = optionElem.querySelector('.option-checkbox');
                checkbox.checked = !checkbox.checked;
                this.toggleSingleOption(option, checkbox.checked);

                this.updateSelectAllState();
                this.updateTriggerText(); // 更新触发文本
                this.dispatchChangeEvent();
            });

            // 在复选框上添加点击事件
            const checkbox = optionElem.querySelector('.option-checkbox');
            checkbox.addEventListener('click', (event) => {
                event.stopPropagation(); // 阻止事件冒泡
                this.toggleSingleOption(option, checkbox.checked);

                this.updateSelectAllState();
                this.updateTriggerText(); // 更新触发文本
                this.dispatchChangeEvent();
            });

            this.optionsContainer.appendChild(optionElem);
        });
    }

    toggleAllOptions(isChecked, options) {
        const checkboxes = this.optionsContainer.querySelectorAll('.option-checkbox');
        this.selectedOptions = isChecked ? [...options] : [];

        checkboxes.forEach(checkbox => {
            checkbox.checked = isChecked;
        });

        this.updateSelectAllState();
        this.updateTriggerText(); // 更新触发文本
        this.dispatchChangeEvent();
    }


    toggleSingleOption(option, isChecked) {
        if (isChecked) {
            this.selectedOptions.push(option);
        } else {
            this.selectedOptions = this.selectedOptions.filter(opt => opt.key !== option.key);
        }

        // 更新全选框状态
        this.updateSelectAllState();

        this.updateTriggerText();
        this.dispatchChangeEvent();
    }


    updateSelectAllState() {
        const checkboxes = this.optionsContainer.querySelectorAll('.option-checkbox');
        const totalCheckboxes = checkboxes.length;
        const checkedCheckboxes = Array.from(checkboxes).filter(checkbox => checkbox.checked).length;

        const allCheckbox = this.optionsContainer.querySelector('.select-all');
        if (checkedCheckboxes === totalCheckboxes) {
            allCheckbox.checked = true;
            allCheckbox.classList.remove('indeterminate');
        } else if (checkedCheckboxes > 0) {
            allCheckbox.checked = false;
            allCheckbox.classList.add('indeterminate');
        } else {
            allCheckbox.checked = false;
            allCheckbox.classList.remove('indeterminate');
        }
    }

    toggleOptions(event) {
        event.stopPropagation();
        this.selectContainer.classList.toggle('open');

        if (this.selectContainer.classList.contains('open')) {
            this.adjustDropdownPosition();
        }
    }

    adjustDropdownPosition() {
        const options = this.shadow.querySelector('.custom-options');
        const containerRect = this.selectContainer.getBoundingClientRect();
        const viewportHeight = window.innerHeight;
        // 计算可用空间
        const spaceBelow = viewportHeight - containerRect.bottom;
        const spaceAbove = containerRect.top;

        // 确定显示方向
        if (spaceBelow < options.getBoundingClientRect().height + 10 && spaceAbove > spaceBelow) { // 下方空间不足且上方空间足够
            options.classList.add('reverse-position');
            options.style.top = 'auto';
            options.style.bottom = '110%';
        } else {
            options.classList.remove('reverse-position');
            options.style.top = '110%';
            options.style.bottom = 'auto';
        }
    }


    handleOptionClick(event) {
        const checkbox = event.target.closest('input[type="checkbox"]');
        if (checkbox) {
            const value = checkbox.value;
            const label = checkbox.nextElementSibling.textContent;
            this.toggleSingleOption({key: value, label: label}, checkbox.checked);
        }
    }

    updateTriggerText() {

        const selectedLabels = this.selectedOptions.map(option => option.label);
        const count = selectedLabels.length;

        // 清空已存在的标签
        this.selectedTagsContainer.innerHTML = '';
        this.selectTrigger.innerHTML = '';

        if (count === 0) {
            this.selectTrigger.textContent = "请选择";
        } else {
            let totalWidth = 0;
            const maxWidth = this.selectTrigger.offsetWidth;

            selectedLabels.forEach(label => {
                const tagElem = document.createElement('span');
                tagElem.classList.add('selected-tag');
                tagElem.textContent = label;

                document.body.appendChild(tagElem);
                const tagWidth = tagElem.offsetWidth;
                document.body.removeChild(tagElem);


                if (totalWidth + tagWidth <= maxWidth) {
                    const visibleTagElem = document.createElement('span');
                    visibleTagElem.classList.add('selected-tag');
                    visibleTagElem.textContent = label;
                    this.selectedTagsContainer.appendChild(visibleTagElem);
                    totalWidth += tagWidth;
                }
            });


            // 添加 selected-count 只在最后
            if (this.selectedTagsContainer.childElementCount < count) {

                const countElem = document.createElement('span');
                countElem.classList.add('selected-count');
                countElem.textContent = `+${count - this.selectedTagsContainer.childElementCount}`;

                // 计算 countElem 的宽度
                document.body.appendChild(countElem); // 暂时添加以获取宽度
                const countWidth = countElem.offsetWidth; // 获取 selected-count 的宽度
                document.body.removeChild(countElem); // 移除

                // 如果总宽度加上 countWidth 超过最大宽度，移除最后一个标签

                let flag = true;
                while (flag) {
                    const lastTag = this.selectedTagsContainer.lastChild; // 获取最后一个标签

                    if (totalWidth + countWidth > maxWidth && this.selectedTagsContainer.lastChild) {

                        totalWidth -= lastTag.offsetWidth;

                        this.selectedTagsContainer.removeChild(lastTag);


                        flag = false;
                    } else {
                        flag = false;
                    }

                }

                const countElem1 = document.createElement('span');
                countElem1.classList.add('selected-count');
                countElem1.textContent = `+${count - this.selectedTagsContainer.childElementCount}`;

                this.selectedTagsContainer.appendChild(countElem1);

            }

        }

        // this.selectedTagsContainer.style.display = 'flex';
        this.selectTrigger.appendChild(this.selectedTagsContainer);

        // 鼠标移出下拉框时延迟关闭
        this.selectContainer.addEventListener('mouseleave', () => {
            setTimeout(() => {
                // 如果鼠标已经不在当前下拉框内，则关闭它
                if (!this.selectContainer.matches(':hover') && !this.optionsContainer.matches(':hover')) {
                    this.selectContainer.classList.remove('open');
                }
            }, 300);  // 设置一个200毫秒的延迟（您可以根据需要调整这个时间）
        });
    }

    dispatchChangeEvent() {
        const selectedValues = this.selectedOptions.map(option => option.key);
        this.dispatchEvent(new CustomEvent('change', {detail: {value: selectedValues}}));
    }

    toggleDisabled(isDisabled) {
        if (isDisabled) {
            this.selectContainer.classList.add('disabled');
            this.selectTrigger.removeEventListener('click', this.toggleOptions.bind(this));
        } else {
            this.selectContainer.classList.remove('disabled');
            this.selectTrigger.addEventListener('click', this.toggleOptions.bind(this));
        }
    }

    getValue() {
        return this.selectedOptions.map(option => option.key);
    }

    setValue(values) {
        const checkboxes = this.optionsContainer.querySelectorAll('input[type="checkbox"]');
        this.selectedOptions = [];

        // 将 values 中的每个元素转换为字符串
        // const stringValues = values.map(value => value.toString());
        const stringValues = values;
        const isNumberArray = values.every(value => typeof value === 'number');

        checkboxes.forEach(checkbox => {

            const checkboxValue = isNumberArray ? parseInt(checkbox.value, 10) : checkbox.value;

            if (stringValues.includes(checkboxValue)) {
                checkbox.checked = true;
                this.selectedOptions.push({
                    key: checkboxValue,
                    label: checkbox.nextElementSibling.textContent
                });
            } else {
                checkbox.checked = false;
            }

        });

        this.updateSelectAllState();
        this.updateTriggerText(); // 更新触发文本
        this.dispatchChangeEvent();
    }


    connectedCallback() {
        document.addEventListener('click', this.closeOptions.bind(this));

// 支持直接 value 传值
        if (this.getAttribute('value') && this.getAttribute('value').trim() !== '') {
            this.setValue(this.getAttribute('value'));
        }

        if (!this.hasAttribute('data')) {
            this.setAttribute('data', JSON.stringify([]));
        }
    }

    closeOptions(event) {
        if (!this.shadow.contains(event.target)) {
            this.selectContainer.classList.remove('open');
        }
    }

    disconnectedCallback() {
        document.removeEventListener('click', this.closeOptions.bind(this));
    }
}

customElements.define('yz-multi-select', YzMultiSelect);


class YzCascader extends HTMLElement {
    static formAssociated = true;

    constructor() {
        super();
        this.shadow = this.attachShadow({mode: 'open'});
        this.internals = this.attachInternals();

        const style = document.createElement('style');
        style.textContent = `
      /* 样式保持一致 */
      ::-webkit-scrollbar {
          width: 6px;
      }

      ::-webkit-scrollbar-track {
          background: none;
      }

      ::-webkit-scrollbar-thumb {
          background: #DBE8F1;
          border-radius: 6px;
      }

      .cascader-container {
          position: relative;
          width: var(--cascader-width, 220px);
          height: var(--cascader-height, 32px);
          box-sizing: border-box;
          display: inline-flex;
          background: #FFFFFF;
          border-radius: 4px;
          border: 1px solid #D9D9D9;
          vertical-align: top;
          font-size: 14px;
      }

      .cascader-container.open {
          border: 1px solid #0B65A0;
      }

      .cascader-trigger {
          width: 100%;
          color: rgba(0,0,0,0.25); /* 默认提示信息颜色 */
          border-radius: 4px;
          padding: 4px 8px; 
          overflow: hidden;
          text-overflow: ellipsis; /* 使用省略号 */
          white-space: nowrap; /* 单行显示 */
          box-sizing: border-box; 
          height: auto; /* 高度由内容决定 */
          line-height: normal; /* 保持正常行高 */
          display: flex; 
          align-items: center; 
      }

      .cascader-container.open .cascader-options {
          display: flex;
      }

      .cascader-options {
          position: absolute;
          top: 110%;
          left: 0;
          display: none;
          background: #FFF;
          border: 1px solid #D9D9D9;
          box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
          z-index: 1000;
      }

      .cascader-column {
          width: var(--cascader-width, 220px);
          max-height: 300px;
          overflow-y: auto;
          border-right: 1px solid #EAEAEA;
      }


      .cascader-option {
          // padding: 8px 12px;
          cursor: pointer;
          line-height:28px;
          padding: 1px 8px;
          color: rgba(0,0,0,0.75);
          display: flex;
          align-items: center;
      }

      .cascader-option input {
          margin-right: 8px;
      }

      .cascader-option:hover {
          background: #F5F5F5;
      }

      .cascader-option.selected {
          font-weight: bold;
          color: #0B65A0;
          background: #F5F5F5;
      }

      .selected-tags {
          flex-wrap: wrap;
          display: flex;
          align-items: center;
      }

      .selected-tag {
          background-color: #F7F7F7;
          color: rgba(0,0,0,0.75);
          padding: 2px 6px;
          border-radius: 5px;
          font-size: 12px;
          margin-right: 4px;
          margin-bottom: 2px;
      }

      .selected-count {
          font-size: 12px;
          color: #0075ff;
      }
      input[type="checkbox"] {
          width: 16px; 
          height: 16px; 
          appearance: none; 
          background-color: white;
          border: 1px solid rgba(0,0,0,0.45); 
          border-radius: 4px; 
          cursor: pointer;
          position: relative;
      }

        input[type="checkbox"]:checked {
          background-color: white; /* 选中时背景为蓝色 */
      }

      input[type="checkbox"]:checked::after {
          content: "";
          position: absolute;
          top: 35%;
          left: 50%;
          width: 4px; /* 勾的宽度 */
          height: 8px; /* 勾的高度 */
          border: solid #0B65A0;
          border-width: 0 2px 2px 0;
          transform: translate(-50%, -50%) rotate(45deg); /* 勾的旋转角度 */
      }

      input[type="checkbox"].indeterminate {
          background-color: white; /* 确保背景颜色为白色 */
          border: 1px solid rgba(0,0,0,0.45); /* 边框颜色 */
          position: relative;
      }

      input[type="checkbox"].indeterminate::after {
          content: "";
          position: absolute;
          top: 50%;
          left: 2px;
          right: 2px;
          height: 2px; /* 直线的高度 */
          background-color: #0B65A0; /* 直线的颜色 */
          transform: translateY(-50%);
      }
      .iconPosition {
        color: #999999;
        position: absolute;
        top: 50%;
        right: 10px;
        transform: translateY(-50%);
        pointer-events: none;
      }
    .selected-background {
        background-color: rgba(11, 101, 160, 0.1); 
        border-radius: 4px; 
    }

    `;
        this.shadow.appendChild(style);

        // 引入外部 CSS 文件
        const linkIconfont = document.createElement('link');
        linkIconfont.rel = 'stylesheet';
        linkIconfont.type = 'text/css';
        linkIconfont.href = '/static/css/iconfont.css';
        this.shadow.appendChild(linkIconfont);

        this.container = document.createElement('div');
        this.container.classList.add('cascader-container');
        this.shadow.appendChild(this.container);

        this.trigger = document.createElement('div');
        this.trigger.classList.add('cascader-trigger');
        this.trigger.innerHTML = `<span>${this.getAttribute('placeholder') || "请选择"}</span>`;
        this.container.appendChild(this.trigger);

        this.optionsWrapper = document.createElement('div');
        this.optionsWrapper.classList.add('cascader-options');
        this.container.appendChild(this.optionsWrapper);

        // 创建小箭头
        this.iconElem = document.createElement('i');
        this.iconElem.classList.add('iconfont', 'icon-xiala', 'iconPosition');
        this.container.appendChild(this.iconElem);


        this.shadow.appendChild(this.container);

        this.selectedFirstLevel = null; // 一级选中
        this.selectedSecondLevel = []; // 二级多选
        this.levelData = [];

        this.trigger.addEventListener('click', (e) => this.toggleOptions(e)); //展开用点击绑定
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (name === 'data' && oldValue !== newValue) {
            this.levelData = JSON.parse(newValue) || [];
            this.renderOptions(0, this.levelData);
        }
    }

    toggleOptions(event) {
        event.stopPropagation();
        if (!this.container.classList.contains('open')) {
            this.container.classList.add('open');
        }
    }

    renderOptions(level, options) {
        // 清理当前级别及以下的所有列
        while (this.optionsWrapper.children.length > level) {
            this.optionsWrapper.removeChild(this.optionsWrapper.lastChild);
        }

        // 如果没有选项数据，则返回
        if (!options || options.length === 0) return;

        // 创建一个新的列容器
        const column = document.createElement('div');
        column.classList.add('cascader-column');

        // 如果是二级菜单，添加“全选”功能
        if (level === 1) {
            const allOptionElem = document.createElement('div');
            allOptionElem.classList.add('cascader-option');
            allOptionElem.innerHTML = `
            <input type="checkbox" class="select-all">
            <label>${STR_ALL}</label>
        `;
            const selectAllCheckbox = allOptionElem.querySelector('input');
            selectAllCheckbox.addEventListener('change', (e) => {
                e.stopPropagation();
                this.toggleAllOptions(e.target.checked, options);
            });

            column.appendChild(allOptionElem);
        }

        // 遍历选项并为每个选项创建一个元素
        options.forEach(option => {
            const optionElem = document.createElement('div');
            optionElem.classList.add('cascader-option');

            // 如果是二级菜单，显示多选框
            if (level === 1) {
                optionElem.innerHTML = `
                <input type="checkbox" value="${option.value}">
                <label>${option.label}</label>
            `;
                const checkbox = optionElem.querySelector('input');
                checkbox.checked = this.selectedSecondLevel.some(selected => selected.value === option.value);
                checkbox.addEventListener('change', (e) => {
                    e.stopPropagation(); // 阻止事件冒泡
                    this.toggleSingleOption(option, e.target.checked);
                });
            } else { // 如果是一级菜单，显示普通文本
                optionElem.textContent = option.label;

                // 如果当前选项是选中的一级选项，添加背景效果
                if (this.selectedFirstLevel === option.value) {
                    optionElem.classList.add('selected');
                    optionElem.classList.add('selected-background'); // 添加背景样式类
                }

                // 点击事件处理一级选项
                optionElem.addEventListener('click', (e) => {
                    e.stopPropagation(); // 阻止事件冒泡

                    // 移除之前选中项的背景样式
                    const prevSelected = this.optionsWrapper.querySelector('.selected-background');
                    if (prevSelected) {
                        prevSelected.classList.remove('selected-background');
                    }

                    // 更新选中状态并重新渲染
                    this.selectedFirstLevel = option.value;
                    this.selectedSecondLevel = [];
                    this.renderOptions(level + 1, option.children || []);
                    this.updateTriggerText();
                    this.dispatchChangeEvent();

                    // 给当前选中项添加背景样式
                    optionElem.classList.add('selected-background');
                });
            }

            column.appendChild(optionElem);
        });

        // 将新列添加到选项容器中
        this.optionsWrapper.appendChild(column);
    }


    toggleAllOptions(isChecked, options) {
        this.selectedSecondLevel = isChecked ? [...options] : [];
        const checkboxes = this.optionsWrapper.querySelectorAll('.cascader-column:last-child input[type="checkbox"]');
        checkboxes.forEach(checkbox => {
            checkbox.checked = isChecked;
        });
        this.updateTriggerText();
        this.dispatchChangeEvent();
    }

    toggleSingleOption(option, isChecked) {
        if (isChecked) {
            this.selectedSecondLevel.push(option);
        } else {
            this.selectedSecondLevel = this.selectedSecondLevel.filter(selected => selected.value !== option.value);
        }
        this.updateTriggerText();
        this.dispatchChangeEvent();
    }

    updateTriggerText() {
        // 清空触发器内容
        this.trigger.innerHTML = `<div class="selected-tags"></div>`;
        const tagsContainer = this.trigger.querySelector('.selected-tags');

        const maxWidth = parseFloat(getComputedStyle(this.container).width); // 获取容器的最大宽度
        let totalWidth = 0; // 当前标签总宽度
        let hiddenCount = 0; // 需要隐藏的标签数量

        // 获取一级选中的标签
        const firstLabel = this.levelData.find(item => item.value === this.selectedFirstLevel);
        if (firstLabel) {
            const firstTag = document.createElement('span');
            firstTag.classList.add('selected-tag');
            firstTag.setAttribute('level', '1');
            firstTag.textContent = firstLabel.label;
            firstTag.setAttribute('value', firstLabel.value);
            tagsContainer.appendChild(firstTag);
            totalWidth += firstTag.offsetWidth;
        }

        // 获取二级选中的标签
        const secondLabels = this.selectedSecondLevel;
        secondLabels.forEach((label, index) => {
            const tag = document.createElement('span');
            tag.classList.add('selected-tag');
            tag.textContent = label.label;
            tag.setAttribute('value', label.value);

            tagsContainer.appendChild(tag);

            setTimeout(() => { // 不延迟会报错
                tagsContainer.querySelectorAll('.selected-tag').forEach(tag => {
                    // 检查是否有 level 属性且值为 "1"
                    if (tag.getAttribute('level') === "1") {
                        // 从 DOM 中移除该元素
                        tag.remove();
                    }
                });
            }, 0);

            // 暂时将标签添加到文档中测量其宽度
            const tagWidth = tag.offsetWidth;

            // 判断是否超出容器宽度
            if (totalWidth + tagWidth > maxWidth) {
                tagsContainer.removeChild(tag); // 移除超出的标签
                hiddenCount++; // 记录超出数量
            } else {
                totalWidth += tagWidth; // 增加当前宽度
            }
        });

        // 如果有超出的项，添加“+数字”标签
        if (hiddenCount > 0) {
            const countElem = document.createElement('span');
            countElem.classList.add('selected-count');
            countElem.textContent = `+${hiddenCount}`;
            tagsContainer.appendChild(countElem);
        }
    }


    dispatchChangeEvent() {
        this.dispatchEvent(new CustomEvent('change', {
            detail: {
                firstLevel: this.selectedFirstLevel,
                secondLevel: this.selectedSecondLevel.map(item => item.value),
            }
        }));
    }

    connectedCallback() {

        this.container.addEventListener('mouseleave', () => {

            setTimeout(() => {
                if (!this.container.matches(':hover')) { //移除 open 类之前，它会先检查容器是否仍然被鼠标悬停
                    this.container.classList.remove('open');
                }
            }, 300);

        });

        if (this.hasAttribute('data')) {
            this.levelData = JSON.parse(this.getAttribute('data')) || [];
            this.renderOptions(0, this.levelData);
        }
    }


    allSelectionProcess() {

        const allSecondLevel = this.optionsWrapper.querySelectorAll('.cascader-column:last-child input[type="checkbox"]').length - 1;

        const selectedSecondLevel = this.selectedSecondLevel.length;

        const allCheckbox = this.optionsWrapper.querySelector('.select-all');

        if (selectedSecondLevel === allSecondLevel && allCheckbox) {
            allCheckbox.checked = true;
            allCheckbox.classList.remove('indeterminate');
        } else if (selectedSecondLevel > 0 && allCheckbox) {
            allCheckbox.checked = false;
            allCheckbox.classList.add('indeterminate');
        } else if (allCheckbox) {
            allCheckbox.checked = false;
            allCheckbox.classList.remove('indeterminate');
        }

    }

    getValue() {
        const values = [];

        // 获取一级选中的值
        if (this.selectedFirstLevel) {
            values.push(this.selectedFirstLevel);
        }

        // 获取二级选中的值
        if (this.selectedSecondLevel.length > 0) {
            this.selectedSecondLevel.forEach(option => {
                values.push(option.value);
            });
        }

        return values.join(','); // 使用逗号分隔返回
    }


    setValue(value) {
        // 解析传入的值并过滤掉空字符串
        const values = value.split(',').filter(Boolean);
        if (values.length === 0) return;

        // 清空现有的选中项
        this.selectedFirstLevel = null;
        this.selectedSecondLevel = [];

        // 处理一级选项（如果有）
        const firstValue = values[0];
        const firstOption = this.levelData.find(item => item.value === firstValue);
        if (firstOption) {
            this.selectedFirstLevel = firstOption.value;

            // 重新渲染该一级选项的二级数据
            this.renderOptions(1, firstOption.children || []);
            const firstLevelElems = this.optionsWrapper.querySelectorAll('.cascader-column:first-child .cascader-option');
            firstLevelElems.forEach(elem => {
                if (elem.textContent === firstOption.label) {
                    elem.classList.add('selected-background'); // 添加背景样式
                } else {
                    elem.classList.remove('selected-background'); // 移除非选中项样式
                }
            });
        }

        // 处理二级
        const secondValues = values.slice(1);
        if (secondValues.length > 0) {
            secondValues.forEach(val => {
                const option = this.findOptionByValue(this.levelData, val);
                if (option) {
                    // 将二级选项添加到 selectedSecondLevel
                    this.selectedSecondLevel.push(option);

                    // 在渲染时标记选中
                    const checkbox = this.optionsWrapper.querySelector(`input[value="${val}"]`);
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                }
            });
        }

        // 更新触发器显示
        this.updateTriggerText();

        // 触发 change 事件
        this.dispatchChangeEvent();
    }


    findOptionByValue(options, value) {
        for (let option of options) {
            if (option.value === value) {
                return option;
            }
            if (option.children) {
                const found = this.findOptionByValue(option.children, value);
                if (found) return found;
            }
        }
        return null;
    }

}

customElements.define('yz-cascader', YzCascader);