#!/bin/bash
dir=$(cd `dirname $0`;pwd)
bin_dir=/yzmm/gnb/agent



# install gnb_agent as service
ser_name=gnb_agent.service
ser_dir=/lib/systemd/system
ser_file=$ser_dir/$ser_name

systemctl stop $ser_name
systemctl disable $ser_name

if [ -f "$ser_file" ];then
    rm -f $ser_file
fi
systemctl daemon-reload
sleep 2

# 继承配置
"$dir/YamlTool" -c $bin_dir/conf.yaml -d conf.yaml
if [ -f "$bin_dir/lmt-conf/user.json" ];then
    echo "存在用户信息表，继承用户信息"
    cp $bin_dir/lmt-conf/user.json $dir/lmt-conf/
fi
##清空安装路径文件与备份路径
if [ -d "$bin_dir" ];then
    rm -rf $bin_dir/*
else
    mkdir -p $bin_dir
fi


##复制安装包文件至安装路径下
cd $dir

cp $dir/gnb_agent.arm64 $bin_dir/
cp $dir/*.xml $bin_dir/
cp $dir/*.yaml $bin_dir/
cp $dir/*.sh $bin_dir/
cp $dir/*.ini $bin_dir/
cp $dir/*.json $bin_dir/
cp $dir/id_rsa $bin_dir/
cp $dir/lmt_server.csr $bin_dir/
cp $dir/lmt_server.key $bin_dir/
cp $dir/lmt_server.crt $bin_dir/


cp $dir/$ser_name $bin_dir/
cp $dir/$ser_name $ser_dir/
cp -rf $dir/lmt-conf $bin_dir/
cp -rf $dir/static $bin_dir/


chmod 777 $bin_dir/gnb_agent.arm64
chmod 777 $bin_dir/*.sh


##安装基站配置升级继承工具
cp $dir/GnbUpgrade $bin_dir/
chmod 777 $bin_dir/GnbUpgrade

##安装agent配置继承工具
cp $dir/YamlTool $bin_dir/
chmod 777 $bin_dir/YamlTool

# 安装sysrepoCfgTool
echo "安装ai基站后台服务"
cp $dir/sysrepoCfgTool-v2.tar $bin_dir/
tar vfx sysrepoCfgTool-v2.tar
cd sysrepoCfgTool-v2
./install.sh 1

cp $bin_dir/$ser_name $ser_dir


systemctl daemon-reload
systemctl enable $ser_name
echo "gnb_agent.service will be started after 5 seconds..."
sleep 5
systemctl start $ser_name
systemctl status $ser_name
