#!/bin/bash
#sysrepo数据库配置安装
SCRIPT_PATH="/yzmm/agent_shell_script"
INSTALL_PATH="/yzmm/gnb"                                        #协议栈软件执行路径
SYSREPO_BACKUP_PATH="/yzmm/gnb/sysrepo_bak"                         #协议栈软件sysrepo配置文件备份路径

# GNB Sysrepo CFG Path
CU_SYSREPO_PATH="$INSTALL_PATH/cu/config"                          #CU软件sysrepo配置文件相对路径
DU_SYSREPO_PATH="$INSTALL_PATH/du/config"            #DU软件sysrepo配置文件相对路径
# PHY_SYSREPO_PATH="${INSTALL_PATH}/phy/config"                                    #PHY软件sysrepo配置文件相对路径

#继承配置
UPG_XML_FILE_PATH="/tmp/yzmm_inheritXmlData"                         #继承后的xml文件绝对路径
CU_UPG_RULE_FILE_PATH=$INSTALL_PATH/cu/upgrule_cu.yaml         #CU软件继承配置规则文件绝对路径
DU_UPG_RULE_FILE_PATH=$INSTALL_PATH/du/upgrule_du.yaml         #DU软件继承配置规则文件绝对路径
PHY_UPG_RULE_FILE_PATH=$INSTALL_PATH/phy/upgrule_ru.yaml       #PHY软件继承配置规则文件绝对路径
GNBUPG_TOOL_FILE_PATH=$SCRIPT_PATH/"GnbUpgrade"  #配置数据继承安装工具文件路径

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}


# $1:yang name, $2:0,不导入配置，1，导入配置
InstallYangFile(){
	find "$1" -type f -name "*.yang" | while IFS= read -r file; do
		filename=$(basename "$file")
		filename_without_extension="${filename%.*}"
		# 捕捉错误，失败退出
		#安装新YANG
		sysrepoctl -i "${1}/${filename}"
		echo "安装${1}/${filename} 成功"
		if [ $2 == 1 ];then
			#导入当前xml
			sysrepocfg --import="${1}/${filename_without_extension}".xml --module "$filename_without_extension" -d running
			echo "导入${1}/${filename_without_extension}.xml成功"
			# 备份到启动库中
			sysrepocfg --import="${1}/${filename_without_extension}.xml" --module "$filename_without_extension" -d startup
		fi
	done 
}

# 回退安装sysrepo配置
FallbackYangFile(){
	find "$1" -type f -name "*.yang" | while IFS= read -r file; do  
		filename=$(basename "$file")
		filename_without_extension="${filename%.*}"
		if [ ! -f "${SYSREPO_BACKUP_PATH}/${filename_without_extension}.xml" ];then
			echo "未找到${SYSREPO_BACKUP_PATH}/${filename_without_extension}.xml 备份文件"
			exit 10
		fi
		#安装新YANG
		sysrepoctl -i ${1}/${filename}		
		echo "回退安装${1}/${filename}成功"
		sysrepoctl -l
		#导入当前xml
		sysrepocfg --import="${SYSREPO_BACKUP_PATH}/${filename_without_extension}.xml" --module "$filename_without_extension" -d running
		# 备份到启动库中
		sysrepocfg --import="${SYSREPO_BACKUP_PATH}/${filename_without_extension}.xml" --module "$filename_without_extension" -d startup
		echo "回退导入'sysrepocfg --import="${SYSREPO_BACKUP_PATH}/${filename_without_extension}.xml" --module "$filename_without_extension" -d running'成功"
	done 
}

if [ -z "$1" ];then
	echo "请输入是否继承配置:0:不继承安装,1:继承安装,2:回退安装"
	exit 10
fi

INSTALL_TYPE=$1  #是否继承配置,0:不继承，1：继承,2:回退安装

if (( $INSTALL_TYPE < 0 )) || (( $INSTALL_TYPE > 2 ));then
	echo "无效的继承配置标识符 ${INSTALL_TYPE}"
	exit 10
fi

if (( $INSTALL_TYPE > 0 )) && [ ! -d $SYSREPO_BACKUP_PATH ];then
	echo "不存在备份目录,继承配置、回退配置失败"
	exit 10
fi

#配置导入
if [ $INSTALL_TYPE -eq 2 ];then
	echo "回退安装Sysrepo"
	FallbackYangFile ${CU_SYSREPO_PATH} 1
	FallbackYangFile ${DU_SYSREPO_PATH} 1
	else
	echo "不继承配置安装Sysrepo"
	InstallYangFile ${CU_SYSREPO_PATH} 1
	InstallYangFile ${DU_SYSREPO_PATH} 1
fi



echo "sysrepo配置安装完成"
exit 0
