#!/bin/bash
# 定义路径变量
INSTALL_PATH="/yzmm/gnb"                                            #协议栈软件安装路径
BACKUP_DIR="/yzmm/gnb_bak"                                          # 协议栈软件备份路径
CU_SYSREPO_PATH="${INSTALL_PATH}/cu/config"                         # CU 软件 sysrepo 配置文件相对路径
DU_SYSREPO_PATH="${INSTALL_PATH}/du/config"                         # DU 软件 sysrepo 配置文件相对路径
JSON_CFG_PATH="${INSTALL_PATH}/phy/resources"                       # PHY 软件 resources 配置文件相对路径
SYSREPO_BACKUP_PATH="/yzmm/gnb/sysrepo_bak/"                        # 协议栈软件 sysrepo 配置文件备份路径

# 安全清除目录下的所有子文件
clearFiles(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1/*
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除目录
removeDir(){
    if [ -d $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -rf $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的目录"
    fi
}

# 安全清除文件
removeFile(){
    if [ -f $1 ];then
        if [[ $1 == "/yzmm"* ]] ||
        [[ $1 == "/home"* ]] || 
        [[ $1 == "/lib/systemd/system"* ]] || 
        [[ $1 == "/etc/systemd/system"* ]];then
            rm -f $1
        else
            echo "Err:超范围清除 $1"
        fi
    else
        echo "$1 无效的文件"
    fi
}

cpIniCfgFile(){
    find "$1" -type f \( -name "*.txt" -o -name "*.ini" \) | while IFS= read -r file; do
        cp $file $SYSREPO_BACKUP_PATH
        echo "$file $SYSREPO_BACKUP_PATH"
    done
}

cpJsonCfgFile(){
    for fileName in "ucp_rfic_cfg_evmt4.json" "ucp_trx_gpioCfg_evmt4.json"; do
        srcFile="$1/$fileName"
        if [ -f "$srcFile" ]; then
            cp "$srcFile" "$SYSREPO_BACKUP_PATH"
            echo "备份 JSON: $srcFile -> $SYSREPO_BACKUP_PATH"
        else
            echo "文件不存在: $srcFile"
        fi
    done
}

# 备份当前配置
FallbackCurSysrepoCfg(){
    # 导出备份当前配置
    sysrepocfg -d running -m "gnb-cu-main" -X > "${SYSREPO_BACKUP_PATH}/gnb-cu-main.xml"
    sysrepocfg -d running -m "gnb-cu-log" -X > "${SYSREPO_BACKUP_PATH}/gnb-cu-log.xml"
    sysrepocfg -d running -m "gnb-cu-amf" -X > "${SYSREPO_BACKUP_PATH}/gnb-cu-amf.xml"
    sysrepocfg -d running -m "gnb-cu-dulist" -X > "${SYSREPO_BACKUP_PATH}/gnb-cu-dulist.xml"
    sysrepocfg -d running -m "gnb-du" -X > "${SYSREPO_BACKUP_PATH}/gnb-du.xml"
    sysrepocfg -d running -m "du-cell" -X > "${SYSREPO_BACKUP_PATH}/du-cell.xml"
    cpIniCfgFile $CU_SYSREPO_PATH
    cpIniCfgFile $DU_SYSREPO_PATH
    cpJsonCfgFile $JSON_CFG_PATH
    ls -la $SYSREPO_BACKUP_PATH
    echo "备份配置完成"
}

# 定义卸载 YANG 文件的函数
UninstallYangFile() {
    find "$1" -type f -name "*.yang" | while IFS= read -r file; do
        filename=$(basename "$file")
        filename_without_extension="${filename%.*}"
        # 卸载当前 YANG 文件
        sysrepoctl -u "$filename_without_extension"
        echo "$filename 删除成功"
    done
}

if [ -z $1 ];then
    echo "请输入是否备份sysrepo协议栈配置,0:不备份，1：备份"
    exit 1
fi

IS_BACKUP=$1 #是否备份sysrepo配置

if [ $IS_BACKUP != 1 ] && [ $IS_BACKUP != 0 ];then
    echo "无效的卸载sysrepo是否备份参数"
    exit 1
fi

# 备份目录存在则清空，不存在则创建
if [ $IS_BACKUP == 1 ];then
    mkdir -p $SYSREPO_BACKUP_PATH
    clearFiles ${SYSREPO_BACKUP_PATH}
    # 备份当前配置
    FallbackCurSysrepoCfg
fi


# 执行 YANG 文件的备份与卸载操作
UninstallYangFile ${CU_SYSREPO_PATH}
UninstallYangFile ${DU_SYSREPO_PATH}

# 输出完成信息
echo "卸载 SYSREPO 配置完成"
exit 0



