#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sysrepo.h"


struct SchemaType {
    char name[256];
    char ns[256];
    char *data;
};
void get_schemas(sr_conn_ctx_t* conn){
    struct ly_ctx *ctx = NULL;
    struct lyd_node* schemas = NULL;
    struct lyd_node* root = NULL;
    const struct lys_module *mod;

    struct SchemaType arr[256];
    

    uint32_t i,j;
    ctx = (struct ly_ctx*)sr_get_context(conn);
    root = lyd_new_path(NULL, ctx, "/ietf-netconf-monitoring:netconf-state", NULL, 0, 0);
    if (!root) {
        perror("error");
    }
    schemas = lyd_new(root, NULL, "schemas");
    i = 0;
    while((mod=ly_ctx_get_module_iter(ctx, &i))){
        strcpy(arr[i-1].name,mod->name);
        strcpy(arr[i-1].ns,lys_main_module(mod)->ns);
        //lys_print_mem(&arr[i-1].data, mod, LYS_OUT_YANG, NULL, 0, 0);
    }

    // printf
    for(j=0;j<i;j++){
        printf("%s\t%s\n",arr[j].name, arr[j].ns);
        if(arr[j].data){
            printf("%s\n", arr[j].data);
        }
    }
}

void get_inventory(sr_session_ctx_t *session, const char *xpath){
    struct lyd_node *cfg = NULL;
    int rc = SR_ERR_OK;
    char *data = NULL;
    char *data1 = NULL;
    rc = sr_get_data(session, xpath, 0, 0, 0, &cfg);
    if(rc==SR_ERR_OK){
        lyd_print_mem(&data, cfg, LYD_JSON, 0);
        lyd_print_mem(&data1, cfg, LYD_XML, 0);
        printf("%s\n",data);
        printf("%s\n",data1);
    }
}

int main (int argc, char **argv) {
    
    sr_conn_ctx_t *connection = NULL;
    sr_session_ctx_t *session = NULL;
    int rc = SR_ERR_OK;
    // turn logging on
    sr_log_stderr(SR_LL_DBG);

    // connect to sysrepo
    rc = sr_connect(SR_CONN_DEFAULT, &connection);
    if(rc != SR_ERR_OK){
        // TODO 
    } else {
        printf("connect to sysrepo successfully!\n");
    }

    // start session
    rc = sr_session_start(connection, SR_DS_RUNNING, &session);
    if (rc!=SR_ERR_OK) {
    } else {
        printf("start session successfully!\n");
    }

    // schemas
    get_schemas(connection);

    // inventory
    get_inventory(session, "/du-cell:*");

    printf("free value\n");
    // stop session and free resources
    rc = sr_session_stop(session);
    if(rc!=SR_ERR_OK) printf("close session error! code=%d\n", rc);
    else printf("close session successfully!\n");
    // close connection
    rc = sr_disconnect(connection);
    if(rc!=SR_ERR_OK) printf("disconnect error! code=%d\n",rc);
    else printf("disconnect successfully!\n");

    printf("exit()\n");
    return 1;
}
