#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include "sysrepo.h"
#include "sysrepo/values.h"

volatile int exit_application = 0;

unsigned int rand_btw(unsigned int min,unsigned int max){
    return rand()%(max-min) + min;
}

static void
sigint_handler(int signum)
{
    (void)signum;
    exit_application = 1;   
}

int alarm_send(sr_session_ctx_t * session, unsigned int code , char* data) {
    int rc = SR_ERR_OK;
    sr_val_t *notify = NULL;
    sr_val_t leaf[2];
    memset(leaf, 0, sizeof(leaf)); // don't miss it..

    // fill leaf
    leaf[0].xpath = strdup("/yzmm-rpc-notify:alarm/code");
    leaf[0].type = SR_UINT32_T;
    leaf[0].data.uint32_val = code;

    leaf[1].xpath = strdup("/yzmm-rpc-notify:alarm/data");
    leaf[1].type = SR_STRING_T;
    leaf[1].data.string_val = strdup(data);
    // make notify data
    rc = sr_dup_values(leaf, 2, &notify);
    if (rc!=SR_ERR_OK) return rc;
    
    // send
    rc = sr_event_notif_send(session,"/yzmm-rpc-notify:alarm",notify,2);
    if (rc!=SR_ERR_OK) return rc;

    return SR_ERR_OK;
}

int main(int argv, char **arvc)
{
    sr_conn_ctx_t *connection = NULL;
    sr_session_ctx_t *session = NULL;
    sr_subscription_ctx_t *subscription = NULL;
    
    sr_log_stderr(SR_LL_DBG);

    // step 1. connect to sysrepo and start a session.
    if(SR_ERR_OK!=sr_connect(0,&connection)){
        exit(0);
    }
    if(SR_ERR_OK!=sr_session_start(connection, SR_DS_RUNNING, &session)){
        exit(0);
    }
    
   // step 2. send alarm when sth wrong.

    for(;;){
        sleep(rand_btw(1,5));
        alarm_send(session, rand_btw(0x10000001,0x1000ffff), "{\"cell\":\"1\",\"ue\":\"2\"}");
    }

    /* loop until ctrl-c is pressed / SIGINT is received */
    signal(SIGINT, sigint_handler);
    signal(SIGPIPE, SIG_IGN);

    return 1;
}
