#include <stdio.h>
#include <stdlib.h>

#include "sysrepo.h"


struct str_gnb_config_sa_sctp_config_params {
    int num_outbound_streams;
    int max_inbound_streams;
    int max_init_attempts;
    int hb_interval_ms;
    int max_path_retx;
};

int main (int argc, char **argv) {
    
    sr_conn_ctx_t *connection = NULL;
    sr_session_ctx_t *session = NULL;
    int rc = SR_ERR_OK;
    struct str_gnb_config_sa_sctp_config_params config; 
    sr_val_t *value = NULL;
    // turn logging on
    sr_log_stderr(SR_LL_DBG);

    // connect to sysrepo
    rc = sr_connect(SR_CONN_DEFAULT, &connection);
    if(rc != SR_ERR_OK){
        // TODO 
    } else {
        printf("connect to sysrepo successfully!\n");
    }

    // start session
    rc = sr_session_start(connection, SR_DS_RUNNING, &session);
    if (rc!=SR_ERR_OK) {
    } else {
        printf("start session successfully!\n");
    }

    // get item
    rc = sr_get_item(session, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/NUM_OUTBOUND_STREAMS", 0, &value);
    if(rc!=SR_ERR_OK){
       // TODO 
    }else{
        config.num_outbound_streams = value->data.int32_val;
        printf("get config successfully - /gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/NUM_OUTBOUND_STREAMS = %d\n", config.num_outbound_streams);
    }

    // get itme
    rc = sr_get_item(session, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_INBOUND_STREAMS", 0, &value);
    if(rc!=SR_ERR_OK){
       // TODO 
    }else{
        config.max_inbound_streams = value->data.int32_val;
        printf("get config successfully - /gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_INBOUND_STREAMS = %d\n", config.max_inbound_streams);
    }

    // get item
    rc = sr_get_item(session, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_INIT_ATTEMPTS", 0, &value);
    if(rc!=SR_ERR_OK){
       // TODO 
    }else{
        config.max_init_attempts = value->data.int32_val;
        printf("get config successfully - /gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_INIT_ATTEMPTS = %d\n", config.max_init_attempts);
    }

    // get item
    rc = sr_get_item(session, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/HB_INTERVAL_MS", 0, &value);
    if(rc!=SR_ERR_OK){
       // TODO 
    }else{
        config.hb_interval_ms = value->data.int32_val;
        printf("get config successfully - /gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/HB_INTERVAL_MS = %d\n", config.hb_interval_ms);
    }
    // get item
    rc = sr_get_item(session, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_PATH_RETX", 0, &value);
    if(rc!=SR_ERR_OK){
       // TODO 
    }else{
        config.max_path_retx = value->data.int32_val;
        printf("get config successfully - /gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_PATH_RETX = %d\n", config.max_path_retx);
    }

    // free value memory
    sr_free_val(value);
    printf("free value\n");
    // stop session and free resources
    rc = sr_session_stop(session);
    if(rc!=SR_ERR_OK) printf("close session error! code=%d\n", rc);
    else printf("close session successfully!\n");
    // close connection
    rc = sr_disconnect(connection);
    if(rc!=SR_ERR_OK) printf("disconnect error! code=%d\n",rc);
    else printf("disconnect successfully!\n");

    printf("exit()\n");
    return 1;
}
