#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "sysrepo.h"

volatile int exit_application = 0;


static void
sigint_handler(int signum)
{
    (void)signum;
    exit_application = 1;   
}

int module_chg_cb(sr_session_ctx_t *session, const char *module_name, const char *xpath, sr_event_t event, uint32_t request_id, void *private_data)
{
    printf("\n\n ========== NOTIFICATION \"%s\" RECEIVED =======================\n\n", xpath);
    sr_change_iter_t *it = NULL; // iterator for traversing changed item.

    if(SR_ERR_OK==sr_get_changes_iter(session,"/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/*",&it)) {

        if(event == SR_EV_CHANGE) {
            // 1st event
            sr_change_oper_t oper;
            sr_val_t *ov = NULL, *nv = NULL; // old value and new value.
            while( SR_ERR_OK == sr_get_change_next(session, it, &oper, &ov, &nv) ) {
                                
                // params checking
                if(0==strcmp(ov->xpath, "/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_INIT_ATTEMPTS")) {
                    if(nv->data.int32_val > 10) {
                        printf("MAX_INIT_ATTEMPTS %d -> %d [ERROR]\n", ov->data.int32_val, nv->data.int32_val);
                        return SR_ERR_INVAL_ARG;
                    }
                }else if (0==strcmp(ov->xpath,"/gnb-config-sa:GNB-CONFIG-SA/SCTP_CONFIG_PARAMS/MAX_PATH_RETX")){
                    if(nv->data.int32_val > 5) {
                        printf("MAX_PATH_RETX %d -> %d [ERROR]\n", ov->data.int32_val, nv->data.int32_val);
                        return SR_ERR_INVAL_ARG;
                    }
                    
                }
                ov = NULL;
                nv = NULL;
            }
            return SR_ERR_OK; 
        } else if (event == SR_EV_DONE) {
            // 2st event, modify your variables
            sr_change_oper_t oper;
            sr_val_t *ov = NULL, *nv = NULL; // old value and new value.
            while( SR_ERR_OK == sr_get_change_next(session, it, &oper, &ov, &nv) ) {
                                
                // config sys.
                printf("%s changed from %d to %d \n", ov->xpath, ov->data.int32_val, nv->data.int32_val);
                ov = NULL;
                nv = NULL;
            }
            return SR_ERR_INVAL_ARG;
        }
    }
    return SR_ERR_NOT_FOUND;
}

int main(int argv, char **arvc)
{
    sr_conn_ctx_t *connection = NULL;
    sr_session_ctx_t *session = NULL;
    sr_subscription_ctx_t *subscription = NULL;

    // log on
    sr_log_stderr(SR_LL_DBG);

    // connect
    if(SR_ERR_OK!=sr_connect(0,&connection)){
        exit(0);
    }
    // session
    if(SR_ERR_OK!=sr_session_start(connection, SR_DS_RUNNING, &session)){
        exit(0);
    }

    // subscribe to  gnb-config-sa:GNB-CONFIG-SA, any changes within this container will call module_chg_cb callback.
    if(SR_ERR_OK!=sr_module_change_subscribe(session, "gnb-config-sa","/gnb-config-sa:GNB-CONFIG-SA", module_chg_cb, NULL, 0, SR_SUBSCR_NO_THREAD, &subscription)){
        exit(0);
    }
    
    printf("\n\n ========== LISTENING FOR NOTIFICATIONS ==========\n\n");

    /* loop until ctrl-c is pressed / SIGINT is received */
    signal(SIGINT, sigint_handler);
    signal(SIGPIPE, SIG_IGN);
    while (!exit_application) {
        //sleep(1000);
        sr_process_events(subscription,session,0);
    }

    return 1;
}
