#include <string.h>
#include <inttypes.h>
#include "sr.h"

void sprintf_val(char **dst, const sr_val_t *val){
    char *ret = NULL;
    if(NULL==val){
        return;
    }
    switch(val->type){
    case SR_CONTAINER_T:
    case SR_CONTAINER_PRESENCE_T:
        ret = (char*)malloc(32);
        sprintf(ret, "(container)\n");
        break;
    case SR_LIST_T:
        ret = (char*)malloc(32);
        sprintf(ret, "(list instance)\n");
        break;
    case SR_STRING_T:
        ret = (char*)malloc(strlen(val->data.string_val)*2);
        sprintf(ret, "%s", val->data.string_val);
        break;
    case SR_BOOL_T:
        ret = (char*)malloc(16);
        sprintf(ret, "%s", val->data.bool_val ? "true" : "false");
        break;
    case SR_DECIMAL64_T:
        ret = (char*)malloc(128);
        sprintf(ret, "%g", val->data.decimal64_val);
        break;
    case SR_INT8_T:
        ret = (char*)malloc(16);
        sprintf(ret, "%"PRId8, val->data.int8_val);
        break;
    case SR_INT16_T:
        ret = (char*)malloc(32);
        sprintf(ret, "%"PRId16, val->data.int16_val);
        break;
    case SR_INT32_T:
        ret = (char*)malloc(64);
        sprintf(ret, "%"PRId32, val->data.int32_val);
        break;
    case SR_INT64_T:
        ret = (char*)malloc(128);
        sprintf(ret, "%"PRId64, val->data.int64_val);
        break;
    case SR_UINT8_T:
        ret = (char*)malloc(16);
        sprintf(ret, "%"PRIu8, val->data.uint8_val);
        break;
    case SR_UINT16_T:
        ret = (char*)malloc(32);
        sprintf(ret, "%"PRIu16, val->data.uint16_val);
        break;
    case SR_UINT32_T:
        ret = (char*)malloc(64);
        sprintf(ret, "%"PRIu32, val->data.uint32_val);
        break;
    case SR_UINT64_T:
        ret = (char*)malloc(128);
        sprintf(ret, "%"PRIu64, val->data.uint64_val);
        break;
    case SR_IDENTITYREF_T:
        ret = (char*)malloc(2*strlen(val->data.identityref_val));
        sprintf(ret, "%s", val->data.identityref_val);
        break;
    case SR_INSTANCEID_T:
        ret = (char*)malloc(2*strlen(val->data.instanceid_val));
        sprintf(ret, "%s", val->data.instanceid_val);
        break;
    case SR_BITS_T:
        ret = (char*)malloc(2*strlen(val->data.bits_val));
        sprintf(ret, "%s", val->data.bits_val);
        break;
    case SR_BINARY_T:
        ret = (char*)malloc(2*strlen(val->data.binary_val));
        sprintf(ret, "%s", val->data.binary_val);
        break;
    case SR_ENUM_T:
        ret = (char*)malloc(2*strlen(val->data.enum_val));
        sprintf(ret, "%s", val->data.enum_val);
        break;
    case SR_LEAF_EMPTY_T:
        ret = (char*)malloc(64);
        sprintf(ret, "(empty leaf)\n");
        break;
    default:
        ret = (char*)malloc(64);
        sprintf(ret, "(unprintable)\n");
        break;
    }
    *dst = ret;
    return;
}

int GetSchemas(sr_conn_ctx_t *conn,schema_t **arr, int *len){
    int rc = SR_ERR_OK;
    struct ly_ctx *ctx = NULL;
    struct lyd_node *schemas = NULL, *root=NULL;
    schema_t *ptr = NULL;
    const struct lys_module *mod = NULL;
    int i, j;
    ctx = (struct ly_ctx*) sr_get_context(conn);
    root = lyd_new_path(NULL, ctx, "/ietf-netconf-monitoring:netconf-state", NULL, 0, 0);
    if(root==NULL){
        return -1;
    }
    schemas = lyd_new(root, NULL, "schemas");
    i=0;
    while((mod=ly_ctx_get_module_iter(ctx,&i))){
        ;    
    }
    *len = i;
    ptr = (schema_t*)malloc(i*sizeof(schema_t));
    i=0;
    while((mod=ly_ctx_get_module_iter(ctx,&i))){
        ptr[i-1].name = (char*)malloc(strlen(mod->name));
        ptr[i-1].ns = (char*)malloc(strlen(lys_main_module(mod)->ns));
        strcpy(ptr[i-1].name, mod->name);
        strcpy(ptr[i-1].ns, lys_main_module(mod)->ns);
        lys_print_mem(&ptr[i-1].yang, mod, LYS_OUT_YANG, NULL, 0, 0);
        lys_print_mem(&ptr[i-1].json, mod, LYS_OUT_JSON, NULL, 0, 0);
    }
    *arr = ptr;
    return SR_ERR_OK;
}
void ReleaseSchemasMem(schema_t** ptr, int len){
if(NULL!=*ptr){
        int i;
        schema_t *p = (schema_t*)(*ptr);
        for(i=0;i<len;i++){
            if(p[i].name) free(p[i].name);
            if(p[i].ns) free(p[i].ns);
            if(p[i].yang) free(p[i].yang);
            if(p[i].json) free(p[i].json);
        }
        free(p);
        *ptr = NULL;
    }
}
int GetInventoryByIdentifier(sr_session_ctx_t* session, char *id, char **json, char **xml) {
    char xpath[256];
    int rc = SR_ERR_OK;
    struct lyd_node *cfg = NULL;
    sprintf(xpath, "/%s:*",id);
    sr_log_stderr(SR_LL_DBG);
    rc = sr_get_data(session, xpath, 0, 0, 0, &cfg);
    if(rc!=SR_ERR_OK){
        return rc;
    }
    lyd_print_mem(json, cfg, LYD_JSON, 0);
    lyd_print_mem(xml, cfg, LYD_XML, 0);
    lyd_free(cfg);
    return SR_ERR_OK;
}
int GetValueByXpath(sr_session_ctx_t *session, const char *path, char **val){
    sr_val_t *v=NULL;
    int rc = sr_get_item(session, path, 0, &v);
    sprintf_val(val, v);
    return rc;
}
int SetValueByXpath(sr_session_ctx_t *session, char *path, char *val){
    int rc = sr_set_item_str(session, path, val, NULL, 0);
    if(rc != SR_ERR_OK){
        printf("set value by xpath 1 %d\n",rc);
        return rc;
    }
    rc = sr_apply_changes(session, 0, 0);
    if(rc != SR_ERR_OK){
        printf("set value by xpath 2 %d\n",rc);
        sr_discard_changes(session);
    }
    return rc;
}
int DiscardChanges(sr_session_ctx_t *session){
    return sr_discard_changes(session);
}
int ApplyChanges(sr_session_ctx_t *session){
    return sr_apply_changes(session, 0, 0);
}
int ReplaceChanges(
    sr_conn_ctx_t *conn,
    sr_session_ctx_t *session,
    const char* data, 
    LYD_FORMAT format,
    const char *module)
{
    struct ly_ctx *ctx = (struct ly_ctx*)sr_get_context(conn);
    if(ctx){
        struct lyd_node* root = NULL;
        if(format == LYD_XML){
            root = lyd_parse_mem(ctx, data, LYD_XML, LYD_OPT_CONFIG | LYD_OPT_STRICT);
        }else if(format==LYD_JSON){
            root = lyd_parse_mem(ctx, data, LYD_JSON, LYD_OPT_CONFIG | LYD_OPT_STRICT);
        }else {
            return SR_ERR_UNSUPPORTED;
        }
        if(root){ 
            int rc = sr_replace_config(session, module, root, 0, 0); 
            //lyd_free(root);
            return rc;
        }
        return SR_ERR_LY;
    }
    return SR_ERR_LY;
}
int Lock(sr_session_ctx_t* session, const char *module){
   sr_log_stderr(SR_LL_DBG);
   return sr_lock(session, module);
}
int UnLock(sr_session_ctx_t* session, const char *module){
    return sr_unlock(session, module);
}
int CopyConfig(sr_session_ctx_t    *session, const char *module,sr_datastore_t src){
    return sr_copy_config(session,module,src,0,0);
}
int     sr_event_notif_subscribe_n(   sr_session_ctx_t *  session,
                                char *    module_name,
                                char *    xpath,
                                time_t  start_time,
                                time_t  stop_time,
                                sr_event_notif_cb_n   callback,
                                void *  private_data,
                                sr_subscr_options_t     opts,
                                sr_subscription_ctx_t **    subscription)
{
    return sr_event_notif_subscribe(session, module_name,xpath,start_time,stop_time,(sr_event_notif_cb)callback,private_data,opts,subscription);
}
int ExtraValueAsString(sr_val_t* val, char **out){
    if(!val) return SR_ERR_INVAL_ARG;
    sprintf_val(out,val);
    return SR_ERR_OK;
}
