#include <stdio.h>
#include <stdlib.h>
#include <sysrepo.h>
typedef struct {
    char *name;
    char *ns;
    char *yang;
    char *json;
}schema_t;
typedef void(* sr_event_notif_cb_n) (sr_session_ctx_t *session, sr_ev_notif_type_t notif_type, char *xpath, sr_val_t *values, size_t values_cnt, time_t timestamp, void *private_data);

int     ExtraValueAsString(sr_val_t* val, char **out);
int     GetSchemas(sr_conn_ctx_t *, schema_t**, int*);
void    ReleaseSchemasMem(schema_t** ptr, int len);
int     GetInventoryByIdentifier(sr_session_ctx_t* session, char *id, char **retJson, char **retXml);
int     SetValueByXpath(sr_session_ctx_t *session, char *path, char *val);
int     GetValueByXpath(sr_session_ctx_t *session, const char *path, char **val);
int     ReplaceChanges(sr_conn_ctx_t *conn,sr_session_ctx_t *session,const char *data, LYD_FORMAT format ,const char *module);
int     ApplyChanges(sr_session_ctx_t *session);
int     Lock(sr_session_ctx_t* session, const char *module);
int     UnLock(sr_session_ctx_t* session, const char *module);
int     CopyConfig(sr_session_ctx_t *session,const char *module,sr_datastore_t src);
int     sr_event_notif_subscribe_n(   sr_session_ctx_t *  session,
                                char *    module_name,
                                char *    xpath,
                                time_t  start_time,
                                time_t  stop_time,
                                sr_event_notif_cb_n   callback,
                                void *  private_data,
                                sr_subscr_options_t     opts,
                                sr_subscription_ctx_t **    subscription);
int     DiscardChanges(sr_session_ctx_t *session);


