#include "sr.h"
#include <string.h>
void tc_get_item(sr_session_ctx_t* session, const char *xpath) {
    //char *xpath = "/du-cell:DU-CELL/BASE/NR_UE_PTRS_ENABLE";
    char *val = NULL;
    int rc = SR_ERR_OK;
    if(!xpath) return;
    rc = GetValueByXpath(session,xpath, &val);
    printf("tc_get_item rc=%d val=%s\n",rc, val);
    if(val) free(val);
    return;
}
void tc_get_schemas(sr_conn_ctx_t* conn){
    schema_t* sch = NULL;
    int len = 0;
    int i;
    GetSchemas(conn, &sch, &len);
    for(i=0;i<len;i++){
       if(0==strcmp(sch[i].name,"gnb-cu-dulist"))  {
        printf("%s\n",sch[i].yang);
        printf("%s\n",sch[i].json);
        
       }
    }
}

void tc_update_inventory(sr_conn_ctx_t* conn, sr_session_ctx_t* session){
    char *xml = "<DU-CELL xmlns=\"http://www.yunzhiruantong.com/yzrt/yzmm/du-cell\"><BASE><NR_PCI>1</NR_PCI></BASE></DU-CELL>";
    char *xml1 = "<DU-CELL><BASE><NR_PCI>1</NR_PCI></BASE></DU-CELL>";
        const char *xmlin = "<cont1 xmlns=\"urn:all\">"
                                  "<leaf3>-1</leaf3>"
                                                            "<list1><leaf18>aaa</leaf18></list1>"
                                                                                      "<list1><leaf19>123</leaf19><leaf18>bbb</leaf18></list1>"
                                                                                                              "</cont1>";
    char *module = "du-cell";
    int rc = ReplaceChanges(conn,session, xml, LYD_XML, module);
    printf("rc=%d\n",rc);
}
int main(int argc, char **argv){
    sr_conn_ctx_t *conn = NULL;
    sr_session_ctx_t *session = NULL;
    int rc = SR_ERR_OK;
    char *xpath = NULL;
    // args
    if(argc==2){
        xpath = argv[1];
    } 

    // connect
    rc = sr_connect(SR_CONN_DEFAULT, &conn);
    if(rc!=SR_ERR_OK){
        printf("connect err rc=%d\n",rc);
    }
    printf("connected !!!\n");

    // session
    rc = sr_session_start(conn, SR_DS_RUNNING, &session);
    if(rc!=SR_ERR_OK){
        printf("session err rc=%d\n",rc);
    }
    printf("session created !!!\n");

    //test
    //tc_get_item(session, xpath);
    tc_get_schemas(conn);
    //tc_update_inventory(conn,session);

    // free
    if(session) sr_session_stop(session);
    if(conn) sr_disconnect(conn);
    char *json;
}

