#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>

#define server_port 9091
#define cu_id 0
#define du_id 1
#define max_cell_num 3
#define max_ue_num_per_cell 64
#define ul 0
#define dl 1
#define ull unsigned long long int

/*du*/
struct ue_info {
    int id; // [0,64]
    short mcs[2]; // [0, 28]
    int tput[2]; // kbps
    int bler[2]; // [0,100] %
    int rsrp; // [-150, -30]
    short cqi; // [0,15]
    short ulSinr; //[-30,-40] dB
};
struct cell_info {
   ull id;
   int tput[2];
   int ue_num;
   struct ue_info ue[max_ue_num_per_cell];
};

struct du_data {
    int type;
    int cell_num;
    struct cell_info cell[max_cell_num];
};

int rand_val(int min, int max){
   return (rand()%(max-min+1)+min);
}

struct du_data make_rand_du_data(){
    struct du_data data;
    bzero(&data, sizeof(data));
    int i,j;
    data.type = du_id;
    data.cell_num = rand_val(0, max_cell_num);
    for(i=0;i<data.cell_num;i++){
        data.cell[i].id = i;
        data.cell[i].tput[ul] = rand_val(200000,500000);
        data.cell[i].tput[dl] = rand_val(200000,500000);
        data.cell[i].ue_num = rand_val(0, max_ue_num_per_cell);
        for(j=0;j<data.cell[i].ue_num;j++){
            data.cell[i].ue[j].id = j;
            data.cell[i].ue[j].mcs[ul] = rand_val(0,28);
            data.cell[i].ue[j].mcs[dl] = rand_val(0,28);
            data.cell[i].ue[j].tput[ul] = rand_val(200,500);
            data.cell[i].ue[j].tput[dl] = rand_val(200,500);
            data.cell[i].ue[j].bler[ul] = rand_val(0,100);
            data.cell[i].ue[j].bler[dl] = rand_val(0,100);
            data.cell[i].ue[j].rsrp = 0 - rand_val(30,150);
            data.cell[i].ue[j].cqi = rand_val(0,15);
            data.cell[i].ue[j].ulSinr = rand_val(30,40);
        }
    }
    // print.
    printf("type:%d cell_num:%d\n",data.type,data.cell_num);
    for(i=0;i<data.cell_num;i++){
        printf("id:%lld tput[ul]:%d tput[dl]:%d ue_num:%d\n",data.cell[i].id, data.cell[i].tput[ul],data.cell[i].tput[dl], data.cell[i].ue_num);
        for(j=0;j<data.cell[i].ue_num;j++){
            printf("id:%d\tmcs[ul]:%d\tmcs[dl]:%d\ttput[ul]:%d\ttput[dl]:%d\tbler[ul]:%d\tbler[dl]:%d\trsrp:%d\tcqi:%d\tulSinr:%d\n",
                    data.cell[i].ue[j].id,
                    data.cell[i].ue[j].mcs[ul],
                    data.cell[i].ue[j].mcs[dl],
                    data.cell[i].ue[j].tput[ul],
                    data.cell[i].ue[j].tput[dl],
                    data.cell[i].ue[j].bler[ul],
                    data.cell[i].ue[j].bler[dl],
                    data.cell[i].ue[j].rsrp,
                    data.cell[i].ue[j].cqi,
                    data.cell[i].ue[j].ulSinr);
        }
    }
    return data;
}


int main(){
    int sockfd;
    struct sockaddr_in server;
    if((sockfd=socket(AF_INET, SOCK_DGRAM, 0)) == -1){
        printf("socket() err\n");
        exit(1);
    }
    bzero(&server, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(server_port);
    server.sin_addr.s_addr = inet_addr("0.0.0.0");
    while(1){
        struct du_data pkg = make_rand_du_data();
        int n = 0;
        n = sendto(sockfd, &pkg, sizeof(pkg), 0, (struct sockaddr *)&server, sizeof(server));
        if(n<0){
           printf("sendto error n=%d dataSize=%ld\n",n, sizeof(pkg));
           close(sockfd);
           break;
        }
        printf("send n=%d dataSize=%ld\n",n,sizeof(pkg));
        sleep(1);
    }
}

