#!/bin/bash
# yang 模型安装脚本
#
#	脚本会安装modules文件夹下的所有yang模型，并加载xml文件夹下的数据
# 注意：
# 
#	- 运行前需要安装好sysrepo
#	- yang 模型文件名需要和module名一致
#	- xml 数据文件名也需要和module名一致 
#   - 请以root用户运行
#

cur_path=`dirname $0`
sysrepo=`type sysrepoctl 2>&1>/dev/null`
modules_path=${cur_path}/modules
xml_path=${cur_path}/xml
module=""
SYSMODULES=(
"ietf-netconf-acm@2018-02-14.yang"
"ietf-netconf@2013-09-29.yang -e writable-running -e candidate -e rollback-on-error -e validate -e startup -e url -e xpath"
"ietf-netconf-monitoring@2010-10-04.yang"
"ietf-netconf-nmda@2019-01-07.yang -e origin -e with-defaults"
"nc-notifications@2008-07-14.yang"
"notifications@2008-07-14.yang"
"ietf-x509-cert-to-name@2014-12-10.yang"
"ietf-crypto-types@2019-07-02.yang"
"ietf-keystore@2019-07-02.yang -e keystore-supported"
"ietf-truststore@2019-07-02.yang -e truststore-supported -e x509-certificates"
"ietf-tcp-common@2019-07-02.yang -e keepalives-supported"
"ietf-ssh-server@2019-07-02.yang -e local-client-auth-supported"
"ietf-tls-server@2019-07-02.yang -e local-client-auth-supported"
"ietf-netconf-server@2019-07-02.yang -e ssh-listen -e tls-listen -e ssh-call-home -e tls-call-home")
repository=`sysrepoctl -l | head -n 1 | awk '{print $3}'`
if [[ ${sysrepo} != "" ]]; then
  printf "sysrepo\t\033[31m未安装\033[0m\n"
else
  printf "sysrepo\t\033[32m已安装\033[0m\n"
  printf "repository: \033[32m%s\033[0m\n" $repository
  echo "1. 安装yang模型"
  for f in `ls ${modules_path}`;do
    echo "* $f"
    sysrepoctl -i ${modules_path}/${f} -s ${modules_path}
  done
  for s in "${SYSMODULES[@]}";do
    name=`echo "$s" | sed 's/\([^@]*\).*/\1/'`
    INSTALLED=`echo "sysrepoctl -l" | grep "^$name \+|[^|]*| I"`
    if [ -z "$INSTALLED" ];then
        sysrepoctl -i ${modules_path}/system/$s -s ${modules_path}/system
    fi
  done
  echo "2. 加载xml数据"
  for f in `ls ${xml_path}`
  do
    module=$(echo "$f" | cut -f 1 -d '.')
    echo "* $module"
    sysrepocfg --import=${xml_path}/$f -m $module -d running
  done
fi
