#!/bin/bash
IS_YZMM_INSALL=$1
dir=$(cd `dirname $0`;pwd)
bin_dir=/yzmm/gnb/sysrepoCfgTool



# install sysrepocfgtool as service
ser_name=sysrepocfgtool.service
ser_dir=/lib/systemd/system
ser_file=$ser_dir/$ser_name
EXE=sysrepocfgtool

systemctl stop $ser_name
systemctl disable $ser_name

if [ -f "$ser_file" ];then
    rm -f $ser_file
fi
systemctl daemon-reload
sleep 2

##清空安装路径文件与备份路径
if [ -d "$bin_dir" ];then
    rm -rf $bin_dir/*
else
    mkdir -p $bin_dir
fi


##复制安装包文件至安装路径下
cd $dir

cp $dir/$EXE $bin_dir/
cp $dir/*.json $bin_dir/
cp $dir/*.sh $bin_dir/
cp $dir/*.yaml $bin_dir/
cp $dir/sysCfgTool_server* $bin_dir/
cp $dir/$ser_name $bin_dir/
cp $dir/$ser_name $ser_dir/

chmod 777 $bin_dir/$EXE
chmod 777 $bin_dir/*.sh

cp $bin_dir/$ser_name $ser_dir

systemctl disable $ser_name
systemctl daemon-reload

if [ "$IS_YZMM_INSALL" != 1 ];then
    echo "sysrepocfgtool.service will be started after 5 seconds..."
    sleep 5
    systemctl start $ser_name
    systemctl status $ser_name
fi
